/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.infolist;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.domain.infolist.SystemInfoListItemCode;
import org.squashtest.tm.domain.infolist.SystemListItem;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.exception.infolist.CannotDeleteDefaultInfoListItemException;
import org.squashtest.tm.service.annotation.CachableType;
import org.squashtest.tm.service.annotation.CacheResult;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.repository.InfoListItemDao;

@Transactional
@Service(value="squashtest.tm.service.InfoListItemManagerService")
public class InfoListItemManagerServiceImpl
implements InfoListItemManagerService {
    @Inject
    private InfoListItemDao itemDao;
    @Inject
    private InfoListManagerService infoListService;

    @Override
    public SystemListItem getSystemRequirementCategory() {
        return this.itemDao.getSystemRequirementCategory();
    }

    @Override
    public SystemListItem getSystemTestCaseNature() {
        return this.itemDao.getSystemTestCaseNature();
    }

    @Override
    public void changeCode(long infoListItemId, String newCode) {
        this.checkIfCodeAlreadyExists(infoListItemId, newCode);
        this.checkCodePattern(newCode);
        InfoListItem item = (InfoListItem)this.itemDao.getReferenceById(infoListItemId);
        SystemInfoListItemCode.verifyModificationPermission((InfoListItem)item);
        item.setCode(newCode);
    }

    @Override
    public void checkIfCodeAlreadyExists(String desiredCode) {
        InfoListItem item = this.findByCode(desiredCode);
        if (item != null) {
            throw new CodeAlreadyExistsException();
        }
    }

    @Override
    public void checkIfCodeAlreadyExists(long infoListItemToIgnore, String desiredCode) {
        InfoListItem item = this.findByCode(desiredCode);
        if (item != null && item.getId() != infoListItemToIgnore) {
            throw new CodeAlreadyExistsException();
        }
    }

    @Override
    public void checkCodePattern(String code) {
        this.infoListService.checkCodeHasValidPattern(code);
    }

    @Override
    public void changeColour(long infoListItemId, String newColour) {
        InfoListItem item = (InfoListItem)this.itemDao.getReferenceById(infoListItemId);
        SystemInfoListItemCode.verifyModificationPermission((InfoListItem)item);
        item.setColour(newColour);
    }

    @Override
    public void changeLabel(long infoListItemId, String newLabel) {
        InfoListItem item = (InfoListItem)this.itemDao.getReferenceById(infoListItemId);
        SystemInfoListItemCode.verifyModificationPermission((InfoListItem)item);
        item.setLabel(newLabel);
    }

    @Override
    public void changeDefault(long infoListItemId) {
        InfoListItem changedItem = (InfoListItem)this.itemDao.getReferenceById(infoListItemId);
        SystemInfoListItemCode.verifyModificationPermission((InfoListItem)changedItem);
        List items = changedItem.getInfoList().getItems();
        for (InfoListItem item : items) {
            item.setDefault(false);
        }
        changedItem.setDefault(true);
    }

    @Override
    public void changeIcon(long infoListItemId, String icon) {
        InfoListItem item = (InfoListItem)this.itemDao.getReferenceById(infoListItemId);
        SystemInfoListItemCode.verifyModificationPermission((InfoListItem)item);
        item.setIconName(icon);
    }

    @Override
    public void addInfoListItem(long infoListId, InfoListItem item) {
        InfoList infoList = this.infoListService.findById(infoListId);
        SystemInfoListCode.verifyModificationPermission((InfoList)infoList);
        if (infoList.getItems().isEmpty()) {
            item.setDefault(true);
        }
        item.setInfoList(infoList);
        this.itemDao.save(item);
        infoList.addItem(item);
    }

    @Override
    public SystemListItem getSystemTestCaseType() {
        return this.itemDao.getSystemTestCaseType();
    }

    @Override
    public InfoListItem findById(Long id) {
        return (InfoListItem)this.itemDao.getReferenceById(id);
    }

    @Override
    public InfoListItem findByCode(String code) {
        return this.itemDao.findByCode(code);
    }

    @Override
    public InfoListItem findReference(ListItemReference reference) {
        return this.itemDao.findByCode(reference.getCode());
    }

    @Override
    public InfoListItem findDefaultRequirementCategory(long projectId) {
        return this.itemDao.findDefaultRequirementCategory(projectId);
    }

    @Override
    public InfoListItem findDefaultTestCaseNature(long projectId) {
        return this.itemDao.findDefaultTestCaseNature(projectId);
    }

    @Override
    public InfoListItem findDefaultTestCaseType(long projectId) {
        return this.itemDao.findDefaultTestCaseType(projectId);
    }

    @Override
    @CacheResult(type=CachableType.CATEGORY)
    public boolean isCategoryConsistent(long projectId, String itemCode) {
        return this.itemDao.isCategoryConsistent(projectId, itemCode);
    }

    @Override
    public Set<String> filterConsistentCategories(long projectId, Collection<String> codes) {
        if (codes.isEmpty()) {
            return Collections.emptySet();
        }
        return this.itemDao.filterConsistentCategories(projectId, codes);
    }

    @Override
    @CacheResult(type=CachableType.NATURE)
    public boolean isNatureConsistent(long projectId, String itemCode) {
        return this.itemDao.isNatureConsistent(projectId, itemCode);
    }

    @Override
    public Set<String> filterConsistentNatures(long projectId, Collection<String> codes) {
        if (codes.isEmpty()) {
            return Collections.emptySet();
        }
        return this.itemDao.filterConsistentNatures(projectId, codes);
    }

    @Override
    @CacheResult(type=CachableType.TYPE)
    public boolean isTypeConsistent(long projectId, String itemCode) {
        return this.itemDao.isTypeConsistent(projectId, itemCode);
    }

    @Override
    public Set<String> filterConsistentTypes(long projectId, Collection<String> codes) {
        if (codes.isEmpty()) {
            return Collections.emptySet();
        }
        return this.itemDao.filterConsistentTypes(projectId, codes);
    }

    @Override
    public boolean isUsed(long infoListItemId) {
        return this.itemDao.isUsed(infoListItemId);
    }

    @Override
    public void removeInfoListItem(long infoListItemId, long infoListId) {
        InfoListItem defaultItem;
        InfoList infoList = this.infoListService.findById(infoListId);
        InfoListItem item = this.findById(infoListItemId);
        if (item.references((Object)(defaultItem = infoList.getDefaultItem()))) {
            throw new CannotDeleteDefaultInfoListItemException("cannot delete this item : it is default item of its list");
        }
        infoList.removeItem(item);
        this.itemDao.removeInfoListItem(infoListItemId, defaultItem);
        this.itemDao.delete(item);
    }

    @Override
    public void removeInfoListItems(List<Long> infoListItemIds, long infoListId) {
        infoListItemIds.forEach(itemId -> this.removeInfoListItem((long)itemId, infoListId));
    }
}

