/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;

public final class FilterModel {
    private List<Object[]> projectData = new ArrayList<Object[]>();
    private boolean enabled;
    private Long id;

    public FilterModel() {
    }

    public FilterModel(ProjectFilter filter, List<Project> projects) {
        this.setEnabled(filter.getActivated());
        Object[][] pData = new Object[projects.size()][4];
        int i = 0;
        for (Project project : projects) {
            pData[i] = new Object[]{project.getId(), project.getName(), filter.isProjectSelected((GenericProject)project), project.getLabel()};
            ++i;
        }
        this.setProjectData(pData);
    }

    public FilterModel(List<Project> projects) {
        for (Project project : projects) {
            this.addProject(project.getId(), project.getName(), project.getLabel());
        }
    }

    public Object[] getProjectData() {
        return this.projectData.toArray();
    }

    private void setProjectData(Object[][] projectData) {
        this.projectData = new ArrayList<Object[]>(projectData.length);
        Collections.addAll(this.projectData, projectData);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean activated) {
        this.enabled = activated;
    }

    public void addProject(long id, String name, String label) {
        this.projectData.add(new Object[]{id, name, false, label});
    }

    public void addProject(long id, String name, boolean selected, String label) {
        this.projectData.add(new Object[]{id, name, selected, label});
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterModel that = (FilterModel)o;
        return this.id != null && this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

