/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search.filter;

import com.google.common.collect.Sets;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.Set;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.jpql.ExtendedHibernateQuery;
import org.squashtest.tm.domain.requirement.QHighLevelRequirement;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.search.filter.FilterHandler;

@Component
public class HighLevelReqLinkedReqCountFilterHandler
implements FilterHandler {
    private final Set<String> handledPrototypes = Sets.newHashSet((Object[])new String[]{"HIGH_LEVEL_REQUIREMENT_LINKEDREQCOUNT"});

    @Override
    public boolean canHandleFilter(GridFilterValue filter) {
        return this.handledPrototypes.contains(filter.getColumnPrototype());
    }

    @Override
    public void handleFilter(ExtendedHibernateQuery<?> query, GridFilterValue filter, GridRequest gridRequest) {
        QRequirement requirement2 = new QRequirement("requirement2");
        QHighLevelRequirement highLevelRequirement = new QHighLevelRequirement("highLevelRequirement");
        HibernateQuery subquery = (HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)new ExtendedHibernateQuery().select((Expression)Expressions.ONE).from((EntityPath)requirement2)).rightJoin((EntityPath)highLevelRequirement)).on((Predicate)highLevelRequirement.id.eq((Expression)requirement2.highLevelRequirement.id))).where((Predicate)QRequirement.requirement.id.eq((Expression)highLevelRequirement.id))).groupBy((Expression)requirement2.highLevelRequirement.id);
        this.appendHavingClause((HibernateQuery<Integer>)subquery, requirement2.highLevelRequirement, filter);
        query.where((Predicate)subquery.exists());
    }

    private void appendHavingClause(HibernateQuery<Integer> subquery, QHighLevelRequirement highLevelReq, GridFilterValue filter) {
        int min = Integer.parseInt(filter.getValues().get(0));
        switch (filter.getOperation()) {
            case "BETWEEN": {
                int max = Integer.parseInt(filter.getValues().get(1));
                subquery.having((Predicate)highLevelReq.id.count().between((Number)min, (Number)max));
                break;
            }
            case "GREATER": {
                subquery.having((Predicate)highLevelReq.id.count().gt((Number)min));
                break;
            }
            case "GREATER_EQUAL": {
                subquery.having((Predicate)highLevelReq.id.count().goe((Number)min));
                break;
            }
            case "LOWER": {
                subquery.having((Predicate)highLevelReq.id.count().lt((Number)min));
                break;
            }
            case "LOWER_EQUAL": {
                subquery.having((Predicate)highLevelReq.id.count().loe((Number)min));
                break;
            }
            case "EQUALS": {
                subquery.having((Predicate)highLevelReq.id.count().eq((Object)min));
                break;
            }
            case "NOT_EQUALS": {
                subquery.having((Predicate)highLevelReq.id.count().ne((Object)min));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation");
            }
        }
    }
}

