/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.BetweenConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.EqualConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.FulltextConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.GreaterConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterOperation;
import org.squashtest.tm.service.internal.display.grid.filters.InConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.LikeConditionBuilder;
import org.squashtest.tm.service.internal.display.grid.filters.LowerConditionBuilder;

public interface GridFilterConditionBuilder {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$squashtest$tm$service$internal$display$grid$filters$GridFilterOperation;

    public Condition build();

    public static GridFilterConditionBuilder getConditionBuilder(Field<?> field, GridFilterValue gridFilterValue) {
        Objects.requireNonNull(gridFilterValue.getOperation());
        GridFilterOperation operation = GridFilterOperation.valueOf(gridFilterValue.getOperation());
        return GridFilterConditionBuilder.getConditionBuilder(field, gridFilterValue, operation);
    }

    public static GridFilterConditionBuilder getConditionBuilder(Field<?> field, GridFilterValue gridFilterValue, GridFilterOperation operation) {
        Objects.requireNonNull(gridFilterValue);
        return switch (operation) {
            case GridFilterOperation.LIKE -> new LikeConditionBuilder(field, gridFilterValue);
            case GridFilterOperation.IN -> new InConditionBuilder(field, gridFilterValue);
            case GridFilterOperation.BETWEEN -> new BetweenConditionBuilder(field, gridFilterValue);
            case GridFilterOperation.EQUALS -> new EqualConditionBuilder(field, gridFilterValue, false);
            case GridFilterOperation.NOT_EQUALS -> new EqualConditionBuilder(field, gridFilterValue, true);
            case GridFilterOperation.GREATER -> new GreaterConditionBuilder(field, gridFilterValue, false);
            case GridFilterOperation.GREATER_EQUAL -> new GreaterConditionBuilder(field, gridFilterValue, true);
            case GridFilterOperation.LOWER -> new LowerConditionBuilder(field, gridFilterValue, false);
            case GridFilterOperation.LOWER_EQUAL -> new LowerConditionBuilder(field, gridFilterValue, true);
            case GridFilterOperation.FULLTEXT -> new FulltextConditionBuilder(field, gridFilterValue);
            default -> throw new IllegalArgumentException("No GridFilterConditionBuilder for operation " + String.valueOf((Object)operation));
        };
    }

    public static <T> T getGridFilterValueConvert(Field<T> target, String value) {
        Class clazz = target.getDataType().getType();
        return (T)GridFilterConditionBuilder.getConverters().getOrDefault(clazz, s -> {
            throw new IllegalArgumentException(String.format("No GridFilterValueConvert for type %s", clazz));
        }).apply(value);
    }

    private static Map<Class<?>, Function<String, ?>> getConverters() {
        return Map.of(String.class, s -> s, Integer.class, Integer::valueOf, Long.class, Long::valueOf, Double.class, Double::valueOf, BigDecimal.class, BigDecimal::new, Timestamp.class, s -> Timestamp.valueOf(LocalDate.parse(s).atStartOfDay()));
    }
}

