/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.administration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class BugTrackerGrid
extends AbstractGrid {
    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"SERVER_ID")), new GridColumn(DSL.field((String)"NAME")), new GridColumn(DSL.field((String)"KIND")), new GridColumn(DSL.field((String)"URL")), new GridColumn(DSL.field((String)"SYNCHRONISATION_COUNT").as("SYNCHRONISATION_COUNT")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, Integer>> externalSynchronisationCount = this.getExternalSynchronisationCount();
        return DSL.select((SelectField)Tables.THIRD_PARTY_SERVER.SERVER_ID.as("SERVER_ID"), (SelectField)Tables.THIRD_PARTY_SERVER.NAME.as("NAME"), (SelectField)Tables.BUGTRACKER.BUGTRACKER_ID, (SelectField)Tables.BUGTRACKER.KIND.as("KIND"), (SelectField)Tables.THIRD_PARTY_SERVER.URL.as("URL"), (SelectField)DSL.coalesce((Object)DSL.max((Field)externalSynchronisationCount.field("SYNCHRONISATION_COUNT")), (Object[])new Serializable[]{DSL.count((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID), Integer.valueOf(0)}).as("SYNCHRONISATION_COUNT")).from((TableLike)Tables.THIRD_PARTY_SERVER).join((TableLike)Tables.BUGTRACKER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.SERVER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).leftJoin(externalSynchronisationCount).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq(externalSynchronisationCount.field("SERVER_ID", Long.class))).groupBy(new GroupField[]{Tables.THIRD_PARTY_SERVER.SERVER_ID, Tables.BUGTRACKER.BUGTRACKER_ID}).asTable();
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((String)"SERVER_ID");
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.upper((Field)DSL.field((String)"NAME", String.class)).asc();
    }

    private SelectHavingStep<Record2<Long, Integer>> getExternalSynchronisationCount() {
        List<String> pluginIds = Arrays.asList("squash.tm.plugin.redminereq", "squash.tm.plugin.jirareq");
        return DSL.select((SelectField)Tables.LIBRARY_PLUGIN_BINDING_PROPERTY.PLUGIN_BINDING_VALUE.cast(Long.class).as("SERVER_ID"), (SelectField)DSL.count((Field)Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_BINDING_ID).as("SYNCHRONISATION_COUNT")).from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).innerJoin((TableLike)Tables.LIBRARY_PLUGIN_BINDING_PROPERTY).on(Tables.LIBRARY_PLUGIN_BINDING_PROPERTY.PLUGIN_BINDING_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_BINDING_ID)).where(Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID.in(pluginIds).and(Tables.LIBRARY_PLUGIN_BINDING_PROPERTY.PLUGIN_BINDING_KEY.eq((Object)"serverId"))).groupBy(new GroupField[]{DSL.field((String)"SERVER_ID")});
    }
}

