/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.dto;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.service.internal.display.attachment.FileViewerExtension;

public final class FileViewerRequest {
    final String source;
    final String fileName;
    final FileViewerExtension fileType;
    final boolean isAttachment;
    final String target;

    private FileViewerRequest(String source, String fileName, FileViewerExtension fileType, boolean isAttachment) {
        this.source = source;
        this.fileType = fileType;
        this.fileName = fileName;
        this.isAttachment = isAttachment;
        this.target = null;
    }

    private FileViewerRequest(String source, String fileName, FileViewerExtension fileType, boolean isAttachment, String target) {
        this.source = source;
        this.fileName = fileName;
        this.fileType = fileType;
        this.isAttachment = isAttachment;
        this.target = target;
    }

    public static FileViewerRequest fromAttachment(Attachment attachment, String target) {
        String attachmentId = attachment.getId().toString();
        if (target != null) {
            String type = target.substring(target.lastIndexOf(".") + 1);
            FileViewerExtension targetType = FileViewerRequest.findViewerType(type);
            String targetName = target.substring(target.lastIndexOf("/") + 1);
            return new FileViewerRequest(attachmentId, targetName, targetType, true, target);
        }
        String attachmentName = attachment.getName().replace(" ", "_");
        FileViewerExtension attachmentType = FileViewerRequest.findViewerType(attachment.getType());
        return new FileViewerRequest(attachmentId, attachmentName, attachmentType, true);
    }

    public static FileViewerRequest fromFile(File file) {
        String formattedName = file.getName().replace(" ", "_");
        String fileExtension = FilenameUtils.getExtension((String)formattedName);
        FileViewerExtension fileType = FileViewerRequest.findViewerType(fileExtension);
        return new FileViewerRequest(file.getAbsolutePath(), formattedName, fileType, false);
    }

    private static FileViewerExtension findViewerType(String type) {
        return Arrays.stream(FileViewerExtension.values()).filter(extension -> extension.name().equalsIgnoreCase(type)).findAny().orElse(null);
    }

    public String getSource() {
        return this.source;
    }

    public FileViewerExtension getFileType() {
        return this.fileType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isAttachment() {
        return this.isAttachment;
    }

    public String getTarget() {
        return this.target;
    }
}

