/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.attachment;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.service.annotation.CheckEntityExists;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.attachment.AttachmentFinderService;
import org.squashtest.tm.service.display.attachment.AttachmentDisplayService;
import org.squashtest.tm.service.internal.display.dto.AttachmentListDto;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;

@Service
@Transactional(readOnly=true)
public class AttachmentDisplayServiceImpl
implements AttachmentDisplayService {
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final AttachmentFinderService attachmentFinderService;

    public AttachmentDisplayServiceImpl(AttachmentDisplayDao attachmentDisplayDao, AttachmentFinderService attachmentFinderService) {
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.attachmentFinderService = attachmentFinderService;
    }

    @Override
    @CheckEntityExists(entityType=AttachmentList.class)
    public AttachmentListDto getAttachmentList(@Id long attachmentListId) {
        this.attachmentFinderService.checkReadPermissionOnProjectByAttachmentListId(attachmentListId);
        return this.attachmentDisplayDao.findAttachmentListById(attachmentListId);
    }
}

