/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.deletion.LinkedToIterationPreviewReport;
import org.squashtest.tm.service.deletion.NotDeletablePreviewReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.campaign.LockedTestCaseNodeDetectionService;
import org.squashtest.tm.service.internal.deletion.AbstractLockedNodeDetectionService;
import org.squashtest.tm.service.internal.deletion.LockedFileInferenceGraph;
import org.squashtest.tm.service.internal.deletion.LockedTestCaseNodeDetectionServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.deletion.LockedTestCaseNodeDetectionServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Service
public class LockedTestCaseNodeDetectionServiceImpl
extends AbstractLockedNodeDetectionService
implements LockedTestCaseNodeDetectionService {
    private static final String TEST_CASES_TYPE = "test-cases";
    private final TestCaseDeletionDao deletionDao;
    private final TestCaseDao testCaseDao;
    private final TestCaseCallTreeFinder calltreeFinder;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Autowired
    public LockedTestCaseNodeDetectionServiceImpl(ActiveMilestoneHolder activeMilestoneHolder, TestCaseDeletionDao deletionDao, TestCaseDao testCaseDao, TestCaseCallTreeFinder calltreeFinder) {
        super(activeMilestoneHolder);
        this.deletionDao = deletionDao;
        this.testCaseDao = testCaseDao;
        this.calltreeFinder = calltreeFinder;
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByCallSteps(List<Long> nodeIds, List<SuppressionPreviewReport> testCaseReports) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        ArrayList<Long> candidateIds = new ArrayList<Long>(nodeIds);
        candidateIds.removeAll(this.getLockedByMilestoneRule(testCaseReports));
        LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> calltree = this.calltreeFinder.getCallerGraph(candidateIds);
        LockedFileInferenceGraph graph = new LockedFileInferenceGraph();
        graph.init(calltree);
        graph.setCandidatesToDeletion(candidateIds);
        graph.resolveLockedFiles();
        if (graph.hasLockedFiles()) {
            NotDeletablePreviewReport report = new NotDeletablePreviewReport();
            graph.collectLockedCandidates().forEach(node -> report.addName(node.getName()));
            graph.collectLockers().forEach(node -> report.addWhy(node.getName()));
            graph.collectLockedCandidates().forEach(node -> report.addLockedNode(((NamedReference)node.getKey()).getId()));
            reportList.add(report);
        }
        return reportList;
    }

    private List<Long> getLockedByMilestoneRule(List<SuppressionPreviewReport> testCaseReports) {
        return testCaseReports.stream().filter(SuppressionPreviewReport::isMilestoneReport).flatMap(report -> report.getLockedNodes().stream()).toList();
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByExecutedTestCases(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        List linkedNodes = this.testCaseDao.findAllLinkedToIteration(nodeIds);
        if (!linkedNodes.isEmpty()) {
            LinkedToIterationPreviewReport report = new LinkedToIterationPreviewReport();
            linkedNodes.forEach(node -> report.addName(node.getName()));
            reportList.add(report);
        }
        return reportList;
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByMilestone(List<Long> nodeIds) {
        return super.detectLockedByMilestone(nodeIds, TEST_CASES_TYPE);
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedWithActiveMilestone(List<Long> nodeIds) {
        return super.detectLockedWithActiveMilestone(nodeIds, TEST_CASES_TYPE);
    }

    @Override
    protected Map<String, List<Long>> getIdsSeparateFolderFromNodeIds(List<Long> nodeIds) {
        return this.deletionDao.separateFolderFromTestCaseIds(nodeIds);
    }

    @Override
    protected List<Long> findNodeIdsHavingMultipleMilestones(List<Long> nodeIds) {
        List<Long> list = nodeIds;
        TestCaseDao testCaseDao = this.testCaseDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)testCaseDao, list);
        Object[] objectArray = new Object[]{this, testCaseDao, list, joinPoint};
        LockedTestCaseNodeDetectionServiceImpl$AjcClosure1 lockedTestCaseNodeDetectionServiceImpl$AjcClosure1 = new LockedTestCaseNodeDetectionServiceImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(lockedTestCaseNodeDetectionServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    @Override
    protected List<Long> findNodesWhichMilestonesForbidsDeletion(List<Long> nodeIds) {
        return this.deletionDao.findTestCasesWhichMilestonesForbidsDeletion(nodeIds);
    }

    @Override
    protected void addAdditionalReportWithActiveMilestoneToReportList(List<Long> nodeIds, Long activeMilestoneId, List<SuppressionPreviewReport> reportList, String reportType) {
        Long l = activeMilestoneId;
        List<Long> list = nodeIds;
        TestCaseDao testCaseDao = this.testCaseDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)testCaseDao, list, (Object)l);
        Object[] objectArray = new Object[]{this, testCaseDao, list, l, joinPoint};
        LockedTestCaseNodeDetectionServiceImpl$AjcClosure3 lockedTestCaseNodeDetectionServiceImpl$AjcClosure3 = new LockedTestCaseNodeDetectionServiceImpl$AjcClosure3(objectArray);
        List nonBoundNodes = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(lockedTestCaseNodeDetectionServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        this.addNonBoundNodesWithActiveMilestoneToReportList(nonBoundNodes, reportList, reportType);
    }

    static {
        LockedTestCaseNodeDetectionServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findNodeIdsHavingMultipleMilestones_aroundBody0(LockedTestCaseNodeDetectionServiceImpl lockedTestCaseNodeDetectionServiceImpl, TestCaseDao testCaseDao, Collection collection, JoinPoint joinPoint) {
        return testCaseDao.findNodeIdsHavingMultipleMilestones(collection);
    }

    static final /* synthetic */ List findNonBoundTestCases_aroundBody2(LockedTestCaseNodeDetectionServiceImpl lockedTestCaseNodeDetectionServiceImpl, TestCaseDao testCaseDao, Collection collection, Long l, JoinPoint joinPoint) {
        return testCaseDao.findNonBoundTestCases(collection, l);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LockedTestCaseNodeDetectionServiceImpl.java", LockedTestCaseNodeDetectionServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findNodeIdsHavingMultipleMilestones", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection", "arg0", "", "java.util.List"), 128);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findNonBoundTestCases", "org.squashtest.tm.service.internal.repository.TestCaseDao", "java.util.Collection:java.lang.Long", "arg0:arg1", "", "java.util.List"), 141);
    }
}

