/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVPrinter;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Record5;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.export.CampaignExportWriter;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportRows;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.FileDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

public abstract class AbstractCampaignExport {
    protected static final Integer BATCH_SIZE = 200;
    protected static final Field<Integer> EXECUTION_POSITION_FIELD = DSL.field((String)"execution_position", Integer.class);
    protected final DSLContext dsl;
    protected final CampaignExportWriter campaignExportWriter;
    protected final FeatureManager featureManager;

    protected AbstractCampaignExport(DSLContext dsl, CampaignExportWriter campaignExportWriter, FeatureManager featureManager) {
        this.dsl = dsl;
        this.campaignExportWriter = campaignExportWriter;
        this.featureManager = featureManager;
    }

    protected Table<Record3<Long, Long, Integer>> getLastestExecution(Long campaignId) {
        return DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, (SelectField)Tables.EXECUTION.EXECUTION_ID, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.EXECUTION.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()}).as(EXECUTION_POSITION_FIELD)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).asTable();
    }

    protected ResultQuery<Record2<String, String>> getCufHeaderQuery(Long campaignId, List<BindableEntity> bindableEntities) {
        List<String> bindableEntityNames = bindableEntities.stream().map(Enum::name).toList();
        Table cufTable = DSL.select((SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD.CODE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Object)campaignId)).and(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.in(bindableEntityNames)).union((Select)DSL.select((SelectField)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY, (SelectField)Tables.CUSTOM_FIELD.CODE).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull()).and(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.eq((Object)BindableEntity.TEST_CASE.name()))).asTable();
        return this.dsl.select((SelectField)Objects.requireNonNull(cufTable.field((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY)).as((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY), (SelectField)Objects.requireNonNull(cufTable.field((Field)Tables.CUSTOM_FIELD.CODE)).as((Field)Tables.CUSTOM_FIELD.CODE)).from((TableLike)cufTable).groupBy(new GroupField[]{cufTable.field((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY), cufTable.field((Field)Tables.CUSTOM_FIELD.CODE)});
    }

    private <R extends Record> ResultQuery<Record5<Long, Long, String, String, String>> getCufQuery(Table<R> entityTable, Field<Long> entityIdField, BindableEntity bindableEntity) {
        return this.dsl.select((SelectField)entityIdField.as("ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID, (SelectField)Tables.CUSTOM_FIELD.CODE, (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE, (SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.CF.name()), (Field)CustomFieldValueType.CF.getValueColumn()).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.RTF.name()), (Field)CustomFieldValueType.RTF.getValueColumn()).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.NUM.name()), DSL.coalesce((Field)CustomFieldValueType.NUM.getValueColumn(), (Object)"")).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.TAG.name()), (Field)DSL.groupConcat((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL).separator(" | ")).otherwise((Object)"").as((Field)Tables.CUSTOM_FIELD_VALUE.VALUE)).from(entityTable).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq(entityIdField)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)bindableEntity.name())).groupBy(new GroupField[]{entityIdField, Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD.CODE, Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE});
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getCampaignCufQuery(Long campaignId) {
        Table table = DSL.select((SelectField)Tables.CAMPAIGN.CLN_ID).from((TableLike)Tables.CAMPAIGN).where(Tables.CAMPAIGN.CLN_ID.eq((Object)campaignId)).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN.CLN_ID)), BindableEntity.CAMPAIGN);
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getIterationCufQuery(Long campaignId) {
        Table table = DSL.select((SelectField)Tables.CAMPAIGN_ITERATION.ITERATION_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)), BindableEntity.ITERATION);
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getTestCaseCufQuery(Long campaignId) {
        Table table = DSL.select((SelectField)Tables.TEST_PLAN_ITEM.TCLN_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull()).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)), BindableEntity.TEST_CASE);
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getExecutionCufQuery(Long campaignId) {
        Table<Record3<Long, Long, Integer>> lastExecution = this.getLastestExecution(campaignId);
        Table table = DSL.select((SelectField)Objects.requireNonNull(lastExecution.field((Field)Tables.EXECUTION.EXECUTION_ID)).as((Field)Tables.EXECUTION.EXECUTION_ID)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join(lastExecution).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastExecution.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull()).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.EXECUTION.EXECUTION_ID)), BindableEntity.EXECUTION);
    }

    public ResultQuery<Record5<Long, Long, String, String, String>> getExecutionStepCufQuery(Long campaignId) {
        Table<Record3<Long, Long, Integer>> lastExecution = this.getLastestExecution(campaignId);
        Table table = DSL.select((SelectField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join(lastExecution).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastExecution.field((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).join((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq(lastExecution.field((Field)Tables.EXECUTION.EXECUTION_ID))).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Object)campaignId)).and(Tables.TEST_PLAN_ITEM.TCLN_ID.isNotNull()).orderBy((OrderField)Tables.CAMPAIGN_ITERATION.ITERATION_ORDER, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER, (OrderField)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER).asTable();
        return this.getCufQuery(table, (Field<Long>)Objects.requireNonNull(table.field((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID)), BindableEntity.EXECUTION_STEP);
    }

    protected CustomFieldValueDto toCustomFieldValueDto(Record record) {
        String value = (String)record.get((Field)Tables.CUSTOM_FIELD_VALUE.VALUE);
        if (CustomFieldValueType.NUM.name().equals(record.get((Field)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE))) {
            value = NumericCufHelper.formatOutputNumericCufValue(value);
        }
        value = this.adaptHtmlImageAttribute(value);
        return new CustomFieldValueDto((Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID), (Long)record.get(DSL.field((String)"ID", Long.class)), value, (String)record.get((Field)Tables.CUSTOM_FIELD.CODE));
    }

    private String adaptHtmlImageAttribute(String html) {
        if (Objects.isNull(html)) {
            return null;
        }
        Document document = Jsoup.parse((String)html);
        Elements elements = document.select("img");
        if (!elements.isEmpty()) {
            elements.forEach(element -> {
                String imageSrc = element.attr("src");
                if (!imageSrc.contains("data:image")) {
                    element.attr("alt", imageSrc);
                }
            });
            return document.body().html();
        }
        return html;
    }

    protected boolean milestoneIsEnabled() {
        return this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
    }

    public void doExport(File exportFile, Long campaignId, CampaignExportMode exportMode) {
        boolean milestonesEnabled = this.milestoneIsEnabled();
        CampaignExportRows campaignExportRows = new CampaignExportRows(exportMode, milestonesEnabled);
        this.addCufHeader(campaignId, campaignExportRows);
        CalculateOrder calculateOrder = new CalculateOrder();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CSVPrinter csvPrinter = this.campaignExportWriter.getWriter(exportFile);){
                this.campaignExportWriter.write(csvPrinter, campaignExportRows.getHeaders());
                this.processExport(campaignId, campaignExportRows, milestonesEnabled, calculateOrder, csvPrinter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new ActionException("campaign export : I/O failure while creating the export file", (Throwable)exception);
        }
    }

    private void addCufHeader(Long campaignId, CampaignExportRows campaignExportRows) {
        List<BindableEntity> bindableEntities = this.getBindableEntities();
        if (bindableEntities.isEmpty()) {
            return;
        }
        Map cufCodesByBindableEntity = this.getCufHeaderQuery(campaignId, bindableEntities).fetchGroups(record -> BindableEntity.valueOf((String)((String)record.get((Field)Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY))), record -> (String)record.get((Field)Tables.CUSTOM_FIELD.CODE));
        campaignExportRows.addCufHeaders(cufCodesByBindableEntity);
    }

    protected void addCufValue(Record record, Field<Long> idField, CampaignExportRows campaignExportRows, BindableEntity bindableEntity, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessor, Map<BindableEntity, List<CustomFieldValueDto>> cufStorage) {
        Long id = (Long)record.get(idField);
        if (Objects.isNull(id) || !cufProcessor.containsKey(bindableEntity)) {
            return;
        }
        List<CustomFieldValueDto> cufValueStorage = cufStorage.get(bindableEntity);
        if (cufValueStorage.isEmpty()) {
            List<CustomFieldValueDto> cufValues = cufProcessor.get(bindableEntity).getSubElements(id, false);
            campaignExportRows.addValue(CampaignExportHeader.fromBindableEntity(bindableEntity), cufValues);
            cufStorage.put(bindableEntity, cufValues);
        } else if (this.isSameId(id, cufValueStorage)) {
            campaignExportRows.addValue(CampaignExportHeader.fromBindableEntity(bindableEntity), cufValueStorage);
        } else {
            cufValueStorage.clear();
            List<CustomFieldValueDto> cufValues = cufProcessor.get(bindableEntity).getSubElements(id, false);
            campaignExportRows.addValue(CampaignExportHeader.fromBindableEntity(bindableEntity), cufValues);
            cufStorage.replace(bindableEntity, cufValues);
        }
    }

    private boolean isSameId(Long id, List<CustomFieldValueDto> customFieldValueDtos) {
        return id.equals(customFieldValueDtos.getFirst().getBoundEntityId());
    }

    private void processExport(Long campaignId, CampaignExportRows campaignExportRows, boolean milestonesEnabled, CalculateOrder calculateOrder, CSVPrinter csvPrinter) {
        Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors = null;
        Map<BindableEntity, List> cufStorage = this.getBindableEntities().stream().collect(Collectors.toMap(bindableEntity -> bindableEntity, bindableEntity -> new ArrayList()));
        try {
            Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> finalCufProcessors = cufProcessors = this.getCufProcessor(campaignId);
            this.getQuery(campaignId).fetchStream().forEach(record -> {
                Map<String, String> row = this.exportData((Record)record, campaignExportRows, milestonesEnabled, calculateOrder, finalCufProcessors, (Map<BindableEntity, List<CustomFieldValueDto>>)cufStorage);
                this.campaignExportWriter.write(csvPrinter, row.values());
            });
        }
        finally {
            if (cufProcessors != null) {
                cufProcessors.values().forEach(SubElementRecordProcessor::close);
            }
        }
    }

    protected <R extends Record> SubElementRecordProcessor<CustomFieldValueDto> getCufProcessor(ResultQuery<R> query) {
        return new SubElementRecordProcessor<CustomFieldValueDto>(query, (Field<Long>)DSL.field((String)"ID", Long.class), (Field<Long>)Tables.CUSTOM_FIELD_VALUE.CFV_ID, this::toCustomFieldValueDto, CustomFieldValueDto.class);
    }

    protected abstract ResultQuery<Record> getQuery(Long var1);

    protected abstract List<BindableEntity> getBindableEntities();

    protected abstract Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessor(Long var1);

    protected abstract Map<String, String> exportData(Record var1, CampaignExportRows var2, boolean var3, CalculateOrder var4, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> var5, Map<BindableEntity, List<CustomFieldValueDto>> var6);

    public FileDto getExportFile(CampaignExportMode exportMode, String campaignName) {
        try {
            String fileName = AbstractCampaignExport.buildFileName(exportMode, campaignName);
            String extension = ".csv";
            File file = File.createTempFile(fileName, extension);
            file.deleteOnExit();
            return new FileDto(fileName, file, extension);
        }
        catch (IOException e) {
            throw new ActionException("campaign export : I/O failure while creating the temporary file", (Throwable)e);
        }
    }

    private static String buildFileName(CampaignExportMode exportMode, String campaignName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String encodedCampaignName = URLEncoder.encode(campaignName, StandardCharsets.UTF_8).replace(" ", "_");
        return String.format("EXPORT_CPG_%s_%s_%s", exportMode.getCode(), encodedCampaignName, sdf.format(new Date()));
    }

    protected static class CalculateOrder {
        private Long stepOrder = 1L;
        private Long tpiId;

        protected CalculateOrder() {
        }

        public Long getNextStep(Long tpiId) {
            if (Objects.isNull(tpiId) || !tpiId.equals(this.tpiId)) {
                this.setTpiId(tpiId);
                this.resetStepOrder();
            }
            Long l = this.stepOrder;
            this.stepOrder = l + 1L;
            return l;
        }

        private void setTpiId(Long tpiId) {
            this.tpiId = tpiId;
        }

        private void resetStepOrder() {
            this.stepOrder = 1L;
        }
    }
}

