/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record6;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.bugtracker.knownissues.local.ExecutionLocalKnownIssue;
import org.squashtest.tm.service.bugtracker.knownissues.local.LocalKnownIssue;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.BaseLocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.LocalKnownIssueFinderHelper;

@Repository(value="executionKnownIssueFinder")
@Transactional(readOnly=true)
public class ExecutionKnownIssueFinder
extends BaseLocalKnownIssueFinder<Record6<Long, Long, String, String, String, String>> {
    public ExecutionKnownIssueFinder(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public int countKnownIssues(Long executionId) {
        return this.selectKnownIssues(executionId).fetch().size();
    }

    @Override
    protected SelectHavingStep<Record6<Long, Long, String, String, String, String>> selectKnownIssues(long executionId) {
        return this.applyGrouping((SelectConditionStep<Record6<Long, Long, String, String, String, String>>)this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.ISSUE.BUGTRACKER_ID, (SelectField)Tables.ISSUE.REMOTE_ISSUE_ID, (SelectField)DSL.groupConcatDistinct((Field)Tables.EXECUTION.EXECUTION_ID), (SelectField)DSL.groupConcatDistinct((Field)DSL.ifnull((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ORDER, (Field)DSL.ifnull((Field)Tables.SESSION_NOTE.NOTE_ORDER, (Object)-1))), (SelectField)DSL.groupConcatDistinct((Field)Tables.ISSUE.ISSUE_ID)).from((TableLike)ExecutionKnownIssueFinder.getIssueToBugtrackerBindingJoin().leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID)).leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID).and(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID))).leftJoin((TableLike)Tables.SESSION_NOTE).on(Tables.SESSION_NOTE.ISSUE_LIST_ID.eq((Field)Tables.ISSUE.ISSUE_LIST_ID).and(Tables.SESSION_NOTE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)))).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).and(Tables.ISSUE.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID)));
    }

    @Override
    protected LocalKnownIssue buildIssueFromRecord(Record6<Long, Long, String, String, String, String> record) {
        return new ExecutionLocalKnownIssue((Long)record.component1(), (Long)record.component2(), (String)record.component3(), LocalKnownIssueFinderHelper.parseLongsAndSortDesc((String)record.component4()), LocalKnownIssueFinderHelper.parseLongsAndSortAsc((String)record.component5()), LocalKnownIssueFinderHelper.parseLongs((String)record.component6()));
    }

    protected SelectHavingStep<Record6<Long, Long, String, String, String, String>> applyGrouping(SelectConditionStep<Record6<Long, Long, String, String, String, String>> select) {
        return select.groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.ISSUE.BUGTRACKER_ID, Tables.ISSUE.REMOTE_ISSUE_ID});
    }
}

