/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.internal.batchimport.Batches;
import org.squashtest.tm.service.internal.batchimport.testcase.dto.TestCaseImportData;
import org.squashtest.tm.service.internal.batchimport.testcase.tree.FolderNode;
import org.squashtest.tm.service.internal.batchimport.testcase.tree.MissingNode;

public class FolderTree {
    private final FolderNode root;

    public FolderTree(String rootPath, Map<String, List<TestCaseImportData>> paths) {
        this.root = new FolderNode(rootPath, rootPath);
        this.createTree(paths);
    }

    public FolderNode getRoot() {
        return this.root;
    }

    private void createTree(Map<String, List<TestCaseImportData>> contentByPath) {
        for (Map.Entry<String, List<TestCaseImportData>> entry : contentByPath.entrySet()) {
            String[] parts = PathUtils.splitPath((String)entry.getKey());
            FolderNode current = this.root;
            StringBuilder currentPath = new StringBuilder(this.root.getPath());
            int i = 1;
            while (i < parts.length) {
                String part = PathUtils.unescapePathPartSlashes((String)parts[i]);
                this.appendToPath(currentPath, part);
                current = current.getChildOrCreate(part, currentPath.toString());
                if (i == parts.length - 1) {
                    current.addContents(entry.getValue());
                }
                ++i;
            }
        }
    }

    private void appendToPath(StringBuilder path, String part) {
        path.append("/").append(part);
    }

    public List<MissingNode> collectMissingNodes(NavigableMap<String, Long> existingPaths, Long testCaseLibraryId) {
        ArrayList<MissingNode> missingNodes = new ArrayList<MissingNode>();
        for (FolderNode node : this.root.getChildren().values()) {
            this.findMissingNodes(node, existingPaths, missingNodes, testCaseLibraryId, true);
        }
        return missingNodes;
    }

    private void findMissingNodes(FolderNode node, NavigableMap<String, Long> existingPaths, List<MissingNode> missingNodes, Long parentId, boolean isLibraryContent) {
        Long currentNodeId = (Long)existingPaths.get(node.getPath());
        if (currentNodeId == null) {
            missingNodes.add(new MissingNode(node, parentId, isLibraryContent));
            return;
        }
        for (FolderNode child : node.getChildren().values()) {
            this.findMissingNodes(child, existingPaths, missingNodes, currentNodeId, false);
        }
    }

    public Batches<TestCaseImportData> collectExistingNodes(NavigableMap<String, Long> existingPaths) {
        Batches<TestCaseImportData> batch = new Batches<TestCaseImportData>();
        for (FolderNode node : this.root.getChildren().values()) {
            this.findExistingNodes(node, existingPaths, batch);
        }
        return batch;
    }

    private void findExistingNodes(FolderNode node, NavigableMap<String, Long> existingPaths, Batches<TestCaseImportData> batch) {
        Long currentNodeId = (Long)existingPaths.get(node.getPath());
        if (currentNodeId == null) {
            return;
        }
        if (!node.getContents().isEmpty()) {
            batch.addBatch(currentNodeId, node.getContents());
        }
        for (FolderNode child : node.getChildren().values()) {
            this.findExistingNodes(child, existingPaths, batch);
        }
    }
}

