/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence.server.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import java.util.HashMap;
import java.util.List;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerCouldNotConvertToJsonStringException;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerInvalidHandlebarsTemplateException;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.MessageRound;
import org.squashtest.tm.service.internal.artificialintelligence.server.custom.Role;

public final class RequestPayloadGenerator {
    private RequestPayloadGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static String generate(String handlebarsTemplate, List<MessageRound> messages, String apiKey) {
        try {
            Handlebars handlebars = new Handlebars();
            handlebars.with(EscapingStrategy.NOOP);
            handlebars.registerHelper("isSystem", (Helper)new Helper<Role>(){

                public Boolean apply(Role role, Options options) {
                    return Role.SYSTEM.equals((Object)role);
                }
            });
            handlebars.registerHelper("isUser", (Helper)new Helper<Role>(){

                public Boolean apply(Role role, Options options) {
                    return Role.USER.equals((Object)role);
                }
            });
            handlebars.registerHelper("isModel", (Helper)new Helper<Role>(){

                public Boolean apply(Role role, Options options) {
                    return Role.MODEL.equals((Object)role);
                }
            });
            handlebars.registerHelper("convertToJsonString", (Helper)new Helper<String>(){

                public String apply(String text, Options options) {
                    return RequestPayloadGenerator.convertToJsonString(text);
                }
            });
            Template template = handlebars.compileInline(handlebarsTemplate);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("messages", messages);
            context.put("apiKey", apiKey);
            return template.apply(context);
        }
        catch (Exception e) {
            throw new AiServerInvalidHandlebarsTemplateException("Failed to process Handlebars template", (Throwable)e);
        }
    }

    private static String convertToJsonString(String input) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)input);
        }
        catch (JsonProcessingException e) {
            throw new AiServerCouldNotConvertToJsonStringException("Failed to write JSON as String", (Throwable)e);
        }
    }
}

