/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.importer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.commons.collections.map.MultiValueMap;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.internal.batchimport.LogTrain;

public class ImportLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportLog.class);
    private MultiValueMap logEntriesPerType = MultiValueMap.decorate(new HashMap(), TreeSet.class);
    private int testCaseSuccesses = 0;
    private int testCaseWarnings = 0;
    private int testCaseFailures = 0;
    private int testStepSuccesses = 0;
    private int testStepWarnings = 0;
    private int testStepFailures = 0;
    private int parameterSuccesses = 0;
    private int parameterWarnings = 0;
    private int parameterFailures = 0;
    private int datasetSuccesses = 0;
    private int datasetWarnings = 0;
    private int datasetFailures = 0;
    private int requirementVersionSuccesses = 0;
    private int requirementVersionWarnings = 0;
    private int requirementVersionFailures = 0;
    private int coverageSuccesses = 0;
    private int coverageWarnings = 0;
    private int coverageFailures = 0;
    private int reqlinksSuccesses = 0;
    private int reqlinksWarnings = 0;
    private int reqlinksFailures = 0;
    private int linkedLowLevelReqSuccesses = 0;
    private int linkedLowLevelReqWarnings = 0;
    private int linkedLowLevelReqFailures = 0;
    private String reportUrl;

    public void addLogEntry(LogEntry logEntry) {
        this.logEntriesPerType.put((Object)logEntry.getTarget().getType(), (Object)logEntry);
    }

    public void appendLogTrain(LogTrain train) {
        for (LogEntry entry : train.getEntries()) {
            this.logEntriesPerType.put((Object)entry.getTarget().getType(), (Object)entry);
        }
    }

    public Collection<LogEntry> findAllFor(EntityType type) {
        Collection entries = this.logEntriesPerType.getCollection((Object)type);
        if (entries != null) {
            return entries;
        }
        return Collections.emptyList();
    }

    public boolean isEmpty() {
        return this.logEntriesPerType.isEmpty();
    }

    public void packLogs() {
        LinkedList<LogEntry> listiterableLogs = new LinkedList<LogEntry>(this.findAllFor(EntityType.DATASET));
        Integer precLine = null;
        boolean okFoundOnPrecEntry = false;
        ListIterator iter = listiterableLogs.listIterator();
        while (iter.hasNext()) {
            LogEntry entry = (LogEntry)iter.next();
            Integer curLine = entry.getLine();
            ImportStatus curStatus = entry.getStatus();
            if (okFoundOnPrecEntry && curLine.equals(precLine)) {
                iter.previous();
                iter.previous();
                iter.remove();
                iter.next();
            }
            okFoundOnPrecEntry = curStatus == ImportStatus.OK;
            precLine = curLine;
        }
        this.findAllFor(EntityType.DATASET).clear();
        this.logEntriesPerType.putAll((Object)EntityType.DATASET, listiterableLogs);
    }

    public void recompute() {
        LOGGER.debug("ReqImport - Compute requirement import results", new Object[0]);
        this.recomputeFor(EntityType.TEST_CASE);
        this.recomputeFor(EntityType.TEST_STEP);
        this.recomputeFor(EntityType.PARAMETER);
        this.recomputeFor(EntityType.DATASET);
        this.recomputeFor(EntityType.REQUIREMENT_VERSION);
        this.recomputeFor(EntityType.COVERAGE);
        this.recomputeFor(EntityType.REQUIREMENT_LINK);
        this.recomputeFor(EntityType.LINKED_LOW_LEVEL_REQ);
    }

    private void recomputeFor(EntityType type) {
        Collection<LogEntry> entries = this.findAllFor(type);
        if (!entries.isEmpty()) {
            Iterator<LogEntry> iter = entries.iterator();
            LogEntry entry = iter.next();
            Integer precLine = entry.getLine();
            boolean errors = entry.getStatus() == ImportStatus.FAILURE;
            boolean warnings = entry.getStatus() == ImportStatus.WARNING;
            while (iter.hasNext()) {
                entry = iter.next();
                Integer curLine = entry.getLine();
                if (!curLine.equals(precLine)) {
                    this.countForEntity(type, errors, warnings);
                    errors = entry.getStatus() == ImportStatus.FAILURE;
                    warnings = entry.getStatus() == ImportStatus.WARNING;
                } else {
                    errors = entry.getStatus() == ImportStatus.FAILURE || errors;
                    warnings = entry.getStatus() == ImportStatus.WARNING || warnings;
                }
                precLine = curLine;
            }
            this.countForEntity(type, errors, warnings);
        }
    }

    private void countForEntity(EntityType type, boolean errors, boolean warnings) {
        switch (type) {
            case TEST_CASE: {
                this.countTestcase(errors, warnings);
                break;
            }
            case TEST_STEP: {
                this.countStep(errors, warnings);
                break;
            }
            case PARAMETER: {
                this.countParameter(errors, warnings);
                break;
            }
            case DATASET: {
                this.countDataset(errors, warnings);
                break;
            }
            case REQUIREMENT_VERSION: {
                this.countRequirementVersion(errors, warnings);
                break;
            }
            case COVERAGE: {
                this.countCoverage(errors, warnings);
                break;
            }
            case REQUIREMENT_LINK: {
                this.countLinks(errors, warnings);
                break;
            }
            case LINKED_LOW_LEVEL_REQ: {
                this.countLinkedLowLevelReqs(errors, warnings);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Entity type %s not yet implemented", new Object[]{type}));
            }
        }
    }

    private void countLinkedLowLevelReqs(boolean errors, boolean warnings) {
        if (errors) {
            ++this.linkedLowLevelReqFailures;
        } else if (warnings) {
            ++this.linkedLowLevelReqWarnings;
        } else {
            ++this.linkedLowLevelReqSuccesses;
        }
    }

    private void countLinks(boolean errors, boolean warnings) {
        if (errors) {
            ++this.reqlinksFailures;
        } else if (warnings) {
            ++this.reqlinksWarnings;
        } else {
            ++this.reqlinksSuccesses;
        }
    }

    private void countCoverage(boolean errors, boolean warnings) {
        if (errors) {
            ++this.coverageFailures;
        } else if (warnings) {
            ++this.coverageWarnings;
        } else {
            ++this.coverageSuccesses;
        }
    }

    private void countTestcase(boolean errors, boolean warnings) {
        if (errors) {
            ++this.testCaseFailures;
        } else if (warnings) {
            ++this.testCaseWarnings;
        } else {
            ++this.testCaseSuccesses;
        }
    }

    private void countStep(boolean errors, boolean warnings) {
        if (errors) {
            ++this.testStepFailures;
        } else if (warnings) {
            ++this.testStepWarnings;
        } else {
            ++this.testStepSuccesses;
        }
    }

    private void countParameter(boolean errors, boolean warnings) {
        if (errors) {
            ++this.parameterFailures;
        } else if (warnings) {
            ++this.parameterWarnings;
        } else {
            ++this.parameterSuccesses;
        }
    }

    private void countDataset(boolean errors, boolean warnings) {
        if (errors) {
            ++this.datasetFailures;
        } else if (warnings) {
            ++this.datasetWarnings;
        } else {
            ++this.datasetSuccesses;
        }
    }

    private void countRequirementVersion(boolean errors, boolean warnings) {
        LOGGER.debug("ReqImport Compute requirements", new Object[0]);
        if (errors) {
            ++this.requirementVersionFailures;
        } else if (warnings) {
            ++this.requirementVersionWarnings;
        } else {
            ++this.requirementVersionSuccesses;
        }
    }

    public int getTestCaseSuccesses() {
        return this.testCaseSuccesses;
    }

    public int getTestCaseWarnings() {
        return this.testCaseWarnings;
    }

    public int getTestCaseFailures() {
        return this.testCaseFailures;
    }

    public int getTestStepSuccesses() {
        return this.testStepSuccesses;
    }

    public int getTestStepWarnings() {
        return this.testStepWarnings;
    }

    public int getTestStepFailures() {
        return this.testStepFailures;
    }

    public int getParameterSuccesses() {
        return this.parameterSuccesses;
    }

    public int getParameterWarnings() {
        return this.parameterWarnings;
    }

    public int getParameterFailures() {
        return this.parameterFailures;
    }

    public int getDatasetSuccesses() {
        return this.datasetSuccesses;
    }

    public int getDatasetWarnings() {
        return this.datasetWarnings;
    }

    public int getDatasetFailures() {
        return this.datasetFailures;
    }

    public int getRequirementVersionSuccesses() {
        return this.requirementVersionSuccesses;
    }

    public int getRequirementVersionWarnings() {
        return this.requirementVersionWarnings;
    }

    public int getRequirementVersionFailures() {
        return this.requirementVersionFailures;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(String reportURL) {
        this.reportUrl = reportURL;
    }

    public String getStatus() {
        return "ok";
    }

    public int getCoverageSuccesses() {
        return this.coverageSuccesses;
    }

    public int getCoverageWarnings() {
        return this.coverageWarnings;
    }

    public int getCoverageFailures() {
        return this.coverageFailures;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public int getReqlinksSuccesses() {
        return this.reqlinksSuccesses;
    }

    public int getReqlinksWarnings() {
        return this.reqlinksWarnings;
    }

    public int getReqlinksFailures() {
        return this.reqlinksFailures;
    }

    public int getLinkedLowLevelReqSuccesses() {
        return this.linkedLowLevelReqSuccesses;
    }

    public int getLinkedLowLevelReqWarnings() {
        return this.linkedLowLevelReqWarnings;
    }

    public int getLinkedLowLevelReqFailures() {
        return this.linkedLowLevelReqFailures;
    }
}

