/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.deletion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;

public class CampaignLibraryNodesToDelete {
    private List<Long> folderIds = new ArrayList<Long>();
    private List<Long> campaignIds = new ArrayList<Long>();
    private List<Long> sprintGroupIds = new ArrayList<Long>();
    private List<Long> sprintIds = new ArrayList<Long>();
    private List<Long> iterationIds = new ArrayList<Long>();
    private List<Long> suiteIds = new ArrayList<Long>();

    public static CampaignLibraryNodesToDelete from(List<String> nodeRefs) {
        List<NodeReference> nodeReferences = nodeRefs.stream().map(NodeReference::fromNodeId).toList();
        CampaignLibraryNodesToDelete result = new CampaignLibraryNodesToDelete();
        List<Long> campaignIds = CampaignLibraryNodesToDelete.extractNodeReferenceIds(nodeReferences, NodeType.CAMPAIGN);
        List<Long> sprintIds = CampaignLibraryNodesToDelete.extractNodeReferenceIds(nodeReferences, NodeType.SPRINT);
        List<Long> sprintGroupIds = CampaignLibraryNodesToDelete.extractNodeReferenceIds(nodeReferences, NodeType.SPRINT_GROUP);
        List<Long> folderIds = CampaignLibraryNodesToDelete.extractNodeReferenceIds(nodeReferences, NodeType.CAMPAIGN_FOLDER);
        List<Long> iterationIds = CampaignLibraryNodesToDelete.extractNodeReferenceIds(nodeReferences, NodeType.ITERATION);
        List<Long> suiteIds = CampaignLibraryNodesToDelete.extractNodeReferenceIds(nodeReferences, NodeType.TEST_SUITE);
        result.setFolderIds(folderIds);
        result.setCampaignIds(campaignIds);
        result.setSprintIds(sprintIds);
        result.setSprintGroupIds(sprintGroupIds);
        result.setIterationIds(iterationIds);
        result.setSuiteIds(suiteIds);
        return result;
    }

    private static List<Long> extractNodeReferenceIds(List<NodeReference> nodeReferences, NodeType type) {
        return nodeReferences.stream().filter(nodeReference -> nodeReference.getNodeType().equals((Object)type)).map(NodeReference::getId).toList();
    }

    public List<Long> getFolderIds() {
        return this.folderIds;
    }

    public void setFolderIds(List<Long> folderIds) {
        this.folderIds = folderIds;
    }

    public List<Long> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public List<Long> getSprintGroupIds() {
        return this.sprintGroupIds;
    }

    public void setSprintGroupIds(List<Long> sprintGroupIds) {
        this.sprintGroupIds = sprintGroupIds;
    }

    public List<Long> getSprintIds() {
        return this.sprintIds;
    }

    public void setSprintIds(List<Long> sprintIds) {
        this.sprintIds = sprintIds;
    }

    public List<Long> getIterationIds() {
        return this.iterationIds;
    }

    public void setIterationIds(List<Long> iterationIds) {
        this.iterationIds = iterationIds;
    }

    public List<Long> getSuiteIds() {
        return this.suiteIds;
    }

    public void setSuiteIds(List<Long> suiteIds) {
        this.suiteIds = suiteIds;
    }

    public List<Long> getCampaignLibraryNodeIds() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.sprintGroupIds, this.sprintIds, this.campaignIds, this.folderIds));
    }
}

