/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.campaign;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;

public final class StatisticUtils {
    public List<Object[]> gatherCumulativeTestsPerDate(List<Date> dates) {
        LinkedList<Object[]> cumulativeTestsPerDate = new LinkedList<Object[]>();
        if (!dates.isEmpty()) {
            LinkedList<Date> trickedDates = new LinkedList<Date>(dates);
            trickedDates.add(null);
            Iterator dateIter = trickedDates.iterator();
            Date precDate = (Date)dateIter.next();
            int accumulator = 1;
            while (dateIter.hasNext()) {
                Date curDate = (Date)dateIter.next();
                if (!this.isSameDay(precDate, curDate)) {
                    Date truncated = DateUtils.truncate((Date)precDate, (int)5);
                    cumulativeTestsPerDate.add(new Object[]{truncated, accumulator});
                }
                ++accumulator;
                precDate = curDate;
            }
        }
        return cumulativeTestsPerDate;
    }

    private boolean isSameDay(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return DateUtils.isSameDay((Date)d1, (Date)d2);
    }
}

