/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.spi;

import java.util.Arrays;
import org.squashtest.csp.core.bugtracker.core.AuthenticationFieldsTranslationKeys;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerCacheInfo;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;

public interface BugtrackerConnectorBase {
    default public AuthenticationProtocol[] getSupportedAuthProtocols() {
        return new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH};
    }

    default public boolean supports(AuthenticationProtocol mode) {
        return Arrays.asList(this.getSupportedAuthProtocols()).contains(mode);
    }

    public void authenticate(Credentials var1) throws UnsupportedAuthenticationModeException;

    public void checkCredentials(Credentials var1) throws BugTrackerNoCredentialsException, BugTrackerRemoteException;

    default public boolean areCredentialsValid(Credentials credentials) {
        try {
            this.checkCredentials(credentials);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor();

    default public String getKeyForLogin(BugTracker bugTracker) {
        return AuthenticationFieldsTranslationKeys.LOGIN.key;
    }

    default public String getKeyForPassword(BugTracker bugTracker) {
        if (AuthenticationProtocol.BASIC_AUTH.equals((Object)bugTracker.getAuthenticationProtocol())) {
            return AuthenticationFieldsTranslationKeys.PASSWORD.key;
        }
        return AuthenticationFieldsTranslationKeys.TOKEN.key;
    }

    default public boolean allowsReportingCache() {
        return false;
    }

    default public void refreshCache(BugTracker bugTracker) {
        if (this.allowsReportingCache()) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    default public void refreshCache(BugTracker bugTracker, long projectId) {
        if (this.allowsReportingCache()) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    default public BugTrackerCacheInfo getCacheInfo() {
        if (this.allowsReportingCache()) {
            throw new UnsupportedOperationException("Not implemented");
        }
        return null;
    }
}

