/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.pivot.projectimporter.xrayimporter.topivot;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.AbstractGenericItem;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.ItemXrayDto;

public abstract class AbstractImporterXrayHelper {
    protected Document normalizeToHTMLDocument(String fieldValueToNormalize) {
        Document document;
        Element body;
        String fieldValue = "";
        if (Objects.nonNull(fieldValueToNormalize)) {
            fieldValue = fieldValueToNormalize;
        }
        if ((body = (document = Jsoup.parse((String)fieldValue, (Parser)Parser.htmlParser())).body()).children().isEmpty() && StringUtils.isNotEmpty((CharSequence)fieldValue)) {
            body.appendElement("p").text(fieldValue);
        }
        return document;
    }

    protected String generateDescription(ItemXrayDto itemXrayDto, BiConsumer<Element, ItemXrayDto> bodyConsumer) {
        Document document = this.normalizeToHTMLDocument(itemXrayDto.getDescription());
        bodyConsumer.accept(document.body(), itemXrayDto);
        return document.body().children().stream().map(Node::toString).collect(Collectors.joining());
    }

    protected void addLinkPriorityStatusLabelToDescription(Element body, ItemXrayDto itemXrayDto) {
        this.appendTextIfNotNull(itemXrayDto.getLink(), link -> {
            Element element2 = body.appendElement("p").appendChild((Node)new Element("a").attr("href", link).text(link));
        });
        this.appendTextIfNotNull(itemXrayDto.getPriority(), priority -> {
            Element element2 = body.appendElement("p").text(String.format("XRay priority: %s", itemXrayDto.getPriority()));
        });
        this.appendTextIfNotNull(itemXrayDto.getStatus(), status -> {
            Element element2 = body.appendElement("p").text(String.format("XRay status: %s", itemXrayDto.getStatus()));
        });
        this.appendTextIfNotNull(itemXrayDto.getLabel(), label -> {
            Element element2 = body.appendElement("p").text(String.format("XRay Labels: %s", label));
        });
    }

    protected void appendTextIfNotNull(String text, Consumer<String> consumer) {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            consumer.accept(text);
        }
    }

    protected static Map<String, String> convertStringToMap(String mapToString) {
        mapToString = mapToString.replaceAll("(^\\{)|(}$)", "");
        return Arrays.stream(mapToString.split(",")).map(str -> StringUtils.trim((String)str).split("=")).collect(Collectors.toMap(str -> str[0], str -> str[1]));
    }

    protected <T extends AbstractGenericItem> void writeLog(PrintWriter logWriter, T item) {
        switch (item.getItemStatus()) {
            case SUCCESS: {
                logWriter.write(item.getMessageOnSuccess() + System.lineSeparator());
                break;
            }
            case WARNING: {
                item.getMessagesOnWarn().forEach(message -> logWriter.write(message + System.lineSeparator()));
                break;
            }
            case FAILURE: {
                logWriter.write(item.getMessageOnError() + System.lineSeparator());
            }
        }
    }
}

