/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testplanitem;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestPlan;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.testplanitem.TestPlanItemAssignableUserFinderImpl$AjcClosure1;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.testplanitem.TestPlanItemAssignableUserFinder;

@Service
@Transactional(readOnly=true)
public class TestPlanItemAssignableUserFinderImpl
implements TestPlanItemAssignableUserFinder {
    private static final Set<Class<?>> VALID_ENTITY_CLASSES;
    private final UserDao userDao;
    private final ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy;
    private final ObjectAclService objectAclService;
    private final DSLContext dslContext;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        TestPlanItemAssignableUserFinderImpl.ajc$preClinit();
        VALID_ENTITY_CLASSES = Set.of(CampaignLibrary.class, Iteration.class, SprintReqVersion.class);
    }

    public TestPlanItemAssignableUserFinderImpl(UserDao userDao, @Qualifier(value="squashtest.core.security.ObjectIdentityRetrievalStrategy") ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy, ObjectAclService objectAclService, DSLContext dslContext) {
        this.userDao = userDao;
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
        this.objectAclService = objectAclService;
        this.dslContext = dslContext;
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.testplan.TestPlanItem' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<User> findAssignableUsersByTestPlanItemId(Long testPlanItemId) {
        Long campaignLibraryId = this.findCampaignLibraryIdByTestPlanItemId(testPlanItemId);
        return this.findAssignableUsersByCampaignLibraryId(campaignLibraryId);
    }

    @Override
    public List<User> findAssignableUsersByExploratorySessionOverviewId(Long overviewId) {
        Long campaignLibraryId = this.findCampaignLibraryIdByExploratorySessionOverviewId(overviewId);
        return this.findAssignableUsersByCampaignLibraryId(campaignLibraryId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#libraryId, 'org.squashtest.tm.domain.campaign.CampaignLibrary' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<User> findAssignableUsersByCampaignLibraryId(Long libraryId) {
        return this.findAssignableUsersByEntityId(CampaignLibrary.class, libraryId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#iterationId, 'org.squashtest.tm.domain.campaign.Iteration' , 'READ') or hasRole('ROLE_ADMIN')")
    public List<User> findAssignableUsersByIterationId(long iterationId) {
        return this.findAssignableUsersByEntityId(Iteration.class, iterationId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion' ,'READ')  or hasRole('ROLE_ADMIN')")
    public List<User> findAssignableUsersBySprintReqVersionId(long sprintReqVersionId) {
        return this.findAssignableUsersByEntityId(SprintReqVersion.class, sprintReqVersionId);
    }

    private <T> List<User> findAssignableUsersByEntityId(Class<T> entityClass, long entityId) {
        List<String> loginList;
        this.validateEntityClass(entityClass);
        Object entity = this.entityManager.find(entityClass, (Object)entityId);
        if (Objects.isNull(entity)) {
            throw new IllegalArgumentException("Entity of type " + String.valueOf(entityClass) + " with id " + entityId + " does not exist.");
        }
        ObjectIdentity oid = this.objectIdentityRetrievalStrategy.getObjectIdentity(entity);
        List<String> list = loginList = this.objectAclService.findUsersWithExecutePermission(List.of(oid));
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        TestPlanItemAssignableUserFinderImpl$AjcClosure1 testPlanItemAssignableUserFinderImpl$AjcClosure1 = new TestPlanItemAssignableUserFinderImpl$AjcClosure1(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(testPlanItemAssignableUserFinderImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
    }

    private <T> void validateEntityClass(Class<T> entityClass) {
        if (!VALID_ENTITY_CLASSES.contains(entityClass)) {
            throw new IllegalArgumentException("Unsupported entity class: " + String.valueOf(entityClass) + ". Supported classes are CampaignLibrary, Iteration and SprintReqVersion.");
        }
    }

    private Long findCampaignLibraryIdByTestPlanItemId(Long testPlanItemId) {
        return (Long)this.dslContext.select((SelectField)TestPlan.TEST_PLAN.CL_ID).from((TableLike)TestPlan.TEST_PLAN).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(TestPlan.TEST_PLAN.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Object)testPlanItemId)).fetchOneInto(Long.class);
    }

    private Long findCampaignLibraryIdByExploratorySessionOverviewId(Long overviewId) {
        return (Long)this.dslContext.select((SelectField)TestPlan.TEST_PLAN.CL_ID).from((TableLike)TestPlan.TEST_PLAN).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(TestPlan.TEST_PLAN.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)overviewId)).fetchOneInto(Long.class);
    }

    static final /* synthetic */ List findUsersByLoginIn_aroundBody0(TestPlanItemAssignableUserFinderImpl testPlanItemAssignableUserFinderImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginIn(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestPlanItemAssignableUserFinderImpl.java", TestPlanItemAssignableUserFinderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginIn", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 114);
    }
}

