/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase.bdd.robot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.service.internal.testcase.bdd.TextGridFormatter;
import org.squashtest.tm.service.internal.testcase.bdd.robot.RobotSyntaxHelpers;
import org.squashtest.tm.service.internal.testcase.bdd.robot.SectionBuilderHelpers;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

public final class SettingSectionBuilder {
    private SettingSectionBuilder() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated.");
    }

    public static String buildSettingsSection(KeywordTestCase testCase, MessageSource messageSource) {
        boolean isDatasetEnabled = SectionBuilderHelpers.isTestCaseUsingDatasets(testCase);
        Locale locale = SettingSectionBuilder.getScriptLocale(testCase);
        SectionBuilderHelpers.MultiLineStringBuilder settingsBuilder = new SectionBuilderHelpers.MultiLineStringBuilder().appendLine("*** Settings ***").append(SettingSectionBuilder.formatDocumentation(testCase));
        TextGridFormatter gridFormatter = new TextGridFormatter();
        SettingSectionBuilder.appendMetadata(messageSource, testCase, locale, gridFormatter);
        SettingSectionBuilder.appendSquashResources(gridFormatter);
        SettingSectionBuilder.appendTFParamServiceLibrary(isDatasetEnabled, gridFormatter);
        SettingSectionBuilder.appendTestSetupAndTestTeardown(gridFormatter);
        settingsBuilder.append(gridFormatter.format());
        settingsBuilder.appendNewLine().appendNewLine();
        return settingsBuilder.toString();
    }

    private static void appendMetadata(MessageSource messageSource, KeywordTestCase testCase, Locale locale, TextGridFormatter gridFormatter) {
        String idLabel = messageSource.getMessage("label.id", null, locale);
        gridFormatter.addRow("Metadata", idLabel, testCase.getId().toString());
        if (StringUtils.isNotBlank((CharSequence)testCase.getReference())) {
            String referenceLabel = messageSource.getMessage("test-case.reference.label", null, locale);
            gridFormatter.addRow("Metadata", referenceLabel, testCase.getReference());
        }
        if (SettingSectionBuilder.hasAutomationWorkflowEnabled(testCase)) {
            String priorityLabel = messageSource.getMessage("testcase.bdd.script.label.automation-priority", null, locale);
            Integer priority = SettingSectionBuilder.extractPriority(testCase);
            gridFormatter.addRow("Metadata", priorityLabel, priority == null ? "null" : priority.toString());
        }
        String importanceLabel = messageSource.getMessage("testcase.bdd.script.label.test-case-importance", null, locale);
        String importanceValue = messageSource.getMessage(testCase.getImportance().getI18nKey(), null, locale);
        gridFormatter.addRow("Metadata", importanceLabel, importanceValue);
    }

    private static boolean hasAutomationWorkflowEnabled(KeywordTestCase testCase) {
        return !AutomationWorkflowType.NONE.equals((Object)testCase.getProject().getAutomationWorkflowType());
    }

    private static Integer extractPriority(KeywordTestCase testCase) {
        if (testCase.getAutomationRequest() == null) {
            return null;
        }
        return testCase.getAutomationRequest().getAutomationPriority();
    }

    private static String formatDocumentation(KeywordTestCase testCase) {
        ArrayList<String> documentationContent = new ArrayList<String>(Collections.singletonList(testCase.getName()));
        TextGridFormatter textGridFormatter = new TextGridFormatter();
        if (SettingSectionBuilder.hasTestCaseDescription(testCase)) {
            documentationContent.add(RobotSyntaxHelpers.NEW_LINE);
            String content = SettingSectionBuilder.formatTestCaseDescription(testCase);
            documentationContent.addAll(List.of(content.split("\\R")));
        }
        textGridFormatter.addRows(SettingSectionBuilder.buildDocumentationLines(documentationContent));
        return textGridFormatter.format();
    }

    private static List<List<String>> buildDocumentationLines(List<String> content) {
        return RobotSyntaxHelpers.buildMultilineEntry("Documentation", content);
    }

    private static boolean hasTestCaseDescription(KeywordTestCase testCase) {
        return StringUtils.isNotBlank((CharSequence)SettingSectionBuilder.formatTestCaseDescription(testCase));
    }

    private static String formatTestCaseDescription(KeywordTestCase testCase) {
        String fullDescription = testCase.getDescription();
        String asText = HTMLCleanupUtils.htmlToTrimmedText(fullDescription);
        return asText.replace("\t", "    ");
    }

    private static void appendSquashResources(TextGridFormatter gridFormatter) {
        gridFormatter.addRow("Resource", "squash_resources.resource");
    }

    private static void appendTFParamServiceLibrary(boolean includeSquashTfLibrary, TextGridFormatter gridFormatter) {
        if (includeSquashTfLibrary) {
            gridFormatter.addRow("Library", "squash_tf.TFParamService");
        }
    }

    private static void appendTestSetupAndTestTeardown(TextGridFormatter gridFormatter) {
        gridFormatter.addRow("Test Setup", "Test Setup");
        gridFormatter.addRow("Test Teardown", "Test Teardown");
    }

    private static Locale getScriptLocale(KeywordTestCase testCase) {
        return testCase.getProject().getBddScriptLanguage().getLocale();
    }
}

