/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultimport;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.UploadedData;
import org.squashtest.tm.service.internal.dto.resultimport.AttachmentDto;
import org.squashtest.tm.service.internal.dto.resultimport.PartialErrorDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestDto;
import org.squashtest.tm.service.internal.dto.resultimport.TestStepDto;
import org.squashtest.tm.service.internal.testautomation.resultimport.AttachmentImportHelper;
import org.squashtest.tm.service.testautomation.resultimport.TestStepImportService;

@Service
public class TestStepImportServiceImpl
implements TestStepImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestStepImportServiceImpl.class);
    private final AttachmentManagerService attachmentManagerService;
    private final AttachmentImportHelper attachmentImportHelper;

    @Inject
    public TestStepImportServiceImpl(AttachmentManagerService attachmentManagerService, AttachmentImportHelper attachmentImportHelper) {
        this.attachmentManagerService = attachmentManagerService;
        this.attachmentImportHelper = attachmentImportHelper;
    }

    @Override
    public boolean isNumberOfStepsValid(Execution execution, TestDto testDto, String fullTestIdentifier, PartialErrorDto partialErrors) {
        if (testDto == null || testDto.getTestSteps() == null) {
            return false;
        }
        if (execution.getSteps().size() != testDto.getTestSteps().size()) {
            partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "The number of test steps in the request does not match the number of steps in the test case for test %s. Expected %d but got %d.".formatted(fullTestIdentifier, execution.getSteps().size(), testDto.getTestSteps().size()));
            return false;
        }
        return true;
    }

    @Override
    public void addTestStepsToExecution(String fullTestIdentifier, Execution execution, List<TestStepDto> testSteps, PartialErrorDto partialErrors) {
        int i = 0;
        while (i < testSteps.size()) {
            TestStepDto stepToImport = testSteps.get(i);
            ExecutionStep executionStep = (ExecutionStep)execution.getSteps().get(i);
            try {
                executionStep.setExecutionStatus(ExecutionStatus.fromString((String)stepToImport.getStatus()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                partialErrors.addNewTestError(execution.getReferencedTestCase().getId(), execution.getReferencedTestCase().getAutomatedTestReference(), "The status '%s' is not valid for test step '%s' in test %s. Allowed values are: %s.".formatted(stepToImport.getStatus(), i + 1, fullTestIdentifier, ExecutionStep.getLegalStatusSetForAutomatedTest().stream().map(Enum::name).toList()));
            }
            ++i;
        }
    }

    @Override
    public void addAttachmentsToExecutionSteps(TestDto testDto, PartialErrorDto partialErrors, boolean stepsAddedSuccessfully, String fullTestIdentifier, TestCase referencedTestCase, Execution execution) {
        if (!stepsAddedSuccessfully) {
            return;
        }
        int i = 0;
        while (i < testDto.getTestSteps().size()) {
            TestStepDto stepToImport = testDto.getTestSteps().get(i);
            this.addAttachmentsToExecutionStep(fullTestIdentifier, referencedTestCase, (ExecutionStep)execution.getSteps().get(i), stepToImport, partialErrors, i);
            ++i;
        }
    }

    private void addAttachmentsToExecutionStep(String fullTestIdentifier, TestCase referencedTestCase, ExecutionStep executionStep, TestStepDto stepToImport, PartialErrorDto partialErrors, int stepIndex) {
        List<AttachmentDto> attachments = stepToImport.getAttachments();
        if (attachments == null) {
            return;
        }
        this.attachmentImportHelper.deduplicateAttachmentNames(attachments);
        for (AttachmentDto attachmentDto : attachments) {
            this.addAttachmentToExecutionStep(fullTestIdentifier, referencedTestCase, executionStep, attachmentDto, partialErrors, stepIndex);
        }
    }

    private void addAttachmentToExecutionStep(String fullTestIdentifier, TestCase referencedTestCase, ExecutionStep executionStep, AttachmentDto attachmentDto, PartialErrorDto partialErrors, int stepIndex) {
        UploadedData uploadedData;
        if (!this.attachmentImportHelper.isValidExecutionAttachment(referencedTestCase.getId(), referencedTestCase.getAutomatedTestReference(), fullTestIdentifier, partialErrors, attachmentDto)) {
            return;
        }
        try {
            uploadedData = this.attachmentImportHelper.decodeBase64AttachmentContent(attachmentDto);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Content of attachment '{}' for execution step {} is not a valid Base64 string.", new Object[]{attachmentDto.getName(), stepIndex});
            return;
        }
        try {
            this.attachmentManagerService.importAttachmentWithoutPermissionCheck(executionStep, uploadedData);
        }
        catch (IOException e) {
            LOGGER.error("Failed to add attachment {} to execution step {}", new Object[]{attachmentDto.getName(), stepIndex, e});
        }
    }
}

