/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.api.security.authentication.FeaturesAwareAuthentication;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.security.UserContextService;

@Component(value="squashtest.core.user.UserContextService")
public class SpringSecurityUserContextService
implements UserContextService {
    @Override
    public String getUsername() {
        return UserContextHolder.getUsername();
    }

    @Override
    public boolean hasRole(String role) {
        Collection<? extends GrantedAuthority> grantedAuths = this.getGrantedAuthorities();
        for (GrantedAuthority grantedAuthority : grantedAuths) {
            if (!grantedAuthority.getAuthority().equals(role)) continue;
            return true;
        }
        return false;
    }

    private Collection<? extends GrantedAuthority> getGrantedAuthorities() {
        Authentication principal = this.getAuthentication();
        Collection<Object> grantedAuths = principal == null ? Collections.emptyList() : principal.getAuthorities();
        return grantedAuths;
    }

    @Override
    public Authentication getAuthentication() {
        return UserContextHolder.getAuthentication();
    }

    @Override
    public Optional<AuthenticationProviderFeatures> getUserContextAuthProviderFeatures() {
        Authentication auth = UserContextHolder.getAuthentication();
        if (auth == null || !FeaturesAwareAuthentication.class.isAssignableFrom(auth.getClass())) {
            return Optional.empty();
        }
        AuthenticationProviderFeatures features = ((FeaturesAwareAuthentication)auth).getFeatures();
        return Optional.ofNullable(features);
    }
}

