/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.requirement.RequirementHelper;

@Service(value="RequirementHelper")
@Transactional
public class RequirementHelperImpl
implements RequirementHelper {
    private final RequirementDao requirementDao;

    public RequirementHelperImpl(RequirementDao requirementDao) {
        this.requirementDao = requirementDao;
    }

    @Override
    public boolean checkIfReqIsHighLevelByReqVersionId(Long reqVersionId) {
        return this.requirementDao.isHighLevelRequirementVersion(reqVersionId);
    }

    @Override
    public Long findRequirementVersionIdFromRequirementId(Long requirementId) {
        return this.requirementDao.findRequirementCurrentVersionIdFromRequirementId(requirementId);
    }

    @Override
    public boolean checkIfRequirementIsNotChild(Long requirementId) {
        return !this.requirementDao.checkIfRequirementIsChild(requirementId);
    }
}

