/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate.loaders.common;

import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.AbstractHqlLoader;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.HintOptions;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.common.JoinOption;

public class FetchPlan<KEY, TYPE>
extends AbstractHqlLoader<KEY, TYPE> {
    private final Set<JoinOption<KEY, TYPE>> joinOptions;
    protected final Set<KEY> ids;

    public FetchPlan(HintOptions hintOptions, Set<JoinOption<KEY, TYPE>> joinOptions, TypedQuery<TYPE> mainQuery, Set<KEY> ids) {
        super(hintOptions, mainQuery);
        this.joinOptions = joinOptions;
        this.ids = Objects.requireNonNull(ids);
    }

    public List<TYPE> fetch() {
        if (this.ids.isEmpty()) {
            return new ArrayList();
        }
        List<TYPE> mainAggregates = this.fetchMainEntity();
        this.joinOptions.forEach(joinOption -> joinOption.fetch(new HashSet<KEY>(this.ids)));
        return mainAggregates;
    }

    private List<TYPE> fetchMainEntity() {
        TypedQuery mainQuery = this.build();
        mainQuery.setParameter("ids", this.ids);
        return mainQuery.getResultList();
    }
}

