/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.CustomDatasetDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

public class DatasetDaoImpl
implements CustomDatasetDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dslContext;

    @Override
    public List<Dataset> findOwnDatasetsByTestCases(Collection<Long> testCaseIds) {
        if (!testCaseIds.isEmpty()) {
            Query query = this.em.createNamedQuery("Dataset.findOwnDatasetsByTestCases");
            query.setParameter("testCaseIds", testCaseIds);
            return query.getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Dataset> findAllDelegateDatasets(Long testCaseId) {
        LinkedList<Dataset> allDatasets = new LinkedList<Dataset>();
        HashSet exploredTc = new HashSet();
        List srcTc = new LinkedList<Long>();
        TypedQuery next = this.em.createNamedQuery("dataset.findTestCasesThatInheritParameters", Long.class);
        srcTc.add(testCaseId);
        while (!srcTc.isEmpty()) {
            next.setParameter("srcIds", srcTc);
            List destTc = next.getResultList();
            if (!destTc.isEmpty()) {
                allDatasets.addAll(this.findOwnDatasetsByTestCases(destTc));
            }
            exploredTc.addAll(srcTc);
            srcTc = destTc;
            srcTc.removeAll(exploredTc);
        }
        return allDatasets;
    }

    @Override
    public Map<Long, List<Dataset>> findAllDatasetsByTestCaseIds(Collection<Long> sourceTestCaseIds) {
        Map<Long, List<Long>> callerTestCaseIdsByCalled = this.findTestCaseIdsInheritParameters(sourceTestCaseIds);
        Set<Long> allTestCaseIds = Stream.concat(sourceTestCaseIds.stream(), callerTestCaseIdsByCalled.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
        Map<Long, List<Dataset>> datasetsByTestCaseId = this.findOwnDatasetsByTestCaseIds(allTestCaseIds);
        return sourceTestCaseIds.stream().map(testCaseId -> {
            ArrayList datasets = new ArrayList(datasetsByTestCaseId.getOrDefault(testCaseId, List.of()));
            callerTestCaseIdsByCalled.getOrDefault(testCaseId, Collections.emptyList()).stream().map(callerId -> datasetsByTestCaseId.getOrDefault(callerId, List.of())).forEach(datasets::addAll);
            return datasets.isEmpty() ? null : Map.entry(testCaseId, datasets);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<Long, List<Long>> findTestCaseIdsInheritParameters(Collection<Long> testCaseIds) {
        CommonTableExpression cte = DSL.name((String)"cte").fields("source_id", "caller_id").as((ResultQuery)DSL.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.CALL_TEST_STEP).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.in(testCaseIds).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.eq((Object)Boolean.TRUE))).union((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"cte", "source_id"}), Long.class), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from(DSL.name((String)"cte")).innerJoin((TableLike)Tables.CALL_TEST_STEP).on(DSL.field((Name)DSL.name((String[])new String[]{"cte", "caller_id"})).eq((Object)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).innerJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID))));
        return this.dslContext.withRecursive(new CommonTableExpression[]{cte}).selectFrom((TableLike)cte).fetchGroups(DSL.field((String)"source_id", Long.class), DSL.field((String)"caller_id", Long.class));
    }

    @Override
    public Map<Long, List<Dataset>> findOwnDatasetsByTestCaseIds(Collection<Long> testCaseIds) {
        List<Dataset> datasets = new EntityGraphQueryBuilder<Dataset>(this.em, Dataset.class, "select d from Dataset d where d.testCase.id in :ids").addAttributeNodes("parameterValues").addSubGraph("parameterValues", "parameter").executeDistinctList(Map.of("ids", testCaseIds));
        HashMap<Long, List<Dataset>> result = new HashMap<Long, List<Dataset>>();
        for (Dataset dataset : datasets) {
            result.computeIfAbsent(dataset.getTestCase().getId(), k -> new ArrayList()).add(dataset);
        }
        return result;
    }

    @Override
    public void removeDatasetFromTestPlanItems(Long datasetId) {
        Query query = this.em.createNamedQuery("dataset.removeDatasetFromItsIterationTestPlanItems");
        query.setParameter("datasetId", (Object)datasetId);
        query.executeUpdate();
        Query query2 = this.em.createNamedQuery("dataset.removeDatasetFromItsCampaignTestPlanItems");
        query2.setParameter("datasetId", (Object)datasetId);
        query2.executeUpdate();
        Query query3 = this.em.createNamedQuery("dataset.removeDatasetFromItsSprintReqVersionTestPlanItems");
        query3.setParameter("datasetId", (Object)datasetId);
        query3.executeUpdate();
    }

    @Override
    public void removeDatasetsFromTestPlanItems(List<Long> testCaseIds) {
        Query query = this.em.createNamedQuery("dataset.removeDatasetsFromItsIterationTestPlanItems");
        query.setParameter("testCaseIds", testCaseIds);
        query.executeUpdate();
        Query query2 = this.em.createNamedQuery("dataset.removeDatasetsFromItsCampaignTestPlanItems");
        query2.setParameter("testCaseIds", testCaseIds);
        query2.executeUpdate();
        Query query3 = this.em.createNamedQuery("dataset.removeDatasetsFromItsSprintReqVersionTestPlanItems");
        query3.setParameter("testCaseIds", testCaseIds);
        query3.executeUpdate();
    }

    @Override
    public Dataset findByTestCaseIdAndNameWithDatasetParamValues(Long testCaseId, String name) {
        Query query = this.em.createNamedQuery("Dataset.findByTestCaseIdAndNameWithDatasetParamValues");
        query.setParameter("testCaseId", (Object)testCaseId);
        query.setParameter("name", (Object)name);
        return (Dataset)query.getSingleResult();
    }

    @Override
    public void removeDatasetInBatchByTestCaseIds(List<Long> testCaseIds) {
        Query deleteDatasetSetParamValuesQuery = this.em.createNamedQuery("Dataset.batchDeleteDatasetParamValueByTestCaseIds");
        deleteDatasetSetParamValuesQuery.setParameter("testCaseIds", testCaseIds);
        deleteDatasetSetParamValuesQuery.executeUpdate();
        Query deleteDatasetsQuery = this.em.createNamedQuery("Dataset.batchDeleteDatasetByTestCaseIds");
        deleteDatasetsQuery.setParameter("testCaseIds", testCaseIds);
        deleteDatasetsQuery.executeUpdate();
    }

    @Override
    public Map<Long, List<String>> findOwnDatasetNamesByTestCaseIds(Collection<Long> testCaseIds) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Object[]> resultStream = this.getDatasetsNamesByTCIdsStream(testCaseIds);){
            return resultStream.collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (String)result[1], Collectors.toList())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<Object[]> getDatasetsNamesByTCIdsStream(Collection<Long> testCaseIds) {
        return this.em.createQuery("select tc.id, d.name from Dataset d join d.testCase tc where tc.id in :ids", Object[].class).setParameter("ids", testCaseIds).getResultStream();
    }
}

