/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.environmentvariable.EVInputType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.DenormalizedEnvironmentVariableDto;
import org.squashtest.tm.service.internal.repository.CustomDenormalizedEnvironmentVariableDao;

@Repository
public class CustomDenormalizedEnvironmentVariableDaoImpl
implements CustomDenormalizedEnvironmentVariableDao {
    private static final String INTERPRETED_TEXT = EVInputType.INTERPRETED_TEXT.name();
    @Inject
    DSLContext dslContext;

    @Override
    public List<DenormalizedEnvironmentVariableDto> getAllByExecutionId(Long executionId, String interpretedLabel) {
        Field valueField = DSL.when((Condition)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.TYPE.eq((Object)INTERPRETED_TEXT), (Field)DSL.concat((Field)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.VALUE, (String)interpretedLabel)).otherwise((Field)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.VALUE);
        return this.dslContext.select((SelectField)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.DEV_ID.as("ID"), (SelectField)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.EV_ID, (SelectField)DSL.concat((Field[])new Field[]{Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.NAME, DSL.value((String)": "), valueField}).as("NAMED_VALUE")).from((TableLike)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE).leftJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID)).leftJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.ENVIRONMENT_VARIABLE).on(Tables.ENVIRONMENT_VARIABLE.EV_ID.eq((Field)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.EV_ID)).where(Tables.EXECUTION.EXECUTION_ID.eq((Object)executionId)).fetchInto(DenormalizedEnvironmentVariableDto.class);
    }
}

