/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.testautomation.TestAutomationProjectAnalysisStatusDto;
import org.squashtest.tm.service.internal.repository.display.TestCandidateAnalysisDisplayDao;

@Repository
public class TestCandidateAnalysisDisplayDaoImpl
implements TestCandidateAnalysisDisplayDao {
    @Inject
    private DSLContext dslContext;

    @Override
    public List<TestAutomationProjectAnalysisStatusDto> findAnalysisStatusByProjectIds(List<Long> projectIds) {
        if (projectIds == null || projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        Table latestPerProject = this.dslContext.select((SelectField)Tables.TEST_CANDIDATE_ANALYSIS_PROJECT.PROJECT_ID.as("PROJECT_ID"), (SelectField)DSL.max((Field)Tables.TEST_CANDIDATE_ANALYSIS_PROJECT.TEST_CANDIDATE_ANALYSIS_ID).as("TEST_CANDIDATE_ANALYSIS_ID")).from((TableLike)Tables.TEST_CANDIDATE_ANALYSIS_PROJECT).where(Tables.TEST_CANDIDATE_ANALYSIS_PROJECT.PROJECT_ID.in(projectIds)).groupBy(new GroupField[]{Tables.TEST_CANDIDATE_ANALYSIS_PROJECT.PROJECT_ID}).asTable();
        return this.dslContext.select((SelectField)latestPerProject.field("PROJECT_ID", Long.class), (SelectField)Tables.TEST_CANDIDATE_ANALYSIS.STATUS, (SelectField)Tables.TEST_CANDIDATE_ANALYSIS.TERMINATED_ON).from((TableLike)latestPerProject).join((TableLike)Tables.TEST_CANDIDATE_ANALYSIS).on(Tables.TEST_CANDIDATE_ANALYSIS.TEST_CANDIDATE_ANALYSIS_ID.eq(latestPerProject.field("TEST_CANDIDATE_ANALYSIS_ID", Long.class))).fetchInto(TestAutomationProjectAnalysisStatusDto.class);
    }
}

