/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.ProjectAiConfigurationDao;

@Repository
public class ProjectAiConfigurationDaoImpl
implements ProjectAiConfigurationDao {
    private final DSLContext dslContext;

    public ProjectAiConfigurationDaoImpl(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public void removeAiServersFromProjectAiConfigurations(List<Long> aiServerIds) {
        this.dslContext.update((Table)Tables.PROJECT_AI_CONFIGURATION).set((Field)Tables.PROJECT_AI_CONFIGURATION.AI_SERVER_ID, null).where(Tables.PROJECT_AI_CONFIGURATION.PROJECT_ID.in(aiServerIds)).execute();
    }

    @Override
    public boolean existsByProjectIdAndAiUsageId(long projectId, Long aiUsageId) {
        return this.dslContext.fetchExists((Select)this.dslContext.selectOne().from((TableLike)Tables.PROJECT_AI_CONFIGURATION).where(Tables.PROJECT_AI_CONFIGURATION.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT_AI_CONFIGURATION.AI_USAGE_ID.eq((Object)aiUsageId)));
    }

    @Override
    public void removeConfiguration(long projectId, Long aiUsageId) {
        this.dslContext.deleteFrom((Table)Tables.PROJECT_AI_CONFIGURATION).where(Tables.PROJECT_AI_CONFIGURATION.PROJECT_ID.eq((Object)projectId)).and(Tables.PROJECT_AI_CONFIGURATION.AI_USAGE_ID.eq((Object)aiUsageId)).execute();
    }
}

