/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report.testcase;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.CaseConditionStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.GroupConcatSeparatorStep;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectOrderByStep;
import org.jooq.SelectSeekStep1;
import org.jooq.SelectSeekStep2;
import org.jooq.SelectSeekStep3;
import org.jooq.SelectSeekStep4;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomationRequest;
import org.squashtest.tm.jooq.domain.tables.InfoListItem;
import org.squashtest.tm.jooq.domain.tables.KeywordTestCase;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.ScriptedTestCase;
import org.squashtest.tm.jooq.domain.tables.TclnRelationship;
import org.squashtest.tm.jooq.domain.tables.TclnRelationshipClosure;
import org.squashtest.tm.jooq.domain.tables.TestCase;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryContent;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.dto.testcase.ActionWordFragmentValueDto;
import org.squashtest.tm.service.internal.dto.testcase.Cuf;
import org.squashtest.tm.service.internal.dto.testcase.Dataset;
import org.squashtest.tm.service.internal.dto.testcase.DatasetParamValue;
import org.squashtest.tm.service.internal.dto.testcase.LinkedRequirements;
import org.squashtest.tm.service.internal.dto.testcase.Node;
import org.squashtest.tm.service.internal.dto.testcase.Parameter;
import org.squashtest.tm.service.internal.dto.testcase.TestCaseStep;

@Service(value="squashtest.tm.plugin.report.books.testcases.query.TestCasesTreeQueryFinder")
public class TestCasesTreeQueryFinder {
    public static final String ALPHABETICAL = "ALPHABETICAL";
    public static final String ATTACH = "ATTACH";
    public static final String DATASET_LABEL = "DATASET";
    public static final String ENTITY_ID = "ENTITY_ID";
    public static final String KEYWORD_STEP_ID = "KEYWORD_STEP_ID";
    public static final String MILESTONE_NAMES = "MILESTONE_NAMES";
    public static final String ORDER = "ORDER";
    public static final String POSITIONAL = "POSITIONAL";
    public static final String REQUIREMENT = "REQUIREMENT";
    public static final String SEPARATOR = "=Sep=";
    public static final String SORT = "SORT";
    public static final String SORTING_CHAIN = "SORTING_CHAIN";
    public static final String SORTING_NAME = "SORTING_NAME";
    public static final String STEP_DATASET = "STEP_DATASET";
    public static final String UNDEFINED = "UNDEFINED";
    public static final String UNION = "UNION";
    public static final String VERSION = "version";
    public static final String TEST_CASE_SOURCE_NAME = "testCaseSourceName";
    public static final String TEST_CASE_SOURCE_REF = "testCaseSourceRef";
    public static final String TEST_CASE_SOURCE_PROJECT_NAME = "testCaseSourceProjectName";
    private final DSLContext dsl;

    @Inject
    public TestCasesTreeQueryFinder(DSLContext dsl) {
        this.dsl = dsl;
    }

    List<String> getMilestoneLabel(Integer milestoneId) {
        return this.dsl.select((SelectField)Tables.MILESTONE.LABEL).from((TableLike)Tables.MILESTONE).where(Tables.MILESTONE.MILESTONE_ID.eq((Object)milestoneId)).fetchInto(String.class);
    }

    List<Long> findIdsByProject(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    List<Long> findIdsBySelection(List<Long> ids, List<Long> projectIds) {
        if (ids != null && !ids.isEmpty()) {
            return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(ids)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
        }
        return new ArrayList<Long>();
    }

    List<Long> findIdsByMilestone(List<Long> milestoneIds, List<Long> projectIds) {
        if (!milestoneIds.isEmpty()) {
            return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).where(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.in(milestoneIds)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
        }
        return Collections.emptyList();
    }

    List<Long> findIdsByTags(List<String> tags, List<Long> projectIds) {
        if (!tags.isEmpty()) {
            return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)"TEST_CASE").and(Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL.in(tags)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"TAG")).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds))).fetch((Field)Tables.TEST_CASE.TCLN_ID);
        }
        return Collections.emptyList();
    }

    List<org.squashtest.tm.service.internal.dto.testcase.TestCase> getTestCasesData(List<Long> testCaseIds, String testCaseSortOrder) {
        TclnRelationshipClosure clos = Tables.TCLN_RELATIONSHIP_CLOSURE;
        TestCaseLibraryNode ancestorTcln = Tables.TEST_CASE_LIBRARY_NODE.as("ancestorTcln");
        TestCase ancestorTc = Tables.TEST_CASE.as("ancestorTc");
        TestCaseLibraryNode descendantTcln = Tables.TEST_CASE_LIBRARY_NODE.as("descendantTcln");
        TestCase descendantTc = Tables.TEST_CASE.as("descendantTc");
        InfoListItem tcNature = Tables.INFO_LIST_ITEM.as("tc_nature");
        InfoListItem tcType = Tables.INFO_LIST_ITEM.as("tc_type");
        ScriptedTestCase stc = Tables.SCRIPTED_TEST_CASE.as("stc");
        KeywordTestCase ktc = Tables.KEYWORD_TEST_CASE.as("ktc");
        Project p = Tables.PROJECT.as("p");
        AutomationRequest ar = Tables.AUTOMATION_REQUEST.as("ar");
        TclnRelationship tclnRel = Tables.TCLN_RELATIONSHIP.as("tclnRel");
        TestCaseLibraryContent tclc = Tables.TEST_CASE_LIBRARY_CONTENT.as("tclc");
        Field sortingKey = DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)ancestorTc.REFERENCE, (Field[])new Field[]{DSL.inline((String)" ")}), ancestorTcln.NAME, DSL.inline((String)SEPARATOR)})).orderBy(new OrderField[]{clos.DEPTH.desc()}).as("sorting_key");
        Condition whereCondition = clos.DESCENDANT_ID.in((Select)DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).where(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(testCaseIds))).or(clos.DESCENDANT_ID.in((Select)DSL.select((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(testCaseIds))));
        Field chain = DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)ancestorTc.REFERENCE, (Object)""), ancestorTcln.NAME, DSL.inline((String)SEPARATOR)})).orderBy(new OrderField[]{clos.DEPTH.desc()}).as("chain");
        Field folder = DSL.max((Field)DSL.when((Condition)descendantTc.TC_TYPE.isNull(), (Object)1).otherwise((Object)0)).as("folder");
        Field milestones = DSL.when((Condition)DSL.max((Field)descendantTc.TC_TYPE).isNull(), (Field)DSL.inline((String)"")).otherwise((Select)DSL.select((SelectField)DSL.groupConcatDistinct((Field)Tables.MILESTONE.LABEL)).from((TableLike)Tables.MILESTONE.leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID))).where(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID).and(descendantTcln.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)))).as(MILESTONE_NAMES);
        Field orderKey = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)DSL.concat((Field[])new Field[]{DSL.lpad((Field)p.TCL_ID.cast(String.class), (int)5, (String)"0"), DSL.inline((String)"-"), DSL.groupConcat((Field)DSL.coalesce((Field)DSL.lpad((Field)tclnRel.CONTENT_ORDER.cast(String.class), (int)5, (String)"0"), (Field[])new Field[]{DSL.lpad((Field)tclc.CONTENT_ORDER.cast(String.class), (int)5, (String)"0")})).orderBy(new OrderField[]{clos.DEPTH.desc()})})).otherwise(DSL.replace((Field)DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)ancestorTc.REFERENCE, (Field[])new Field[]{DSL.inline((String)"")}), ancestorTcln.NAME})).orderBy(new OrderField[]{clos.DEPTH.desc()}), (Field)DSL.inline((String)" "), (Field)DSL.inline((String)"")));
        SelectSeekStep1 query = this.dsl.select(new SelectFieldOrAsterisk[]{folder, chain, descendantTcln.TCLN_ID.as("ID"), descendantTcln.NAME.as("NAME"), DSL.max((Field)clos.DEPTH).as("level"), DSL.max((Field)DSL.coalesce((Field)descendantTc.IMPORTANCE, (Field[])new Field[]{DSL.inline((Object)TestCaseImportance.LOW)})).as("IMPORTANCE"), DSL.max((Field)DSL.coalesce((Field)tcNature.LABEL, (Field[])new Field[]{DSL.inline((String)UNDEFINED)})).as("NATURE"), DSL.max((Field)DSL.coalesce((Field)tcType.LABEL, (Field[])new Field[]{DSL.inline((String)UNDEFINED)})).as("TYPE"), DSL.max((Field)DSL.coalesce((Field)tcNature.ITEM_TYPE, (Field[])new Field[]{DSL.inline((String)UNDEFINED)})).as("natureType"), DSL.max((Field)DSL.coalesce((Field)tcType.ITEM_TYPE, (Field[])new Field[]{DSL.inline((String)UNDEFINED)})).as("typeType"), DSL.max((Field)DSL.coalesce((Field)descendantTc.TC_STATUS, (Field[])new Field[]{DSL.inline((Object)TestCaseStatus.WORK_IN_PROGRESS)})).as("STATUS"), DSL.max((Field)DSL.when((Condition)descendantTc.TA_TEST.isNull(), (Object)0).otherwise((Object)1)).as("execution_mode"), DSL.max((Field)DSL.coalesce((Field)descendantTc.PREREQUISITE, (Field[])new Field[]{DSL.inline((String)" ")})).as("prerequisites"), DSL.max((Field)DSL.coalesce((Field)descendantTc.REFERENCE, (Field[])new Field[]{DSL.inline((String)" ")})).as("REFERENCE"), descendantTcln.CREATED_ON.as("created_on"), descendantTcln.CREATED_BY.as("created_by"), descendantTcln.LAST_MODIFIED_ON.as("last_modified_on"), descendantTcln.LAST_MODIFIED_BY.as("last_modified_by"), descendantTcln.DESCRIPTION.as("DESCRIPTION"), this.dsl.select((SelectField)DSL.countDistinct((Field)Tables.ATTACHMENT.ATTACHMENT_ID)).from((TableLike)Tables.ATTACHMENT).where(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)descendantTcln.ATTACHMENT_LIST_ID)).asField("ATTACHMENTS"), sortingKey, milestones, DSL.groupConcat((Field)ancestorTcln.TCLN_ID.cast(String.class).concat(new String[]{SEPARATOR})).orderBy(new OrderField[]{clos.DEPTH.desc()}).as("nodeIds"), stc.SCRIPT, DSL.max((Field)DSL.when((Condition)stc.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.toString()).when(ktc.TCLN_ID.isNotNull(), (Object)"KEYWORD").otherwise((Object)TestCaseKind.STANDARD.toString())).as("KIND"), DSL.max((Field)DSL.when((Condition)p.ALLOW_AUTOMATION_WORKFLOW.isFalse(), (Object)0).otherwise((Object)1)).as("allow_automation_workflow"), descendantTc.AUTOMATABLE, ar.REQUEST_STATUS, ar.AUTOMATION_PRIORITY, orderKey.as("order_key")}).from((TableLike)clos).join((TableLike)ancestorTcln).on(clos.ANCESTOR_ID.eq((Field)ancestorTcln.TCLN_ID)).leftJoin((TableLike)ancestorTc).on(ancestorTcln.TCLN_ID.eq((Field)ancestorTc.TCLN_ID)).leftJoin((TableLike)tclc).on(tclc.CONTENT_ID.eq((Field)clos.ANCESTOR_ID)).join((TableLike)descendantTcln).on(clos.DESCENDANT_ID.eq((Field)descendantTcln.TCLN_ID)).leftJoin((TableLike)descendantTc).on(descendantTcln.TCLN_ID.eq((Field)descendantTc.TCLN_ID)).leftJoin((TableLike)tcNature).on(descendantTc.TC_NATURE.eq((Field)tcNature.ITEM_ID)).leftJoin((TableLike)tcType).on(descendantTc.TC_TYPE.eq((Field)tcType.ITEM_ID)).leftJoin((TableLike)stc).on(descendantTc.TCLN_ID.eq((Field)stc.TCLN_ID)).leftJoin((TableLike)ktc).on(descendantTc.TCLN_ID.eq((Field)ktc.TCLN_ID)).leftJoin((TableLike)p).on(descendantTcln.PROJECT_ID.eq((Field)p.PROJECT_ID)).leftJoin((TableLike)ar).on(descendantTc.AUTOMATION_REQUEST_ID.eq((Field)ar.AUTOMATION_REQUEST_ID)).leftJoin((TableLike)tclnRel).on(tclnRel.DESCENDANT_ID.eq((Field)clos.ANCESTOR_ID)).where(whereCondition).groupBy(new GroupField[]{clos.DESCENDANT_ID, descendantTcln.TCLN_ID, stc.SCRIPT, descendantTc.AUTOMATABLE, ar.REQUEST_STATUS, ar.AUTOMATION_PRIORITY, descendantTc.TCLN_ID, p.TCL_ID}).orderBy((OrderField)DSL.field((String)"order_key"));
        return query.fetchInto(org.squashtest.tm.service.internal.dto.testcase.TestCase.class);
    }

    String getMilestoneConfiguration() {
        SelectConditionStep query = this.dsl.select((SelectField)Tables.CORE_CONFIG.VALUE).from((TableLike)Tables.CORE_CONFIG).where((Condition)Tables.CORE_CONFIG.STR_KEY.like("feature.milestone.enabled"));
        return (String)query.fetchOne((Field)Tables.CORE_CONFIG.VALUE);
    }

    List<LinkedRequirements> getLinkedReqStepsData(List<Long> testStepsIds) {
        SelectSeekStep1 query = this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("ID"), (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.VERIFYING_STEPS.TEST_STEP_ID, (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS")).from((TableLike)Tables.RESOURCE).join((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).join((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).join((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.VERIFYING_STEPS).on(Tables.VERIFYING_STEPS.REQUIREMENT_VERSION_COVERAGE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.REQUIREMENT_VERSION_COVERAGE_ID)).where(Tables.VERIFYING_STEPS.TEST_STEP_ID.in(testStepsIds)).orderBy((OrderField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID);
        return query.fetchInto(LinkedRequirements.class);
    }

    List<LinkedRequirements> getLinkedReqData(List<Long> testCaseIds) {
        SelectSeekStep4 query = this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("ID"), (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as(VERSION), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.as("TEST_CASE_ID"), (SelectField)DSL.coalesce((Field)DSL.groupConcat((Field)Tables.MILESTONE.LABEL), (Field[])new Field[]{DSL.inline((String)"")}).as(MILESTONE_NAMES)).from((TableLike)Tables.RESOURCE).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID, Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, Tables.RESOURCE.NAME, Tables.PROJECT.NAME, Tables.REQUIREMENT_VERSION.CRITICALITY, Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS, Tables.REQUIREMENT_VERSION.VERSION_NUMBER, Tables.REQUIREMENT_VERSION.REFERENCE, Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID}).union((Select)this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.as("ID"), (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.REQUIREMENT_VERSION.CRITICALITY, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_STATUS.as("STATUS"), (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER.as(VERSION), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.as("TEST_CASE_ID"), (SelectField)DSL.groupConcat((Field)Tables.MILESTONE.LABEL).as(MILESTONE_NAMES)).from((TableLike)Tables.RESOURCE).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin((TableLike)Tables.TEST_CASE_STEPS).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).leftJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID, Tables.RESOURCE.RES_ID, Tables.REQUIREMENT_VERSION.RES_ID, Tables.PROJECT.NAME, Tables.TEST_CASE_STEPS.TEST_CASE_ID})).orderBy((OrderField)Tables.REQUIREMENT_VERSION.CRITICALITY, (OrderField)Tables.PROJECT.NAME, (OrderField)Tables.REQUIREMENT_VERSION.REFERENCE, (OrderField)Tables.RESOURCE.NAME);
        return query.fetchInto(LinkedRequirements.class);
    }

    List<TestCaseStep> getTestCaseStepsData(List<Long> testCaseIds) {
        Field attach = this.dsl.selectCount().from((TableLike)Tables.ATTACHMENT).where(Tables.ACTION_TEST_STEP.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID)).asField(ATTACH);
        Field requirement = this.dsl.selectCount().from((TableLike)Tables.VERIFYING_STEPS).where(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID)).asField(REQUIREMENT);
        SelectConditionStep first = this.dsl.select((SelectField)Tables.TEST_CASE_STEPS.STEP_ID.as("ID"), (SelectField)Tables.ACTION_TEST_STEP.ACTION, (SelectField)Tables.ACTION_TEST_STEP.EXPECTED_RESULT, (SelectField)DSL.inline((char)'S').as("TYPE"), (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(ORDER), (SelectField)DSL.inline((String)"").as(DATASET_LABEL), (SelectField)attach, (SelectField)requirement, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)DSL.inline((String)"").as("KEYWORD"), (SelectField)DSL.inline((String)"").as("DATATABLE"), (SelectField)DSL.inline((String)"").as("DOCSTRING"), (SelectField)DSL.inline((String)"").as("COMMENT"), (SelectField)DSL.inline((String)"").as("BDD_SCRIPT_LANGUAGE"), (SelectField)DSL.inline((String)"false").as("DELEGATE_PARAMETER_VALUES")).from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.ACTION_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.ACTION_TEST_STEP.TEST_STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds));
        SelectConditionStep second = this.dsl.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as("ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("ACTION"), (SelectField)DSL.inline((char)' ').as("EXPECTED_RESULT"), (SelectField)DSL.inline((char)'C').as("TYPE"), (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(ORDER), (SelectField)Tables.DATASET.NAME.as(DATASET_LABEL), (SelectField)DSL.inline((int)0).as(ATTACH), (SelectField)DSL.inline((int)0).as(REQUIREMENT), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)DSL.inline((String)"").as("KEYWORD"), (SelectField)DSL.inline((String)"").as("DATATABLE"), (SelectField)DSL.inline((String)"").as("DOCSTRING"), (SelectField)DSL.inline((String)"").as("COMMENT"), (SelectField)DSL.inline((String)"").as("BDD_SCRIPT_LANGUAGE"), (SelectField)DSL.when((Condition)Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.isTrue(), (Object)"true").otherwise((Object)"false")).from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.CALL_TEST_STEP.TEST_STEP_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_DATASET)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds));
        SelectConditionStep third = this.dsl.select((SelectField)Tables.TEST_CASE_STEPS.STEP_ID.as("ID"), (SelectField)DSL.inline((char)' ').as("ACTION"), (SelectField)DSL.inline((char)' ').as("EXPECTED_RESULT"), (SelectField)DSL.inline((char)'K').as("TYPE"), (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(ORDER), (SelectField)DSL.inline((String)"").as(DATASET_LABEL), (SelectField)DSL.inline((int)0).as(ATTACH), (SelectField)DSL.inline((int)0).as(REQUIREMENT), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID, (SelectField)Tables.KEYWORD_TEST_STEP.KEYWORD, (SelectField)Tables.KEYWORD_TEST_STEP.DATATABLE, (SelectField)Tables.KEYWORD_TEST_STEP.DOCSTRING, (SelectField)Tables.KEYWORD_TEST_STEP.COMMENT, (SelectField)Tables.PROJECT.BDD_SCRIPT_LANGUAGE, (SelectField)DSL.inline((String)"false").as("DELEGATE_PARAMETER_VALUES")).from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE_STEPS.TEST_CASE_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds));
        SelectSeekStep1 query = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)first.union((Select)second).union((Select)third).asTable(UNION)).orderBy((OrderField)DSL.field((Name)DSL.name((String[])new String[]{UNION, ORDER})));
        return query.fetchInto(TestCaseStep.class);
    }

    List<ActionWordFragmentValueDto> getBddActionFragmentsData(List<Long> testCaseIds) {
        SelectConditionStep first = this.dsl.select((SelectField)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.as(KEYWORD_STEP_ID), (SelectField)DSL.inline((String)"TEXT").as("TYPE"), (SelectField)Tables.ACTION_WORD_TEXT.TEXT.as("VALUE"), (SelectField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).innerJoin((TableLike)Tables.ACTION_WORD_FRAGMENT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).innerJoin((TableLike)Tables.ACTION_WORD_TEXT).on(Tables.ACTION_WORD_TEXT.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds));
        SelectConditionStep second = this.dsl.select((SelectField)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.as(KEYWORD_STEP_ID), (SelectField)DSL.inline((String)"PARAMETER").as("TYPE"), (SelectField)Tables.ACTION_WORD_PARAMETER_VALUE.VALUE, (SelectField)Tables.ACTION_WORD_FRAGMENT.FRAGMENT_ORDER).from((TableLike)Tables.TEST_CASE_STEPS).innerJoin((TableLike)Tables.KEYWORD_TEST_STEP).on(Tables.KEYWORD_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).innerJoin((TableLike)Tables.ACTION_WORD_FRAGMENT).on(Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_ID.eq((Field)Tables.KEYWORD_TEST_STEP.ACTION_WORD_ID)).innerJoin((TableLike)Tables.ACTION_WORD_PARAMETER_VALUE).on(Tables.ACTION_WORD_PARAMETER_VALUE.ACTION_WORD_FRAGMENT_ID.eq((Field)Tables.ACTION_WORD_FRAGMENT.ACTION_WORD_FRAGMENT_ID).and(Tables.ACTION_WORD_PARAMETER_VALUE.KEYWORD_TEST_STEP_ID.eq((Field)Tables.KEYWORD_TEST_STEP.TEST_STEP_ID))).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.in(testCaseIds));
        SelectSeekStep2 query = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)first.union((Select)second).asTable(UNION)).orderBy((OrderField)DSL.field((Name)DSL.name((String[])new String[]{UNION, KEYWORD_STEP_ID})), (OrderField)DSL.field((Name)DSL.name((String[])new String[]{UNION, "FRAGMENT_ORDER"})));
        return query.fetchInto(ActionWordFragmentValueDto.class);
    }

    List<Cuf> getCufData(String entityType, List<Long> entityIds) {
        SelectSeekStep1 query = this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.VALUE, (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE.as("TYPE"), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as(ENTITY_ID), (SelectField)Tables.CUSTOM_FIELD_BINDING.POSITION).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)entityType)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIds)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"CF")).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION);
        return query.fetchInto(Cuf.class);
    }

    List<Cuf> getNumCufData(String entityType, List<Long> entityIds) {
        SelectSeekStep1 query = this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.VALUE, (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE.as("TYPE"), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as(ENTITY_ID), (SelectField)Tables.CUSTOM_FIELD_BINDING.POSITION).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)entityType).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIds)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"NUM"))).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION);
        return query.fetchInto(Cuf.class);
    }

    List<Cuf> getRtfCufData(String entityType, List<Long> entityIds) {
        SelectSeekStep1 query = this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.LARGE_VALUE.as("VALUE"), (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE.as("TYPE"), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as(ENTITY_ID), (SelectField)Tables.CUSTOM_FIELD_BINDING.POSITION).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIds).and(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.eq((Object)entityType)).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"RTF"))).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION);
        return query.fetchInto(Cuf.class);
    }

    List<Cuf> getTagCufData(String entityType, List<Long> entityIds) {
        GroupConcatSeparatorStep labelConcat = DSL.groupConcat((Field)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL, (Object)""), DSL.inline((String)SEPARATOR)})).orderBy(new OrderField[]{Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL.asc()});
        SelectSeekStep1 query = this.dsl.select((SelectField)labelConcat.as("VALUE"), (SelectField)Tables.CUSTOM_FIELD.LABEL, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE.as("TYPE"), (SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as(ENTITY_ID), (SelectField)Tables.CUSTOM_FIELD_BINDING.POSITION).from((TableLike)Tables.CUSTOM_FIELD_VALUE).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD.CF_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CF_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)entityType).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(entityIds))).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"TAG")).groupBy(new GroupField[]{Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD.LABEL, Tables.CUSTOM_FIELD.INPUT_TYPE, Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE, Tables.CUSTOM_FIELD_BINDING.POSITION}).orderBy((OrderField)Tables.CUSTOM_FIELD_BINDING.POSITION);
        return query.fetchInto(Cuf.class);
    }

    List<Node> getRootNodesByTestCasesIds(List<Long> testCaseIds, List<Long> projectIds, String testCaseSortOrder) {
        Table<Record2<Long, String>> sortTable = this.getSortTable("");
        CaseConditionStep orderByPositional = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)DSL.concat((Field[])new Field[]{DSL.lpad((Field)DSL.cast((Field)Tables.PROJECT.TCL_ID, (DataType)SQLDataType.VARCHAR), (int)5, (String)"0"), DSL.inline((String)"-"), DSL.groupConcat((Field)DSL.coalesce((Field)DSL.lpad((Field)DSL.cast((Field)Tables.TCLN_RELATIONSHIP.CONTENT_ORDER, (DataType)SQLDataType.VARCHAR), (int)5, (String)"0"), (Field[])new Field[]{DSL.lpad((Field)DSL.cast((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER, (DataType)SQLDataType.VARCHAR), (int)5, (String)"0")})).orderBy(new OrderField[]{Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.desc()})}));
        CaseConditionStep orderByAlpha1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.max((Field)Tables.PROJECT.NAME));
        CaseConditionStep orderByAlpha2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.max((Field)DSL.field((Name)DSL.name((String[])new String[]{SORT, SORTING_NAME}), String.class)));
        SelectSeekStep3 query = this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ITEM_ID")).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join(sortTable).on(sortTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.in(testCaseIds).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds))).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID}).orderBy((OrderField)orderByPositional, (OrderField)orderByAlpha1, (OrderField)orderByAlpha2);
        return query.fetchInto(Node.class);
    }

    List<Node> getRootNodesByMilestones(List<Long> milestones, List<Long> projectIds, String testCaseSortOrder) {
        Table<Record2<Long, String>> sortTable = this.getSortTable("");
        CaseConditionStep orderByPos1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)DSL.max((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID));
        CaseConditionStep orderByPos2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)DSL.max((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER));
        CaseConditionStep orderByAlpha1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.max((Field)Tables.PROJECT.NAME));
        CaseConditionStep orderByAlpha2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.max((Field)DSL.field((Name)DSL.name((String[])new String[]{SORT, SORTING_NAME}), String.class)));
        SelectSeekStep4 query = this.dsl.select((SelectField)DSL.max((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).as("PROJECT_ID"), (SelectField)DSL.max((Field)Tables.PROJECT.NAME).as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ITEM_ID"), (SelectField)DSL.max((Field)sortTable.field(SORTING_NAME)).as(SORTING_CHAIN)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.MILESTONE_BINDING).on(Tables.MILESTONE_BINDING.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_BINDING.MILESTONE_ID)).join(sortTable).on(sortTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID)).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.MILESTONE.MILESTONE_ID.in(milestones)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID}).orderBy((OrderField)orderByPos1, (OrderField)orderByPos2, (OrderField)orderByAlpha1, (OrderField)orderByAlpha2);
        return query.fetchInto(Node.class);
    }

    List<Node> getRootNodesTags(List<String> tags, List<Long> projectIds, String testCaseSortOrder) {
        Table<Record2<Long, String>> sortTable = this.getSortTable(" ");
        CaseConditionStep orderByPos1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)DSL.max((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID));
        CaseConditionStep orderByPos2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)DSL.max((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER));
        CaseConditionStep orderByAlpha1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.max((Field)Tables.PROJECT.NAME));
        CaseConditionStep orderByAlpha2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.max((Field)DSL.field((Name)DSL.name((String[])new String[]{SORT, SORTING_NAME}), String.class)));
        SelectSeekStep4 query = this.dsl.select((SelectField)DSL.max((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).as("PROJECT_ID"), (SelectField)DSL.max((Field)Tables.PROJECT.NAME).as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ITEM_ID"), (SelectField)DSL.max((Field)sortTable.field(SORTING_NAME)).as(SORTING_CHAIN)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD_BINDING).on(Tables.CUSTOM_FIELD_BINDING.BOUND_PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.CFB_ID.eq((Field)Tables.CUSTOM_FIELD_BINDING.CFB_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).join(sortTable).on(sortTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID)).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.CUSTOM_FIELD_BINDING.BOUND_ENTITY.eq((Object)"TEST_CASE")).and(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)"TAG")).and(Tables.CUSTOM_FIELD_VALUE_OPTION.LABEL.in(tags)).and(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).groupBy(new GroupField[]{Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID}).orderBy((OrderField)orderByPos1, (OrderField)orderByPos2, (OrderField)orderByAlpha1, (OrderField)orderByAlpha2);
        return query.fetchInto(Node.class);
    }

    List<Node> getRootNodesByProjectIds(List<Long> projectIds, String testCaseSortOrder) {
        Table<Record2<Long, String>> sortTable = this.getSortTable("");
        CaseConditionStep orderByPos1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID);
        CaseConditionStep orderByPos2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)POSITIONAL), (Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ORDER);
        CaseConditionStep orderByAlpha1 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)Tables.PROJECT.NAME);
        CaseConditionStep orderByAlpha2 = DSL.when((Condition)DSL.val((String)testCaseSortOrder).eq((Object)ALPHABETICAL), (Field)DSL.field((Name)DSL.name((String[])new String[]{SORT, SORTING_NAME}), String.class));
        SelectSeekStep4 query = this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.as("ITEM_ID"), (SelectField)sortTable.field(SORTING_NAME).as(SORTING_CHAIN)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).join((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).join(sortTable).on(sortTable.field("TCLN_ID", Long.class).eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID)).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)orderByPos1, (OrderField)orderByPos2, (OrderField)orderByAlpha1, (OrderField)orderByAlpha2);
        return query.fetchInto(Node.class);
    }

    Table<Record2<Long, String>> getSortTable(String separator) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID, (SelectField)DSL.concat((Field[])new Field[]{DSL.coalesce((Field)Tables.TEST_CASE.REFERENCE, (Field[])new Field[]{DSL.inline((String)separator)}), Tables.TEST_CASE_LIBRARY_NODE.NAME}).as(SORTING_NAME)).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).asTable(SORT);
    }

    List<TestCaseStep> getTestCaseStepsData(Long testCaseId) {
        Field attach = this.dsl.selectCount().from((TableLike)Tables.ATTACHMENT).where(Tables.ACTION_TEST_STEP.ATTACHMENT_LIST_ID.eq((Field)Tables.ATTACHMENT.ATTACHMENT_LIST_ID)).asField(ATTACH);
        Field requirement = this.dsl.selectCount().from((TableLike)Tables.VERIFYING_STEPS).where(Tables.TEST_CASE_STEPS.STEP_ID.eq((Field)Tables.VERIFYING_STEPS.TEST_STEP_ID)).asField(REQUIREMENT);
        SelectConditionStep first = this.dsl.select((SelectField)Tables.TEST_CASE_STEPS.STEP_ID.as("ID"), (SelectField)Tables.ACTION_TEST_STEP.ACTION, (SelectField)Tables.ACTION_TEST_STEP.EXPECTED_RESULT, (SelectField)DSL.inline((String)"S").as("TYPE"), (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(ORDER), (SelectField)DSL.inline((String)"").as(DATASET_LABEL), (SelectField)attach, (SelectField)requirement, (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.ACTION_TEST_STEP).on(Tables.ACTION_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Object)testCaseId));
        SelectConditionStep second = this.dsl.select((SelectField)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID.as("ID"), (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("ACTION"), (SelectField)DSL.inline((String)" ").as("EXPECTED_RESULT"), (SelectField)DSL.inline((String)"C").as("TYPE"), (SelectField)Tables.TEST_CASE_STEPS.STEP_ORDER.as(ORDER), (SelectField)Tables.DATASET.NAME.as(DATASET_LABEL), (SelectField)DSL.inline((int)0).as(ATTACH), (SelectField)DSL.inline((int)0).as(REQUIREMENT), (SelectField)Tables.TEST_CASE_STEPS.TEST_CASE_ID).from((TableLike)Tables.TEST_CASE_STEPS).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_DATASET)).where(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Object)testCaseId));
        SelectSeekStep1 query = this.dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)first.union((Select)second).asTable(UNION)).orderBy((OrderField)DSL.field((Name)DSL.name((String[])new String[]{UNION, ORDER})));
        return query.fetchInto(TestCaseStep.class);
    }

    List<Parameter> getParametersData(List<Long> testCaseIds) {
        TestCase tcc = Tables.TEST_CASE.as("tcc");
        TestCase tc = Tables.TEST_CASE.as("tc");
        SelectOrderByStep query = this.dsl.select((SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.PARAMETER.DESCRIPTION, (SelectField)Tables.PARAMETER.TEST_CASE_ID, (SelectField)DSL.inline((String)"").as(TEST_CASE_SOURCE_NAME), (SelectField)DSL.inline((String)"").as(TEST_CASE_SOURCE_REF), (SelectField)DSL.inline((String)"").as(TEST_CASE_SOURCE_PROJECT_NAME)).from((TableLike)Tables.PARAMETER).where(Tables.PARAMETER.TEST_CASE_ID.in(testCaseIds)).union((Select)this.dsl.select((SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.PARAMETER.DESCRIPTION, (SelectField)tc.TCLN_ID, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME.as(TEST_CASE_SOURCE_NAME), (SelectField)tcc.REFERENCE.as(TEST_CASE_SOURCE_REF), (SelectField)Tables.PROJECT.NAME.as(TEST_CASE_SOURCE_PROJECT_NAME)).from((TableLike)Tables.PARAMETER).join((TableLike)Tables.CALL_TEST_STEP).on(Tables.PARAMETER.TEST_CASE_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).join((TableLike)tcc).on(tcc.TCLN_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(tcc.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).join((TableLike)Tables.TEST_CASE_STEPS).on(Tables.CALL_TEST_STEP.TEST_STEP_ID.eq((Field)Tables.TEST_CASE_STEPS.STEP_ID)).join((TableLike)tc).on(Tables.TEST_CASE_STEPS.TEST_CASE_ID.eq((Field)tc.TCLN_ID)).where(tc.TCLN_ID.in(testCaseIds)).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.isTrue()));
        return query.fetchInto(Parameter.class);
    }

    List<Dataset> getDataSetData(List<Long> testCaseIds) {
        SelectConditionStep query = this.dsl.select((SelectField)Tables.DATASET.DATASET_ID.as("ID"), (SelectField)Tables.DATASET.NAME, (SelectField)Tables.DATASET.TEST_CASE_ID).from((TableLike)Tables.DATASET).where(Tables.DATASET.TEST_CASE_ID.in(testCaseIds));
        return query.fetchInto(Dataset.class);
    }

    List<DatasetParamValue> getDatasetParamValueData(List<Long> testCaseIds) {
        SelectOrderByStep query = this.dsl.select((SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.DATASET_PARAM_VALUE.PARAM_VALUE.as("VALUE")).from((TableLike)Tables.DATASET).innerJoin((TableLike)Tables.DATASET_PARAM_VALUE).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.DATASET_PARAM_VALUE.DATASET_ID)).innerJoin((TableLike)Tables.PARAMETER).on(Tables.PARAMETER.PARAM_ID.eq((Field)Tables.DATASET_PARAM_VALUE.PARAM_ID)).where(Tables.DATASET.TEST_CASE_ID.in(testCaseIds)).union((Select)this.dsl.select((SelectField)Tables.DATASET.DATASET_ID, (SelectField)Tables.PARAMETER.NAME, (SelectField)Tables.DATASET_PARAM_VALUE.PARAM_VALUE.as("VALUE")).from((TableLike)Tables.DATASET).innerJoin((TableLike)Tables.DATASET_PARAM_VALUE).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.DATASET_PARAM_VALUE.DATASET_ID)).innerJoin((TableLike)Tables.PARAMETER).on(Tables.PARAMETER.PARAM_ID.eq((Field)Tables.DATASET_PARAM_VALUE.PARAM_ID)).leftJoin((TableLike)Tables.CALL_TEST_STEP).on(Tables.PARAMETER.TEST_CASE_ID.eq((Field)Tables.CALL_TEST_STEP.CALLED_TEST_CASE_ID)).where(Tables.DATASET.TEST_CASE_ID.in(testCaseIds)).and(Tables.CALL_TEST_STEP.DELEGATE_PARAMETER_VALUES.isTrue()));
        return query.fetchInto(DatasetParamValue.class);
    }
}

