/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report.testcase;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.query.ReportQuery;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.api.utils.CurrentUserHelper;
import org.squashtest.tm.service.internal.dto.testcase.ActionWordFragmentValueDto;
import org.squashtest.tm.service.internal.dto.testcase.Cuf;
import org.squashtest.tm.service.internal.dto.testcase.Data;
import org.squashtest.tm.service.internal.dto.testcase.Dataset;
import org.squashtest.tm.service.internal.dto.testcase.DatasetParamValue;
import org.squashtest.tm.service.internal.dto.testcase.LinkedRequirements;
import org.squashtest.tm.service.internal.dto.testcase.Node;
import org.squashtest.tm.service.internal.dto.testcase.Parameter;
import org.squashtest.tm.service.internal.dto.testcase.PrintableCuf;
import org.squashtest.tm.service.internal.dto.testcase.Project;
import org.squashtest.tm.service.internal.dto.testcase.TestCase;
import org.squashtest.tm.service.internal.dto.testcase.TestCaseStep;
import org.squashtest.tm.service.internal.dto.testcase.foundation.CriteriaEntry;
import org.squashtest.tm.service.internal.dto.testcase.foundation.EntityType;
import org.squashtest.tm.service.internal.dto.testcase.foundation.ParameterData;
import org.squashtest.tm.service.internal.dto.testcase.foundation.PrintStepData;
import org.squashtest.tm.service.internal.dto.testcase.foundation.ReportOptions;
import org.squashtest.tm.service.internal.report.testcase.TestCasesTreeFormatter;
import org.squashtest.tm.service.internal.report.testcase.TestCasesTreeQueryFinder;

@Component(value="squashtest.tm.plugin.report.books.testcases.query.TestCasesTreeQuery")
public class TestCasesTreeQuery
implements ReportQuery {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestCasesTreeQuery.class);
    private static final String DATA = "data";
    private static final String DEFAULT_SORT_ORDER = "ALPHABETICAL";
    private static final String DEFAULT_TEMPLATE_VALUE = "defaultTemplate";
    private static final String FILENAME = "fileName";
    private static final String HTML = "html";
    private static final String MILESTONE_LABEL = "milestoneLabel";
    private static final String MILESTONE_PICKER = "MILESTONE_PICKER";
    private static final String TAG_PICKER = "TAG_PICKER";
    private static final String TEMPLATE_FILE_NAME = "templateFileName";
    private static final String TEST_CASE_SORT_ORDER = "testCaseSortOrder";
    private static final String TREE_PICKER = "TREE_PICKER";
    private final TestCasesTreeFormatter formatter;
    private final TestCasesTreeQueryFinder queryFinder;
    private final CurrentUserHelper currentUserHelper;

    @Inject
    public TestCasesTreeQuery(TestCasesTreeQueryFinder queryFinder, CurrentUserHelper currentUserHelper, AttachmentImageHelper attachmentImageHelper) {
        this.formatter = new TestCasesTreeFormatter(attachmentImageHelper);
        this.queryFinder = queryFinder;
        this.currentUserHelper = currentUserHelper;
    }

    public void executeQuery(Map<String, Criteria> crit, Map<String, Object> res) {
        String format = (String)res.get("format");
        boolean isEditable = "docx".equals(format);
        ArrayList<String> html = new ArrayList<String>();
        Map<String, Boolean> optionsMap = TestCasesTreeQuery.getOptionsMap(crit);
        String testCaseSortOrder = Objects.nonNull(crit.get(TEST_CASE_SORT_ORDER)) ? (String)crit.get(TEST_CASE_SORT_ORDER).getValue() : DEFAULT_SORT_ORDER;
        String templateFileName = this.retrieveTemplateFileName(crit.get(TEMPLATE_FILE_NAME));
        List<Node> rootNodes = this.getRootNodes(crit, testCaseSortOrder);
        List<Long> tcIds = this.getTestCaseIds(crit);
        if (!tcIds.isEmpty()) {
            boolean printLinkedRequirement = optionsMap.get(ReportOptions.PRINT_LINKED_REQUIREMENTS.getValue());
            List<LinkedRequirements> linkedRequirements = this.getLinkedRequirements(printLinkedRequirement, tcIds);
            List<TestCase> testCases = this.queryFinder.getTestCasesData(tcIds, testCaseSortOrder);
            String rawConfigurationData = this.queryFinder.getMilestoneConfiguration();
            boolean printMilestones = this.formatter.rawMilestoneConfigToBoolean(rawConfigurationData);
            boolean printFolder = optionsMap.get(ReportOptions.PRINT_FOLDER.getValue());
            boolean printSteps = optionsMap.get(ReportOptions.PRINT_STEPS.getValue());
            boolean printParameters = optionsMap.get(ReportOptions.PRINT_PARAMETERS.getValue());
            ParameterData parameterData = this.getParameterData(printParameters, tcIds);
            PrintStepData printStepData = new PrintStepData();
            if (printSteps) {
                this.setPrintStepData(printStepData, optionsMap, tcIds, html, isEditable);
            }
            this.formatter.toTestCase(testCases, printLinkedRequirement, printParameters, printFolder, printSteps, printMilestones);
            List<PrintableCuf> testCasePrintCufs = this.setPrintableCufList(testCases, tcIds, html);
            this.formatter.bindStep(testCases, printStepData);
            this.formatter.bindAll(linkedRequirements, testCases, parameterData, rootNodes, testCasePrintCufs);
        }
        String milestoneLabel = null;
        if (this.isMilestonePicker(crit)) {
            List milestoneIds = (List)crit.get(CriteriaEntry.MILESTONES.getValue()).getValue();
            milestoneLabel = this.queryFinder.getMilestoneLabel((Integer)milestoneIds.getFirst()).getFirst();
            res.put(MILESTONE_LABEL, milestoneLabel);
        }
        if (isEditable) {
            this.processRichText(rootNodes, html);
            this.processChain(rootNodes);
            Data data = new Data(milestoneLabel, testCaseSortOrder, templateFileName);
            data.setProjects(this.populateProjectFromNode(rootNodes));
            res.put(FILENAME, data.getFileTitleTestCasesReport());
            res.put(DATA, data);
            res.put(HTML, html);
        } else {
            res.put(DATA, rootNodes);
        }
    }

    private static Map<String, Boolean> getOptionsMap(Map<String, Criteria> crit) {
        HashMap<String, Boolean> optionsMap = new HashMap<String, Boolean>();
        optionsMap.put(ReportOptions.PRINT_STEPS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_LINKED_REQUIREMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_CALL_STEPS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_PARAMETERS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_CUFS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_ATTACHMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_STEP_LINKED_REQUIREMENTS.getValue(), false);
        optionsMap.put(ReportOptions.PRINT_FOLDER.getValue(), false);
        Criteria options = crit.get(CriteriaEntry.REPORT_OPTIONS.getValue());
        List selectedOptions = (List)options.getValue();
        for (String option : selectedOptions) {
            optionsMap.put(option, true);
        }
        return optionsMap;
    }

    private List<LinkedRequirements> getLinkedRequirements(Boolean printLinkedRequirement, List<Long> testCaseIds) {
        if (printLinkedRequirement.booleanValue()) {
            return this.queryFinder.getLinkedReqData(testCaseIds);
        }
        return Collections.emptyList();
    }

    private ParameterData getParameterData(Boolean printParameters, List<Long> tcIds) {
        List<Parameter> parameters = new ArrayList<Parameter>();
        List<Dataset> datasets = new ArrayList<Dataset>();
        List<DatasetParamValue> datasetParamValuesData = new ArrayList<DatasetParamValue>();
        if (printParameters.booleanValue()) {
            parameters = this.queryFinder.getParametersData(tcIds);
            datasets = this.queryFinder.getDataSetData(tcIds);
            datasetParamValuesData = this.queryFinder.getDatasetParamValueData(tcIds);
        }
        return new ParameterData(parameters, datasets, datasetParamValuesData);
    }

    private void setPrintStepData(PrintStepData printStepData, Map<String, Boolean> optionsMap, List<Long> tcIds, List<String> html, boolean isEditable) {
        boolean printCallSteps = optionsMap.get(ReportOptions.PRINT_CALL_STEPS.getValue());
        boolean printAttachments = optionsMap.get(ReportOptions.PRINT_STEP_ATTACHMENTS.getValue());
        boolean printStepAttachment = optionsMap.get(ReportOptions.PRINT_STEP_ATTACHMENTS.getValue());
        boolean printStepLinkedRequirement = optionsMap.get(ReportOptions.PRINT_STEP_LINKED_REQUIREMENTS.getValue());
        boolean printStepCufs = optionsMap.get(ReportOptions.PRINT_STEP_CUFS.getValue());
        printStepData.setTestCaseSteps(this.queryFinder.getTestCaseStepsData(tcIds));
        if (!isEditable) {
            this.formatter.cleanStepsForPdf(printStepData);
        }
        List<ActionWordFragmentValueDto> actionWordFragmentValues = this.queryFinder.getBddActionFragmentsData(tcIds);
        this.formatter.toTestCaseSteps(printStepData.getTestCaseSteps(), actionWordFragmentValues, printAttachments, printStepLinkedRequirement, printStepCufs);
        if (printCallSteps) {
            this.setPrintCallSteps(printStepData, printStepAttachment, printStepLinkedRequirement, printStepCufs);
        }
        ArrayList<Long> stepIds = new ArrayList<Long>();
        for (TestCaseStep steps : printStepData.getTestCaseSteps()) {
            stepIds.add(steps.getId());
        }
        this.setPrintableStepCufs(printStepData, stepIds, optionsMap, html);
    }

    void setPrintCallSteps(PrintStepData printStepData, boolean printStepAttachment, boolean printStepLinkedRequirement, boolean printStepCufs) {
        ArrayList<TestCaseStep> testCaseSteps = new ArrayList<TestCaseStep>();
        this.addCalledSteps(printStepData.getTestCaseSteps(), testCaseSteps, printStepAttachment, printStepLinkedRequirement, printStepCufs);
        printStepData.setTestCaseSteps(testCaseSteps);
    }

    private List<PrintableCuf> setPrintableCufList(List<TestCase> testCases, List<Long> tcIds, List<String> html) {
        List<Long> folderIds = this.getFolderIds(testCases);
        List<Cuf> testCaseCuf = this.queryFinder.getCufData(EntityType.TEST_CASE.name(), tcIds);
        testCaseCuf.addAll(this.queryFinder.getCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
        this.formatter.bindCufToTestCase(testCases, testCaseCuf);
        List<Cuf> testCaseNumCuf = this.queryFinder.getNumCufData(EntityType.TEST_CASE.name(), tcIds);
        testCaseNumCuf.addAll(this.queryFinder.getNumCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
        this.formatter.bindNumCufToTestCase(testCases, testCaseNumCuf);
        List<Cuf> testCaseTagCuf = this.queryFinder.getTagCufData(EntityType.TEST_CASE.name(), tcIds);
        testCaseTagCuf.addAll(this.queryFinder.getTagCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
        this.formatter.toTagCuf(testCaseTagCuf);
        this.formatter.bindTagCufTestCase(testCases, testCaseTagCuf);
        List<Cuf> testCaseRtfCuf = this.queryFinder.getRtfCufData(EntityType.TEST_CASE.name(), tcIds);
        testCaseRtfCuf.addAll(this.queryFinder.getRtfCufData(EntityType.TESTCASE_FOLDER.name(), folderIds));
        this.formatter.bindRtfCufToTestCase(testCases, testCaseRtfCuf);
        return this.formatter.toPrintableCufList(testCaseCuf, testCaseNumCuf, testCaseTagCuf, testCaseRtfCuf, html);
    }

    private void setPrintableStepCufs(PrintStepData printStepData, List<Long> stepIds, Map<String, Boolean> optionsMap, List<String> html) {
        List<Cuf> stepCuf = new ArrayList<Cuf>();
        List<Cuf> stepNumCuf = new ArrayList<Cuf>();
        List<Cuf> stepTagCuf = new ArrayList<Cuf>();
        List<Cuf> stepRtfCuf = new ArrayList<Cuf>();
        if (!stepIds.isEmpty()) {
            if (optionsMap.get(ReportOptions.PRINT_STEP_CUFS.getValue()).booleanValue()) {
                stepCuf = this.queryFinder.getCufData(EntityType.TEST_STEP.name(), stepIds);
                stepNumCuf = this.queryFinder.getNumCufData(EntityType.TEST_STEP.name(), stepIds);
                stepTagCuf = this.queryFinder.getTagCufData(EntityType.TEST_STEP.name(), stepIds);
                this.formatter.toTagCuf(stepTagCuf);
                stepRtfCuf = this.queryFinder.getRtfCufData(EntityType.TEST_STEP.name(), stepIds);
                List<TestCaseStep> testCaseSteps = printStepData.getTestCaseSteps();
                this.formatter.bindCufToStep(testCaseSteps, stepCuf);
                this.formatter.bindRtfCufToStep(testCaseSteps, stepNumCuf);
                this.formatter.bindTagCufToStep(testCaseSteps, stepTagCuf);
                this.formatter.bindNumCufToStep(testCaseSteps, stepRtfCuf);
                printStepData.setTestCaseSteps(testCaseSteps);
            }
            if (optionsMap.get(ReportOptions.PRINT_STEP_LINKED_REQUIREMENTS.getValue()).booleanValue()) {
                printStepData.setLinkedRequirementsBySteps(this.queryFinder.getLinkedReqStepsData(stepIds));
            }
        }
        printStepData.setPrintableStepCufs(this.formatter.toPrintableCufList(stepCuf, stepNumCuf, stepTagCuf, stepRtfCuf, html));
    }

    private String retrieveTemplateFileName(Criteria templateCriteria) {
        if (Objects.nonNull(templateCriteria)) {
            try {
                return (String)templateCriteria.getValue();
            }
            catch (ClassCastException cce) {
                LOGGER.trace("Custom template file does not exist anymore.", (Throwable)cce);
            }
        }
        return DEFAULT_TEMPLATE_VALUE;
    }

    private List<Long> getFolderIds(List<TestCase> testCases) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        for (TestCase testCase : testCases) {
            if (!testCase.isFolderType()) continue;
            folderIds.add(testCase.getId());
        }
        return folderIds;
    }

    private List<Long> getTestCaseIds(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        switch (selectionMode.getValue().toString()) {
            case "TREE_PICKER": {
                Criteria idsCrit = criteriaMap.get(CriteriaEntry.TEST_CASE_IDS.getValue());
                Collection testCaseIdsAsString = this.addNodesIds(idsCrit);
                List<Long> testCaseIds = testCaseIdsAsString.stream().map(Long::parseLong).toList();
                return this.queryFinder.findIdsBySelection(testCaseIds, readableProjectIds);
            }
            case "MILESTONE_PICKER": {
                List milestones = (List)criteriaMap.get(CriteriaEntry.MILESTONES.getValue()).getValue();
                List<Long> milestoneIds = milestones.stream().map(Integer::longValue).toList();
                return this.queryFinder.findIdsByMilestone(milestoneIds, readableProjectIds);
            }
            case "TAG_PICKER": {
                List tags = (List)criteriaMap.get(CriteriaEntry.TAGS.getValue()).getValue();
                return this.queryFinder.findIdsByTags(tags, readableProjectIds);
            }
        }
        Criteria idsCrit = criteriaMap.get(CriteriaEntry.PROJECT_IDS.getValue());
        if (!idsCrit.getValue().toString().trim().isEmpty()) {
            List<Long> projectIds = ((List)idsCrit.getValue()).stream().map(Long::valueOf).toList();
            readableProjectIds.retainAll(projectIds);
            return this.queryFinder.findIdsByProject(readableProjectIds);
        }
        return Collections.emptyList();
    }

    private List<Node> getRootNodes(Map<String, Criteria> criteriaMap, String testCaseSortOrder) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        List readableProjectIds = this.currentUserHelper.findReadableProjectIds();
        switch (selectionMode.getValue().toString()) {
            case "TREE_PICKER": {
                Criteria idsCrit = criteriaMap.get(CriteriaEntry.TEST_CASE_IDS.getValue());
                Collection testCaseIds = this.addNodesIds(idsCrit);
                List<Long> testCaseIdList = testCaseIds.stream().map(Long::parseLong).toList();
                return this.queryFinder.getRootNodesByTestCasesIds(testCaseIdList, readableProjectIds, testCaseSortOrder);
            }
            case "MILESTONE_PICKER": {
                List milestoneIds = (List)criteriaMap.get(CriteriaEntry.MILESTONES.getValue()).getValue();
                List<Long> milestoneIdList = milestoneIds.stream().map(Integer::longValue).toList();
                return this.queryFinder.getRootNodesByMilestones(milestoneIdList, readableProjectIds, testCaseSortOrder);
            }
            case "TAG_PICKER": {
                List tags = (List)criteriaMap.get(CriteriaEntry.TAGS.getValue()).getValue();
                return this.queryFinder.getRootNodesTags(tags, readableProjectIds, testCaseSortOrder);
            }
        }
        Criteria idsCrit = criteriaMap.get(CriteriaEntry.PROJECT_IDS.getValue());
        if (!idsCrit.getValue().toString().trim().isEmpty()) {
            List<Long> projectIds = ((List)idsCrit.getValue()).stream().map(Long::valueOf).toList();
            readableProjectIds.retainAll(projectIds);
            return this.queryFinder.getRootNodesByProjectIds(readableProjectIds, testCaseSortOrder);
        }
        return Collections.emptyList();
    }

    private void addCalledSteps(List<TestCaseStep> testCaseSteps, List<TestCaseStep> allSteps, boolean printAttachment, boolean printStepLinkedReq, boolean printStepCufs) {
        for (TestCaseStep testCaseStep : testCaseSteps) {
            if ("C".equals(testCaseStep.getType())) {
                Long id = testCaseStep.getId();
                List<TestCaseStep> testCaseStepsData = this.queryFinder.getTestCaseStepsData(id);
                this.formatter.toCallStep(testCaseStepsData, testCaseStep.getTestCaseId(), printAttachment, printStepLinkedReq, printStepCufs);
                this.addCalledSteps(testCaseStepsData, allSteps, printAttachment, printStepLinkedReq, printStepCufs);
                continue;
            }
            allSteps.add(testCaseStep);
        }
    }

    private List<Project> populateProjectFromNode(List<Node> nodes) {
        LinkedHashMap<Long, Project> map = new LinkedHashMap<Long, Project>();
        for (Node node : nodes) {
            Project p = (Project)map.get(node.getProjectId());
            if (p != null) {
                p.addTestCases(node.getTestCases());
                continue;
            }
            p = new Project();
            p.setProjectId(node.getProjectId());
            p.setProjectName(node.getProjectName());
            p.setTestCases(node.getTestCases());
            map.put(p.getProjectId(), p);
        }
        return new ArrayList<Project>(map.values());
    }

    private void processRichText(List<Node> nodes, List<String> html) {
        for (Node node : nodes) {
            this.richTextForTc(node.getTestCases(), html);
        }
    }

    private void richTextForTc(List<TestCase> tcs, List<String> html) {
        for (TestCase tc : tcs) {
            tc.setDescription(this.formatter.richTextReplace(tc.getDescription(), html));
            tc.setPrerequisites(this.formatter.richTextReplace(tc.getPrerequisites(), html));
            if (!tc.isScriptEmpty()) {
                tc.setScript(this.replaceScriptString(tc.getScript(), html));
            }
            this.richTextForParameter(tc.getParameters(), html);
            this.richTextForStep(tc.getTcSteps(), html);
        }
    }

    private String replaceScriptString(String initScript, List<String> html) {
        initScript = HtmlUtils.htmlEscape((String)initScript);
        initScript = initScript.replace("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        initScript = initScript.replace("<", "&lt;");
        initScript = initScript.replace(">", "&gt;");
        initScript = initScript.replace("\\n", "<br />");
        return this.formatter.richTextReplace("<p>" + initScript + "</p>", html);
    }

    private void richTextForStep(List<TestCaseStep> steps, List<String> html) {
        for (TestCaseStep step : steps) {
            if ("C".equals(step.getType())) {
                step.setAction(HtmlUtils.htmlEscape((String)step.getAction()));
            }
            step.setAction(this.formatter.richTextReplace(step.getAction(), html));
            step.setExpectedResult(this.formatter.richTextReplace(step.getExpectedResult(), html));
        }
    }

    private void richTextForParameter(List<Parameter> parameters, List<String> html) {
        for (Parameter param : parameters) {
            param.setDescription(this.formatter.richTextReplace(param.getDescription(), html));
        }
    }

    private void processChain(List<Node> nodes) {
        String previousChain = null;
        String folderDescription = "";
        for (Node node : nodes) {
            for (TestCase tc : node.getTestCases()) {
                if (!tc.isFolderType()) {
                    boolean shouldReprint = !tc.getChain().equals(previousChain);
                    previousChain = tc.getChain();
                    tc.setPrintChain(shouldReprint);
                    folderDescription = this.folderDescriptionForTestCase(tc, folderDescription);
                    continue;
                }
                folderDescription = tc.getDescription();
            }
        }
    }

    private String folderDescriptionForTestCase(TestCase tc, String folderDescription) {
        if (!"".equals(folderDescription)) {
            tc.setChainDescription(folderDescription);
        }
        return "";
    }

    private Collection addNodesIds(Criteria idsCrit) {
        if (idsCrit != null) {
            Collection ids = ((Map)idsCrit.getValue()).values();
            if (!ids.isEmpty()) {
                return new HashSet(ids);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private boolean isMilestonePicker(Map<String, Criteria> criteriaMap) {
        Criteria selectionMode = criteriaMap.get(CriteriaEntry.TEST_CASES_SELECTION_MODE.getValue());
        return MILESTONE_PICKER.equals(selectionMode.getValue());
    }
}

