/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report.testcase;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.service.internal.dto.testcase.ActionWordFragmentValueDto;
import org.squashtest.tm.service.internal.dto.testcase.Cuf;
import org.squashtest.tm.service.internal.dto.testcase.Dataset;
import org.squashtest.tm.service.internal.dto.testcase.DatasetParamValue;
import org.squashtest.tm.service.internal.dto.testcase.I18nHelper;
import org.squashtest.tm.service.internal.dto.testcase.LinkedRequirements;
import org.squashtest.tm.service.internal.dto.testcase.Node;
import org.squashtest.tm.service.internal.dto.testcase.Parameter;
import org.squashtest.tm.service.internal.dto.testcase.PrintableCuf;
import org.squashtest.tm.service.internal.dto.testcase.TestCase;
import org.squashtest.tm.service.internal.dto.testcase.TestCaseStep;
import org.squashtest.tm.service.internal.dto.testcase.foundation.ParameterData;
import org.squashtest.tm.service.internal.dto.testcase.foundation.PrintStepData;
import org.squashtest.tm.service.internal.report.testcase.TestCaseHierarchyHelper;

public class TestCasesTreeFormatter {
    public static final Logger LOGGER = LoggerFactory.getLogger(TestCasesTreeFormatter.class);
    private static final String END_SEPARATOR_PLACEHOLDER = "=Sep=";
    private static final String SEPARATOR_PLACEHOLDER = "=Sep=,";
    private static final String TAG_EMPTY = "";
    private static final String TAG_SEPARATOR = " | ";
    private static final String DATE_REGEX = "\\d{4}\\-(0?[1-9]|1[012])\\-(0?[1-9]|[12][0-9]|3[01])*";
    private static final int MAX_IMAGE_SIZE = 700;
    public static final String KEYWORD = "K";
    public static final String CLASSIC = "C";
    private TestCaseHierarchyHelper hierarchyHelper;
    private String projectName;
    private List<Long> tcIdsAlreadyAdd;
    private final AttachmentImageHelper attachmentImageHelper;

    public TestCasesTreeFormatter(AttachmentImageHelper attachmentImageHelper) {
        this.attachmentImageHelper = attachmentImageHelper;
    }

    void toTestCaseSteps(List<TestCaseStep> testCaseStepData, List<ActionWordFragmentValueDto> bddActionFragments, boolean printAttachments, boolean printLinkedReq, boolean printCufs) {
        testCaseStepData.forEach(testCaseStep -> {
            String action = testCaseStep.getAction();
            if (CLASSIC.equals(testCaseStep.getType())) {
                testCaseStep.setHasNoResult(true);
                ArrayList<String> params = new ArrayList<String>();
                params.add(action);
                action = I18nHelper.translate("report.books.testcases.steps.call", params.toArray());
                if (!testCaseStep.getDataset().isEmpty()) {
                    params.add(testCaseStep.getDataset());
                    action = I18nHelper.translate("report.books.testcases.steps.call.dataset", params.toArray());
                } else if (testCaseStep.isDelegateParameterValues()) {
                    params.add(I18nHelper.translate("report.books.callstepdataset.Delegate"));
                    action = I18nHelper.translate("report.books.testcases.steps.call.dataset", params.toArray());
                }
            } else if (KEYWORD.equals(testCaseStep.getType())) {
                testCaseStep.setBddAction(this.buildBddActionForStep(testCaseStep.getId(), bddActionFragments));
            }
            testCaseStep.setAction(action);
            testCaseStep.setPrintAttachments(printAttachments);
            testCaseStep.setPrintStepLinkedReq(printLinkedReq);
            testCaseStep.setPrintCufs(printCufs);
        });
    }

    private String buildBddActionForStep(Long stepId, List<ActionWordFragmentValueDto> bddActionFragments) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ActionWordFragmentValueDto fragment : bddActionFragments) {
            if (!stepId.equals(fragment.getKeywordStepId())) continue;
            stringBuilder.append(fragment.getUnstyledAction());
        }
        return stringBuilder.toString();
    }

    public List<PrintableCuf> toPrintableCufList(List<Cuf> cufsList, List<Cuf> numCufsList, List<Cuf> tagCufsList, List<Cuf> rtfCufsList, List<String> html) {
        ArrayList<PrintableCuf> result = new ArrayList<PrintableCuf>();
        for (Cuf cuf : cufsList) {
            this.toPrintableCuf(cuf, result, html);
        }
        for (Cuf numCuf : numCufsList) {
            this.toPrintableCuf(numCuf, result, html);
        }
        for (Cuf tagCuf : tagCufsList) {
            this.toPrintableCuf(tagCuf, result, html);
        }
        for (Cuf rtfCuf : rtfCufsList) {
            this.toPrintableCuf(rtfCuf, result, html);
        }
        return result;
    }

    public void toPrintableCuf(Cuf cuf, List<PrintableCuf> resultList, List<String> html) {
        PrintableCuf printableCuf = new PrintableCuf();
        printableCuf.setLabel(this.evaluateExpressionToString(cuf.getLabel()));
        printableCuf.setType(this.evaluateExpressionToString(cuf.getType()));
        printableCuf.setRichText(printableCuf.isRichText());
        printableCuf.setEntityId(this.evaluateExpressionToLong(cuf.getEntityId()));
        printableCuf.setPosition(this.evaluateExpressionToLong(cuf.getPosition()));
        if (printableCuf.isRichText()) {
            printableCuf.setRichTextValue(this.richTextReplace(cuf.getValue(), html));
        } else {
            printableCuf.setValue(cuf.getValue());
        }
        resultList.add(printableCuf);
    }

    public String richTextReplace(String richText, List<String> html) {
        if (richText == null) {
            return TAG_EMPTY;
        }
        if (richText.contains("img")) {
            richText = this.findAndReplaceImageHeightWidthValue(richText);
        }
        if (richText.contains("/attachments/download/")) {
            Pattern pattern = Pattern.compile("<img.*?src=([\"'])?(?<src>(?:(?!\\2)[^\"'])+attachments\\/download\\/(?<id>\\d+)([^\"'])?).*?>");
            Matcher matcher = pattern.matcher(richText);
            while (matcher.find()) {
                String src = matcher.group("src");
                String id = matcher.group("id");
                String str = this.attachmentImageHelper.getImageBase64String(Long.valueOf(Long.parseLong(id)));
                if (str.isBlank()) continue;
                richText = richText.replace(src, "data:image/png;base64," + str);
            }
        }
        StringBuilder sb = new StringBuilder(richText);
        sb.insert(0, "<html><meta charset='UTF-8'>");
        sb.append("</html>");
        String newVal = "<w:altChunk r:id='reportRichText" + html.size() + "'/>";
        html.add(sb.toString());
        return newVal;
    }

    void toTagCuf(List<Cuf> tagCufData) {
        tagCufData.forEach(tcd -> {
            String tagValue = tcd.getValue();
            if (!Objects.isNull(tagValue)) {
                String chain = tagValue.replace(SEPARATOR_PLACEHOLDER, TAG_SEPARATOR);
                tcd.setValue(chain.substring(0, chain.length() - END_SEPARATOR_PLACEHOLDER.length()));
            } else {
                tcd.setValue(TAG_EMPTY);
            }
        });
    }

    void toTestCase(List<TestCase> testCases, boolean printLinkedReq, boolean printParameters, boolean printFolder, boolean printSteps, boolean printMilestones) {
        testCases.forEach(testCase -> {
            testCase.setPrintLinkedReq(printLinkedReq);
            testCase.setPrintParameters(printParameters);
            testCase.setPrintFolder(printFolder);
            testCase.setPrintSteps(printSteps);
            testCase.setPrintMilestones(printMilestones);
        });
    }

    boolean rawMilestoneConfigToBoolean(String rawConfigurationData) {
        if (Objects.isNull(rawConfigurationData)) {
            return false;
        }
        return "true".equalsIgnoreCase(rawConfigurationData);
    }

    void toCallStep(List<TestCaseStep> testCaseSteps, Long idTestCase, boolean printAttachments, boolean printLinkedReq, boolean printCufs) {
        testCaseSteps.forEach(testCaseStep -> {
            testCaseStep.setTestCaseId(this.evaluateExpressionToLong(idTestCase));
            testCaseStep.setPrintAttachments(printAttachments);
            testCaseStep.setPrintCufs(printCufs);
            testCaseStep.setPrintStepLinkedReq(printLinkedReq);
        });
    }

    public void bindCufToTestCase(List<TestCase> testCases, List<Cuf> cufs) {
        for (TestCase testCase : testCases) {
            List<Cuf> groupedCufs = this.groupCufs(cufs, testCase.getId());
            testCase.setCufs(groupedCufs);
        }
    }

    public void bindNumCufToTestCase(Collection<TestCase> testCases, Collection<Cuf> cufs) {
        for (TestCase TestCase2 : testCases) {
            List<Cuf> groupedCufs = this.groupCufs(cufs, TestCase2.getId());
            TestCase2.setNumCufs(groupedCufs);
        }
    }

    public void bindTagCufTestCase(Collection<TestCase> testCases, Collection<Cuf> cufs) {
        for (TestCase TestCase2 : testCases) {
            List<Cuf> groupedCufs = this.groupCufs(cufs, TestCase2.getId());
            TestCase2.setTagCufs(groupedCufs);
        }
    }

    public void bindRtfCufToTestCase(Collection<TestCase> testCases, Collection<Cuf> cufs) {
        for (TestCase TestCase2 : testCases) {
            List<Cuf> groupedCufs = this.groupCufs(cufs, TestCase2.getId());
            TestCase2.setRtfCufs(groupedCufs);
        }
    }

    private List<Cuf> groupCufs(Collection<Cuf> cufData, Long id) {
        ArrayList<Cuf> cufs = new ArrayList();
        for (Cuf cuf : cufData) {
            if (!this.acceptAsCuf(cuf, id)) continue;
            cufs.add(cuf);
        }
        cufs = cufs.stream().sorted(Comparator.comparing(Cuf::getPosition)).toList();
        return cufs;
    }

    public boolean acceptAsCuf(Cuf cuf, Long id) {
        return cuf.getEntityId().equals(id);
    }

    public void bindCufToStep(Collection<TestCaseStep> testCaseSteps, Collection<Cuf> cufList) {
        for (TestCaseStep testCaseStep : testCaseSteps) {
            List<Cuf> cufs = this.groupCufs(cufList, testCaseStep.getId());
            testCaseStep.setCufs(cufs);
        }
    }

    public void bindNumCufToStep(Collection<TestCaseStep> testCaseSteps, Collection<Cuf> cufList) {
        for (TestCaseStep testCaseStep : testCaseSteps) {
            List<Cuf> cufs = this.groupCufs(cufList, testCaseStep.getId());
            testCaseStep.setNumCufs(cufs);
        }
    }

    public void bindTagCufToStep(Collection<TestCaseStep> testCaseSteps, Collection<Cuf> cufList) {
        for (TestCaseStep testCaseStep : testCaseSteps) {
            List<Cuf> cufs = this.groupCufs(cufList, testCaseStep.getId());
            testCaseStep.setTagCufs(cufs);
        }
    }

    public void bindRtfCufToStep(Collection<TestCaseStep> testCaseSteps, Collection<Cuf> cufList) {
        for (TestCaseStep testCaseStep : testCaseSteps) {
            List<Cuf> cufs = this.groupCufs(cufList, testCaseStep.getId());
            testCaseStep.setRtfCufs(cufs);
        }
    }

    public void bindStep(List<TestCase> testCases, PrintStepData printStepData) {
        List<TestCaseStep> testCaseSteps = printStepData.getTestCaseSteps();
        List<LinkedRequirements> linkedRequirementsBySteps = printStepData.getLinkedRequirementsBySteps();
        List<PrintableCuf> printCufMap = printStepData.getPrintableStepCufs();
        if (!testCaseSteps.isEmpty()) {
            this.bindPrintCufToStep(testCaseSteps, printCufMap);
            this.bindLinkedReqToTestStep(testCaseSteps, linkedRequirementsBySteps);
            this.bindTestStepToTestCase(testCases, testCaseSteps);
            this.updateStepOrder(testCases);
        }
    }

    public void bindAll(List<LinkedRequirements> linkedRequirements, List<TestCase> testCases, ParameterData parameterData, List<Node> nodes, List<PrintableCuf> printTestCaseCufMap) {
        List<Parameter> parameters = parameterData.parameters();
        List<Dataset> datasets = parameterData.datasets();
        List<DatasetParamValue> datasetParamValues = parameterData.datasetParamValuesData();
        this.tcIdsAlreadyAdd = new ArrayList<Long>();
        this.hierarchyHelper = new TestCaseHierarchyHelper();
        this.bindParamValuesToDataset(datasets, datasetParamValues);
        this.bindDatasetToTestCase(datasets, testCases);
        this.bindParameterForTestCase(testCases, parameters);
        this.bindPrintCufToTestCase(testCases, printTestCaseCufMap);
        if (!linkedRequirements.isEmpty()) {
            this.bindLinkedReqToTc(testCases, linkedRequirements);
        }
        this.bindTestCaseToNode(testCases, nodes);
    }

    private void updateStepOrder(List<TestCase> testCases) {
        for (TestCase testCase : testCases) {
            Long order = 0L;
            for (TestCaseStep testCaseStep : testCase.getTcSteps()) {
                testCaseStep.setOrder(order);
                order = order + 1L;
            }
        }
    }

    private void bindTestCaseToNode(List<TestCase> testCases, List<Node> nodes) {
        Optional firstNode = nodes.stream().findFirst();
        firstNode.ifPresent(node -> {
            String string = this.projectName = node.getProjectName();
        });
        for (Node node2 : nodes) {
            List<TestCase> testCases1 = this.groupTestCaseForNode(testCases, node2);
            node2.setTestCases(testCases1);
        }
    }

    public void cleanStepsForPdf(PrintStepData printStepData) {
        ArrayList<TestCaseStep> testCaseSteps = new ArrayList<TestCaseStep>();
        printStepData.getTestCaseSteps().forEach(testCaseStep -> {
            if (!KEYWORD.equals(testCaseStep.getType())) {
                testCaseSteps.add((TestCaseStep)testCaseStep);
            }
        });
        printStepData.setTestCaseSteps(testCaseSteps);
    }

    private void bindTestStepToTestCase(List<TestCase> testCases, List<TestCaseStep> testCaseSteps) {
        for (TestCase testCase : testCases) {
            List<TestCaseStep> testCaseStepList = this.groupTestStepForTestCase(testCaseSteps, testCase);
            testCase.setTcSteps(testCaseStepList);
        }
    }

    private void bindLinkedReqToTc(List<TestCase> testCases, List<LinkedRequirements> linkedRequirements) {
        for (TestCase testCase : testCases) {
            List<LinkedRequirements> linkedRequirementsList = this.groupLinkedRequirementForTestCase(linkedRequirements, testCase);
            testCase.setLinkedRequirements(linkedRequirementsList);
        }
    }

    private void bindLinkedReqToTestStep(List<TestCaseStep> testCaseSteps, List<LinkedRequirements> linkedRequirements) {
        for (TestCaseStep caseSteps : testCaseSteps) {
            List<LinkedRequirements> linkedRequirementsList = this.groupLinkedRequirementForTestStep(linkedRequirements, caseSteps);
            caseSteps.setLinkedRequirements(linkedRequirementsList);
        }
    }

    private void bindPrintCufToStep(List<TestCaseStep> testCaseSteps, List<PrintableCuf> printableCufCollection) {
        for (TestCaseStep testCaseStep : testCaseSteps) {
            List<PrintableCuf> testStepPrintCufs = this.groupPrintableCufsForTestSteps(printableCufCollection, testCaseStep);
            testCaseStep.setPrintableCufs(testStepPrintCufs);
        }
    }

    private void bindPrintCufToTestCase(List<TestCase> testCases, List<PrintableCuf> printableTestCaseCufCollection) {
        for (TestCase testCase : testCases) {
            List<PrintableCuf> testCasePrintCufs = this.groupPrintableCufsForTestCases(printableTestCaseCufCollection, testCase);
            testCase.setPrintableCufs(testCasePrintCufs);
        }
    }

    private void bindParameterForTestCase(List<TestCase> testCases, List<Parameter> parameters) {
        for (TestCase testCase : testCases) {
            List<Parameter> params = this.groupParameterForTestCase(parameters, testCase);
            testCase.setParameters(params);
        }
    }

    private void bindParamValuesToDataset(List<Dataset> datasets, List<DatasetParamValue> datasetParamValues) {
        for (Dataset dataset : datasets) {
            List<DatasetParamValue> paramValues = this.groupParamValueToDataset(datasetParamValues, dataset);
            dataset.setDatasetParamValues(paramValues);
        }
    }

    private void bindDatasetToTestCase(List<Dataset> datasets, List<TestCase> testCases) {
        for (TestCase testCase : testCases) {
            List<Dataset> datasetList = this.groupDatasetToTestCase(datasets, testCase);
            testCase.setDatasets(datasetList);
        }
    }

    public List<PrintableCuf> groupPrintableCufsForTestCases(List<PrintableCuf> printCufs, TestCase testCase) {
        ArrayList<PrintableCuf> cufs = new ArrayList();
        for (PrintableCuf cuf : printCufs) {
            if (!testCase.acceptAsPrintCuf(cuf)) continue;
            cufs.add(cuf);
        }
        cufs = cufs.stream().sorted(Comparator.comparing(PrintableCuf::getPosition)).toList();
        return cufs;
    }

    public List<TestCase> groupTestCaseForNode(List<TestCase> testCases, Node node) {
        Iterator<TestCase> iterator = testCases.iterator();
        ArrayList<TestCase> tc = new ArrayList<TestCase>();
        HashSet<Long> tcIds = new HashSet<Long>();
        while (iterator.hasNext()) {
            TestCase next = iterator.next();
            if (!next.getNodeIds().contains(node.getItemId())) continue;
            tcIds.addAll(next.getNodeIds());
        }
        for (TestCase testCase : testCases) {
            if (!tcIds.contains(testCase.getId()) || this.tcIdsAlreadyAdd.contains(testCase.getId())) continue;
            if (!this.projectName.equals(node.getProjectName())) {
                this.hierarchyHelper = new TestCaseHierarchyHelper();
                this.projectName = node.getProjectName();
            }
            testCase.setParagraph(this.hierarchyHelper.getNextParagraphLevel(testCase.getLevel().intValue()));
            tc.add(testCase);
            this.tcIdsAlreadyAdd.add(testCase.getId());
        }
        return tc;
    }

    public List<TestCaseStep> groupTestStepForTestCase(List<TestCaseStep> testCaseSteps, TestCase testCase) {
        Iterator<TestCaseStep> iterator = testCaseSteps.iterator();
        ArrayList<TestCaseStep> tc = new ArrayList<TestCaseStep>();
        while (iterator.hasNext()) {
            TestCaseStep next = iterator.next();
            if (!testCase.getId().equals(next.getTestCaseId())) continue;
            tc.add(next);
            iterator.remove();
        }
        return tc;
    }

    public List<Parameter> groupParameterForTestCase(List<Parameter> parameters, TestCase testCase) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Parameter param : parameters) {
            if (!testCase.getId().equals(param.getTestCaseId())) continue;
            params.add(param);
        }
        return params;
    }

    public List<LinkedRequirements> groupLinkedRequirementForTestCase(List<LinkedRequirements> linkedRequirements, TestCase testCase) {
        Iterator<LinkedRequirements> iterator = linkedRequirements.iterator();
        ArrayList<LinkedRequirements> linkedRequirementsArrayList = new ArrayList<LinkedRequirements>();
        while (iterator.hasNext()) {
            LinkedRequirements next = iterator.next();
            if (!testCase.getId().equals(next.getTestCaseId())) continue;
            linkedRequirementsArrayList.add(next);
            iterator.remove();
        }
        return linkedRequirementsArrayList;
    }

    public List<LinkedRequirements> groupLinkedRequirementForTestStep(List<LinkedRequirements> linkedRequirements, TestCaseStep testCaseStep) {
        ArrayList<LinkedRequirements> linkedRequirementsArrayList = new ArrayList<LinkedRequirements>();
        for (LinkedRequirements linkedRequirement : linkedRequirements) {
            if (!testCaseStep.getId().equals(linkedRequirement.getTestCaseId())) continue;
            linkedRequirementsArrayList.add(linkedRequirement);
        }
        return linkedRequirementsArrayList;
    }

    public List<PrintableCuf> groupPrintableCufsForTestSteps(List<PrintableCuf> printCufs, TestCaseStep testCaseStep) {
        return printCufs.stream().filter(testCaseStep::acceptAsPrintCuf).sorted(Comparator.comparing(PrintableCuf::getLabel, String::compareToIgnoreCase)).toList();
    }

    private List<DatasetParamValue> groupParamValueToDataset(List<DatasetParamValue> datasetParamValues, Dataset dataset) {
        ArrayList<DatasetParamValue> result = new ArrayList<DatasetParamValue>();
        for (DatasetParamValue datasetParamValue : datasetParamValues) {
            if (!dataset.getId().equals(datasetParamValue.getDatasetId())) continue;
            result.add(datasetParamValue);
        }
        return result;
    }

    private List<Dataset> groupDatasetToTestCase(List<Dataset> datasets, TestCase testCase) {
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        for (Dataset dataset : datasets) {
            if (!dataset.getTestCaseId().equals(testCase.getId())) continue;
            result.add(dataset);
        }
        return result;
    }

    private String evaluateExpressionToString(Object obj) {
        if (obj instanceof Date) {
            return this.convertDateTimeToString((Date)obj);
        }
        if (this.isStringDate(obj)) {
            return this.formatSimpleDateString(obj.toString());
        }
        return obj != null ? obj.toString() : " ";
    }

    private boolean isStringDate(Object obj) {
        return obj instanceof String && obj.toString().matches(DATE_REGEX);
    }

    private Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    private String convertDateTimeToString(Date date) {
        return DateFormat.getDateTimeInstance(3, 3, this.currentLocale()).format(date);
    }

    private String formatSimpleDateString(String stringDate) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", this.currentLocale());
            Date date = formatter.parse(stringDate);
            return DateFormat.getDateInstance(3, this.currentLocale()).format(date);
        }
        catch (ParseException parseException) {
            LOGGER.warn("An error occurred when parsing the date string {} . The date will not be converted to local format.", (Object)stringDate);
            return stringDate;
        }
    }

    protected Long evaluateExpressionToLong(Object obj) {
        return Long.valueOf(obj.toString());
    }

    private String findAndReplaceImageHeightWidthValue(String string) {
        String regexPattern = "(?<=\")([0-9]+)(?=\")";
        Pattern pattern = Pattern.compile(regexPattern);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String stringAttribute = matcher.group();
            int intAttribute = Integer.parseInt(stringAttribute);
            intAttribute = Math.min(intAttribute, 700);
            string = string.replace(stringAttribute, Integer.toString(intAttribute));
        }
        return string;
    }
}

