/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record9;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.AttachmentEntity;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.CustomFieldValuePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.SprintReqVersionPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.executionworkspace.TestPlanItemPivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.ExecutionWorkspaceConverterService;
import org.squashtest.tm.service.pivot.projectexporter.SprintPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.CustomFieldPivotDao;
import org.squashtest.tm.service.pivot.projectexporter.dao.TestCasePivotDao;

@Repository
public class SprintPivotDaoImpl
extends AbstractPivotDao<SprintPivot>
implements SprintPivotDao {
    private final CustomFieldPivotDao customFieldPivotDao;
    private final ExecutionWorkspaceConverterService executionWorkspaceConverterService;

    public SprintPivotDaoImpl(AdminPivotConverterService adminPivotConverterService, DSLContext dsl, CustomFieldPivotDao customFieldPivotDao, ExecutionWorkspaceConverterService executionWorkspaceConverterService) {
        super(dsl, adminPivotConverterService);
        this.customFieldPivotDao = customFieldPivotDao;
        this.executionWorkspaceConverterService = executionWorkspaceConverterService;
    }

    @Override
    public boolean hasSprintByProjectId(Long projectId) {
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)));
    }

    private ResultQuery<? extends Record> getCustomFieldValueByProjectIdQuery(Long projectId) {
        Table<Record9<Long, Long, Long, String, String, String, String, String, String>> customFieldValuesTable = this.customFieldPivotDao.getCustomFieldValuesTableByProjectIdAndBindableEntity(projectId, BindableEntity.SPRINT);
        return this.dsl.select((SelectField)Tables.SPRINT.CLN_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID, CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_TYPE, CustomFieldPivotDao.CFV_TABLE_CF_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join(customFieldValuesTable).on(Tables.SPRINT.CLN_ID.eq(CustomFieldPivotDao.CFV_TABLE_BOUND_ENTITY_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.SPRINT.CLN_ID).fetchSize(50);
    }

    private ResultQuery<? extends Record> getAttachmentByProjectIdQuery(Long projectId) {
        SelectConditionStep sprintQuery = this.dsl.select((SelectField)Tables.SPRINT.CLN_ID, (SelectField)Tables.SPRINT.CLN_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.SPRINT.toString()).as(TestCasePivotDao.ATTACHMENT_HOLDER_TYPE), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep sessionOverviewQuery = this.dsl.select((SelectField)Tables.SPRINT.CLN_ID, (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.as(TestCasePivotDao.ATTACHMENT_HOLDER_ID), (SelectField)DSL.val((String)AttachmentEntity.EXPLORATORY_SESSION_OVERVIEW.toString()), (SelectField)Tables.ATTACHMENT.ATTACHMENT_LIST_ID, (SelectField)Tables.ATTACHMENT.ATTACHMENT_ID, (SelectField)Tables.ATTACHMENT.NAME, (SelectField)Tables.ATTACHMENT.TYPE, (SelectField)Tables.ATTACHMENT.ADDED_ON, (SelectField)Tables.ATTACHMENT.LAST_MODIFIED_ON, (SelectField)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (SelectField)Tables.ATTACHMENT_CONTENT.STREAM_CONTENT).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID)).join((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).join((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.ATTACHMENT_LIST_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ATTACHMENT_LIST_ID)).join((TableLike)Tables.ATTACHMENT_CONTENT).on(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID.eq((Field)Tables.ATTACHMENT.CONTENT_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        return sprintQuery.unionAll((Select)sessionOverviewQuery).orderBy((OrderField)Tables.SPRINT.CLN_ID).fetchSize(50);
    }

    @Override
    public void getSprintByProjectId(Long projectId, Consumer<SprintPivot> writingToJsonConsumer, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        ResultQuery resultQuery = this.dsl.select(new SelectFieldOrAsterisk[]{Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.CAMPAIGN_LIBRARY_NODE.NAME, Tables.CAMPAIGN_LIBRARY_NODE.DESCRIPTION, Tables.CAMPAIGN_LIBRARY_NODE.CREATED_BY, Tables.CAMPAIGN_LIBRARY_NODE.CREATED_ON, Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_BY, Tables.CAMPAIGN_LIBRARY_NODE.LAST_MODIFIED_ON, Tables.SPRINT.REFERENCE, Tables.SPRINT.START_DATE, Tables.SPRINT.END_DATE, Tables.SPRINT.STATUS, DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Object)EntityType.CAMPAIGN_FOLDER.name()).when(Tables.SPRINT_GROUP.CLN_ID.isNotNull(), (Object)EntityType.SPRINT_GROUP.name()).otherwise((Object)EntityType.CAMPAIGN_LIBRARY.name()).as(SprintPivotDao.PARENT_TYPE_FIELD), Tables.CLN_RELATIONSHIP.ANCESTOR_ID, Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID, Tables.SPRINT_REQ_VERSION.REFERENCE, Tables.SPRINT_REQ_VERSION.NAME, Tables.SPRINT_REQ_VERSION.DESCRIPTION, Tables.SPRINT_REQ_VERSION.STATUS, Tables.SPRINT_REQ_VERSION.CRITICALITY, Tables.SPRINT_REQ_VERSION.CATEGORY, Tables.SPRINT_REQ_VERSION.MODE, Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS, Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID, Tables.SPRINT_REQ_VERSION.CREATED_BY, Tables.SPRINT_REQ_VERSION.CREATED_ON, Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_BY, Tables.SPRINT_REQ_VERSION.LAST_MODIFIED_ON, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.LABEL, Tables.TEST_PLAN_ITEM.DATASET_ID, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.TEST_PLAN_ITEM.CREATED_BY, Tables.TEST_PLAN_ITEM.CREATED_ON, Tables.TEST_PLAN_ITEM.LAST_MODIFIED_BY, Tables.TEST_PLAN_ITEM.LAST_MODIFIED_ON, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_BY, Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.EXPLORATORY_SESSION_OVERVIEW.NAME, Tables.EXPLORATORY_SESSION_OVERVIEW.REFERENCE, Tables.EXPLORATORY_SESSION_OVERVIEW.CHARTER, Tables.EXPLORATORY_SESSION_OVERVIEW.COMMENTS, Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_STATUS, Tables.EXPLORATORY_SESSION_OVERVIEW.SESSION_DURATION, Tables.EXPLORATORY_SESSION_OVERVIEW.DUE_DATE}).from((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).join((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Field)Tables.TEST_PLAN_ITEM.OVERVIEW_ID)).leftJoin((TableLike)Tables.CLN_RELATIONSHIP).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.DESCENDANT_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).leftJoin((TableLike)Tables.SPRINT_GROUP).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP.ANCESTOR_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId)).orderBy((OrderField)Tables.SPRINT.CLN_ID, (OrderField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID, (OrderField)Tables.TEST_PLAN_ITEM.ITEM_ORDER).fetchSize(50);
        this.convertRecordAndWritingPivot(resultQuery, projectId, EntityBindingField.SPRINT, writingToJsonConsumer, writingAttachmentConsumer);
    }

    @Override
    protected SprintPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        SprintPivot sprintPivot = this.executionWorkspaceConverterService.sprintRecordToSprintPivot(record);
        if (Objects.nonNull(record.get((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID))) {
            SprintReqVersionPivot sprintReqVersionPivot = this.getNewSprintReqVersionPivot(record);
            sprintPivot.addSprintReqVersion(sprintReqVersionPivot);
        }
        return sprintPivot;
    }

    private SprintReqVersionPivot getNewSprintReqVersionPivot(Record record) {
        SprintReqVersionPivot sprintReqVersionPivot = this.executionWorkspaceConverterService.sprintRecordToSprintReqVersionPivot(record);
        this.appendTestPlanItemPivot(record, sprintReqVersionPivot);
        return sprintReqVersionPivot;
    }

    @Override
    protected void fillPivotObject(SprintPivot pivotObject, Record record) {
        if (Objects.isNull(record.get((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID))) {
            return;
        }
        SprintReqVersionPivot sprintReqVersionPivot = pivotObject.getSprintReqVersions().getLast();
        if (sprintReqVersionPivot.pivotIdToSquashId().equals(record.get((Field)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID))) {
            this.appendTestPlanItemPivot(record, sprintReqVersionPivot);
        } else {
            sprintReqVersionPivot = this.getNewSprintReqVersionPivot(record);
            pivotObject.addSprintReqVersion(sprintReqVersionPivot);
        }
    }

    private void appendTestPlanItemPivot(Record record, SprintReqVersionPivot sprintReqVersionPivot) {
        if (record.get((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID) != null) {
            sprintReqVersionPivot.addTestPlanItem(this.executionWorkspaceConverterService.tpiRecordToTpiPivot(record));
        }
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of(this.getCufPivotContainer(projectId), this.getAttachmentPivotContainer(this.getAttachmentByProjectIdQuery(projectId), (Field<Long>)Tables.SPRINT.CLN_ID, (Record record) -> this.adminPivotConverterService.recordToAttachmentPivot((Record)record, TestCasePivotDao.ATTACHMENT_HOLDER_ID, TestCasePivotDao.ATTACHMENT_HOLDER_TYPE)));
    }

    private SubElementRecordProcessor<CustomFieldValuePivot> getCufPivotContainer(Long projectId) {
        return new SubElementRecordProcessor<CustomFieldValuePivot>(this.getCustomFieldValueByProjectIdQuery(projectId), (Field<Long>)Tables.SPRINT.CLN_ID, CustomFieldPivotDao.CFV_TABLE_CF_VALUE_ID, this.customFieldPivotDao::cufValueRecordToCufValuePivot, CustomFieldValuePivot.class);
    }

    @Override
    protected void appendSubElementsToPivotObject(SprintPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        pivotObject.addAllCustomFields(this.getSubElement(CustomFieldValuePivot.class, subElementsByClazz));
        this.addAndWriteAttachmentPivot(this.getSubElement(AttachmentPivot.class, subElementsByClazz), pivotObject, writingAttachmentConsumer);
    }

    private void addAndWriteAttachmentPivot(List<AttachmentPivot> attachmentPivots, SprintPivot sprintPivot, Consumer<AttachmentPivot> writingAttachmentConsumer) {
        Map sessionOverviewPivotById = sprintPivot.getSprintReqVersions().stream().flatMap(sprintReqVersion -> sprintReqVersion.getTestPlanItems().stream()).map(TestPlanItemPivot::getSessionOverview).filter(Objects::nonNull).collect(Collectors.toMap(AbstractPivotObject::pivotIdToSquashId, Function.identity()));
        this.addAndWriteAttachmentPivot(attachmentPivots, sprintPivot, AttachmentEntity.SPRINT, Map.of(AttachmentEntity.EXPLORATORY_SESSION_OVERVIEW, sessionOverviewPivotById), writingAttachmentConsumer);
    }
}

