/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter.dao;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AttachmentPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.InfoListPivot;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.AbstractPivotDao;
import org.squashtest.tm.service.internal.pivot.projectexporter.dao.EntityBindingField;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.InfoListPivotDao;

@Repository
public class InfoListPivotDaoImpl
extends AbstractPivotDao<InfoListPivot>
implements InfoListPivotDao {
    public InfoListPivotDaoImpl(DSLContext dsl, AdminPivotConverterService adminPivotConverterService) {
        super(dsl, adminPivotConverterService);
    }

    @Override
    public boolean hasCustomInfoListBindingByProjectId(Long projectId) {
        List<String> systemCodes = Arrays.stream(SystemInfoListCode.values()).map(SystemInfoListCode::getCode).toList();
        return this.dsl.fetchExists((Select)this.dsl.selectOne().from((TableLike)Tables.INFO_LIST).join((TableLike)Tables.PROJECT).on(Tables.INFO_LIST.INFO_LIST_ID.in(new Field[]{Tables.PROJECT.REQ_CATEGORIES_LIST, Tables.PROJECT.TC_NATURES_LIST, Tables.PROJECT.TC_TYPES_LIST})).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.INFO_LIST.CODE.notIn(systemCodes)));
    }

    private ResultQuery<? extends Record> getInfoListQueryByProjectId(Long projectId) {
        List<String> systemCodes = Arrays.stream(SystemInfoListCode.values()).map(SystemInfoListCode::getCode).toList();
        return this.dsl.select((SelectField)Tables.INFO_LIST.INFO_LIST_ID, (SelectField)Tables.INFO_LIST.LABEL, (SelectField)Tables.INFO_LIST.DESCRIPTION, (SelectField)Tables.INFO_LIST.CODE, (SelectField)Tables.INFO_LIST.CREATED_BY, (SelectField)Tables.INFO_LIST.CREATED_ON, (SelectField)Tables.INFO_LIST.LAST_MODIFIED_BY, (SelectField)Tables.INFO_LIST.LAST_MODIFIED_ON, (SelectField)Tables.INFO_LIST_ITEM.ITEM_ID, (SelectField)Tables.INFO_LIST_ITEM.LABEL, (SelectField)Tables.INFO_LIST_ITEM.CODE, (SelectField)Tables.INFO_LIST_ITEM.COLOUR, (SelectField)Tables.INFO_LIST_ITEM.ICON_NAME, (SelectField)Tables.INFO_LIST_ITEM.IS_DEFAULT, (SelectField)Tables.INFO_LIST_ITEM.ITEM_INDEX).from((TableLike)Tables.INFO_LIST).join((TableLike)Tables.INFO_LIST_ITEM).on(Tables.INFO_LIST_ITEM.LIST_ID.eq((Field)Tables.INFO_LIST.INFO_LIST_ID)).join((TableLike)Tables.PROJECT).on(Tables.INFO_LIST.INFO_LIST_ID.in(new Field[]{Tables.PROJECT.REQ_CATEGORIES_LIST, Tables.PROJECT.TC_NATURES_LIST, Tables.PROJECT.TC_TYPES_LIST})).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).and(Tables.INFO_LIST.CODE.notIn(systemCodes)).orderBy((OrderField)Tables.INFO_LIST.INFO_LIST_ID, (OrderField)Tables.INFO_LIST_ITEM.ITEM_INDEX);
    }

    @Override
    public void getCustomInfoListByProjectId(Long projectId, Consumer<InfoListPivot> consumer) {
        ResultQuery<? extends Record> infoListQuery = this.getInfoListQueryByProjectId(projectId);
        this.convertRecordAndWritingPivot(infoListQuery, projectId, EntityBindingField.INFO_LIST, consumer, attachmentPivot -> {});
    }

    @Override
    protected InfoListPivot getNewPivotObject(Record record, Long projectId, EntityBindingField entityBindingField) {
        InfoListPivot infoListPivot = this.adminPivotConverterService.recordToInfoListPivot(record);
        this.addInfoListItemToInfoListPivot(infoListPivot, record);
        return infoListPivot;
    }

    private void addInfoListItemToInfoListPivot(InfoListPivot infoListPivot, Record record) {
        if (record.get((Field)Tables.INFO_LIST_ITEM.ITEM_ID) == null) {
            return;
        }
        infoListPivot.addInfoListItem(this.adminPivotConverterService.recordToInfoListItemPivot(record));
    }

    @Override
    protected void fillPivotObject(InfoListPivot pivotObject, Record record) {
        this.addInfoListItemToInfoListPivot(pivotObject, record);
    }

    @Override
    protected List<SubElementRecordProcessor<? extends AbstractPivotObject>> getSubElementRecordProcessors(Long projectId, EntityBindingField entityBindingField) {
        return List.of();
    }

    @Override
    protected void appendSubElementsToPivotObject(InfoListPivot pivotObject, Map<Class<? extends AbstractPivotObject>, List<? extends AbstractPivotObject>> subElementsByClazz, Consumer<AttachmentPivot> writingAttachmentConsumer) {
    }
}

