/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectexporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.pivot.PivotFileManager;
import org.squashtest.tm.service.pivot.projectexporter.MilestonePivotExporterService;
import org.squashtest.tm.service.pivot.projectexporter.dao.MilestonePivotDao;

@Service
public class MilestonePivotExporterServiceImpl
implements MilestonePivotExporterService {
    private final MilestonePivotDao milestonePivotDao;
    private final PivotFileManager pivotFileManager;

    public MilestonePivotExporterServiceImpl(MilestonePivotDao milestonePivotDao, PivotFileManager pivotFileManager) {
        this.milestonePivotDao = milestonePivotDao;
        this.pivotFileManager = pivotFileManager;
    }

    @Override
    public void generateMilestoneJsonFile(JsonFactory jsonFactory, ArchiveOutputStream<ZipArchiveEntry> archive, File tmpAttachmentDir, Long projectId) throws IOException {
        if (!this.milestonePivotDao.hasMilestoneBindingByProjectId(projectId)) {
            return;
        }
        this.pivotFileManager.writePivotObjectToZip(jsonFactory, jsonGenerator -> this.handleMilestone((JsonGenerator)jsonGenerator, projectId), JsonImportFile.MILESTONES, archive);
    }

    private void handleMilestone(JsonGenerator jsonGenerator, Long projectId) {
        this.milestonePivotDao.getMilestoneByProjectId(projectId, milestonePivot -> this.pivotFileManager.writePivotObject(milestonePivot, jsonGenerator, JsonImportFile.MILESTONES));
    }
}

