/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.orchestrator;

import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testautomation.AutomatedSuiteWorkflow;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.internal.dto.WorkflowLogsDTO;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.orchestrator.OrchestratorOperationService;
import org.squashtest.tm.service.orchestrator.OrchestratorWorkflowsService;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.servers.CredentialsProvider;

@Service
public class OrchestratorWorkflowsServiceImpl
implements OrchestratorWorkflowsService {
    private final AutomatedSuiteDao automatedSuiteDao;
    private final GenericProjectDao genericProjectDao;
    private final OrchestratorOperationService orchestratorOperationService;
    private final CredentialsProvider credentialsProvider;

    public OrchestratorWorkflowsServiceImpl(AutomatedSuiteDao automatedSuiteDao, GenericProjectDao genericProjectDao, OrchestratorOperationService orchestratorOperationService, CredentialsProvider credentialsProvider) {
        this.automatedSuiteDao = automatedSuiteDao;
        this.genericProjectDao = genericProjectDao;
        this.orchestratorOperationService = orchestratorOperationService;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public WorkflowLogsDTO getWorkflowLogs(String workflowId, Long projectId) {
        TestAutomationServer orchestratorServer = this.genericProjectDao.findTestAutomationServer(projectId);
        TokenAuthCredentials credentials = this.credentialsProvider.getProjectLevelCredentials(orchestratorServer.getId(), projectId).orElse(null);
        OrchestratorResponse response = this.orchestratorOperationService.performOrchestratorOperation(orchestratorServer.getId(), (connector, server) -> connector.getWorkflowLogs((TestAutomationServer)server, credentials, workflowId));
        AutomatedSuiteWorkflow automatedSuiteWorkflow = this.automatedSuiteDao.getAutomatedSuiteWorkflowByWorkflowId(workflowId);
        if (!response.isReachable()) {
            return WorkflowLogsDTO.withUnreachableOrchestrator();
        }
        if (automatedSuiteWorkflow == null) {
            return WorkflowLogsDTO.withWorkflowAlreadyDone((String)response.getResponse());
        }
        return WorkflowLogsDTO.withResponse((String)response.getResponse());
    }
}

