/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.squashtest.tm.service.internal.dto.testcase.Cuf;
import org.squashtest.tm.service.internal.dto.testcase.I18nHelper;
import org.squashtest.tm.service.internal.dto.testcase.LinkedRequirements;
import org.squashtest.tm.service.internal.dto.testcase.PrintableCuf;

public class TestCaseStep {
    private Long id;
    private String action;
    private String expectedResult;
    private String type;
    private Long order;
    private String dataset;
    private String prerequisites;
    private Long attach;
    private Long requirement;
    private List<LinkedRequirements> linkedRequirements = new ArrayList<LinkedRequirements>();
    private Long testCaseId;
    private boolean printAttachments;
    private boolean printCufs;
    private boolean printStepLinkedReq;
    private String keyword;
    private String bddAction;
    private String datatable;
    private String docstring;
    private String comment;
    private Locale bddScriptLanguage;
    private boolean delegateParameterValues;
    private boolean hasNoResult = false;
    private List<PrintableCuf> printableCufs;
    private List<Cuf> rtfCufs;
    private List<Cuf> cufs;
    private List<Cuf> tagCufs;
    private List<Cuf> numCufs;

    public String getAttach() {
        return String.valueOf(this.attach);
    }

    public void setAttach(Long attach) {
        this.attach = attach;
    }

    public String getRequirement() {
        if (this.requirement == 0L) {
            return I18nHelper.translate("label.None");
        }
        return String.valueOf(this.requirement);
    }

    public void setRequirement(Long requirement) {
        this.requirement = requirement;
    }

    public boolean acceptAsPrintCuf(PrintableCuf printCufBean) {
        return printCufBean.getEntityId().equals(this.id);
    }

    public boolean isNoDatatable() {
        return "".equals(this.datatable);
    }

    public boolean isNoDocstring() {
        return "".equals(this.docstring);
    }

    public boolean isNoComment() {
        return "".equals(this.comment);
    }

    public void setOrder(Long order) {
        this.order = order;
    }

    public Long getOrder() {
        return this.order + 1L;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getDataset() {
        if (Objects.isNull(this.dataset)) {
            return "";
        }
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public List<PrintableCuf> getPrintableCufs() {
        return this.printableCufs;
    }

    public void setPrintableCufs(List<PrintableCuf> printableCufs) {
        this.printableCufs = printableCufs;
    }

    public Long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public List<LinkedRequirements> getLinkedRequirements() {
        return this.linkedRequirements;
    }

    public void setLinkedRequirements(List<LinkedRequirements> linkedRequirements) {
        this.linkedRequirements = linkedRequirements;
    }

    public boolean isPrintAttachments() {
        return this.printAttachments;
    }

    public void setPrintAttachments(boolean printAttachments) {
        this.printAttachments = printAttachments;
    }

    public boolean isPrintCufs() {
        return this.printCufs;
    }

    public void setPrintCufs(boolean printCufs) {
        this.printCufs = printCufs;
    }

    public boolean isPrintStepLinkedReq() {
        return this.printStepLinkedReq;
    }

    public void setPrintStepLinkedReq(boolean printStepLinkedReq) {
        this.printStepLinkedReq = printStepLinkedReq;
    }

    public String getKeyword() {
        if (this.keyword == null || this.keyword.isBlank() || this.bddScriptLanguage == null) {
            return "";
        }
        return I18nHelper.translateTo("testcase.bdd.keyword.name." + this.keyword.toLowerCase(), this.bddScriptLanguage);
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getBddAction() {
        return this.bddAction;
    }

    public void setBddAction(String bddAction) {
        this.bddAction = bddAction;
    }

    public String getDatatable() {
        return this.datatable;
    }

    public void setDatatable(String datatable) {
        this.datatable = datatable;
    }

    public String getDocstring() {
        return this.docstring;
    }

    public void setDocstring(String docstring) {
        this.docstring = docstring;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Locale getBddScriptLanguage() {
        return this.bddScriptLanguage;
    }

    public void setBddScriptLanguage(String bddScriptLanguage) {
        this.bddScriptLanguage = I18nHelper.toLocale(bddScriptLanguage);
    }

    public void setDelegateParameterValues(boolean delegateParameterValues) {
        this.delegateParameterValues = delegateParameterValues;
    }

    public boolean isDelegateParameterValues() {
        return this.delegateParameterValues;
    }

    public void setHasNoResult(boolean hasNoResult) {
        this.hasNoResult = hasNoResult;
    }

    public boolean isHasNoResult() {
        return this.hasNoResult;
    }

    public void setCufs(List<Cuf> cufs) {
        this.cufs = cufs;
    }

    public void setRtfCufs(List<Cuf> cufs) {
        this.rtfCufs = cufs;
    }

    public List<Cuf> getCufs() {
        return this.cufs;
    }

    public List<Cuf> getRtfCufs() {
        if (!Objects.isNull(this.rtfCufs)) {
            ArrayList<Cuf> list = new ArrayList<Cuf>(this.rtfCufs);
            list.addAll(this.getTagCufs());
            return list;
        }
        return Collections.emptyList();
    }

    public List<Cuf> getNumCufs() {
        return this.numCufs;
    }

    public void setNumCufs(List<Cuf> numCufs) {
        this.numCufs = numCufs;
    }

    public void setTagCufs(List<Cuf> tagcufs) {
        this.tagCufs = tagcufs;
    }

    public List<Cuf> getTagCufs() {
        return this.tagCufs;
    }
}

