/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testcase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.internal.dto.testcase.Cuf;
import org.squashtest.tm.service.internal.dto.testcase.CufPair;
import org.squashtest.tm.service.internal.dto.testcase.Dataset;
import org.squashtest.tm.service.internal.dto.testcase.I18nHelper;
import org.squashtest.tm.service.internal.dto.testcase.LinkedRequirements;
import org.squashtest.tm.service.internal.dto.testcase.Parameter;
import org.squashtest.tm.service.internal.dto.testcase.PrintableCuf;
import org.squashtest.tm.service.internal.dto.testcase.TestCaseStep;

public class TestCase {
    private static final String END_SEPARATOR_PLACEHOLDER = "=Sep=";
    private static final String SORTING_CHAIN_SEPARATOR = " ";
    private static final String CHAIN_SEPARATOR = " > ";
    private static final String SEPARATOR_PLACEHOLDER = "=Sep=,";
    private static final String MILESTONE_SEPARATOR = ", ";
    public static final String SYS = "SYS";
    public static final String TEST_CASE_STATUS = "test-case.status.";
    public static final String TEST_CASE_AUTOMATABLE = "test-case.automatable.";
    public static final String TEST_CASE_IMPORTANCE = "test-case.importance.";
    public static final String AUTOMATION_REQUEST_REQUEST_STATUS = "automation-request.request_status.";
    private boolean printChain = true;
    private Long id;
    private String name;
    private String description;
    private String prerequisites;
    private Long level;
    private String createdBy;
    private String createdOn;
    private String lastModifiedBy;
    private String lastModifiedOn;
    private String paragraph;
    private String reference;
    private String importance;
    private String nature;
    private String type;
    private String natureType;
    private String typeType;
    private String status;
    private Long allowAutomationWorkflow;
    private String automatable;
    private String requestStatus;
    private String automationPriority;
    private Long executionMode;
    private Long folder;
    private String chain;
    private String chainDescription;
    private Long attachments;
    private String sortingChain;
    private String kind;
    private List<TestCaseStep> tcSteps = new ArrayList<TestCaseStep>();
    private List<CufPair> cufPairs = new ArrayList<CufPair>();
    private List<Cuf> rtfCufs = new ArrayList<Cuf>();
    private List<Cuf> numCufs = new ArrayList<Cuf>();
    private List<Cuf> tagCufs = new ArrayList<Cuf>();
    private List<PrintableCuf> printableCufs;
    private List<LinkedRequirements> linkedRequirements;
    private String milestoneNames;
    private String nodeIds;
    private String script;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Dataset> datasets = new ArrayList<Dataset>();
    private boolean printParameters;
    private boolean printSteps;
    private boolean printLinkedReq;
    private boolean printFolder;
    private boolean printMilestones;

    public boolean acceptAsPrintCuf(PrintableCuf printCufBean) {
        return printCufBean.getEntityId().equals(this.id);
    }

    public boolean isFolderType() {
        return this.folder == 1L;
    }

    public boolean isUnmodified() {
        return StringUtils.isBlank((CharSequence)this.lastModifiedOn);
    }

    public boolean isNoReference() {
        return StringUtils.isBlank((CharSequence)this.reference);
    }

    public boolean isPrintFolder() {
        return this.printFolder;
    }

    public void setPrintFolder(boolean printFolder) {
        this.printFolder = printFolder;
    }

    public boolean isHasNoMilestones() {
        return StringUtils.isBlank((CharSequence)this.milestoneNames);
    }

    public boolean isAtLibraryRoot() {
        return this.level == 0L;
    }

    public boolean isHasNoSteps() {
        return this.tcSteps.isEmpty();
    }

    public boolean isNoPrintChain() {
        return this.level == 0L || !this.printChain;
    }

    public boolean isStandard() {
        return TestCaseKind.STANDARD.name().equals(this.kind);
    }

    public boolean isScripted() {
        return TestCaseKind.GHERKIN.name().equals(this.kind);
    }

    public boolean isKeyword() {
        return TestCaseKind.KEYWORD.name().equals(this.kind);
    }

    public boolean isNoAllowAutomationWorkflow() {
        return this.allowAutomationWorkflow == 0L;
    }

    public boolean isNoEligible() {
        return !TestCaseAutomatable.Y.name().equals(this.automatable);
    }

    public boolean isPrintAttachment() {
        return this.attachments > 0L;
    }

    public boolean isHasTcSteps() {
        return !this.tcSteps.isEmpty();
    }

    public boolean isHasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean isHasDataset() {
        return !this.datasets.isEmpty();
    }

    public boolean isHasLinkedReq() {
        if (this.linkedRequirements == null) {
            return false;
        }
        return !this.linkedRequirements.isEmpty();
    }

    public boolean isScriptEmpty() {
        return Objects.isNull(this.script);
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(List<Integer> paragraphLevel) {
        if (paragraphLevel != null && !paragraphLevel.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<Integer> itr = paragraphLevel.iterator();
            sb.append(itr.next());
            while (itr.hasNext()) {
                sb.append('.').append(itr.next());
            }
            this.paragraph = sb.toString();
        } else {
            this.paragraph = "";
        }
    }

    public String getImportance() {
        return I18nHelper.translate(TEST_CASE_IMPORTANCE + (this.isValidTestCaseImportance() ? this.importance : TestCaseImportance.LOW.name()));
    }

    private boolean isValidTestCaseImportance() {
        return Objects.nonNull(this.importance) && Arrays.stream(TestCaseImportance.values()).anyMatch(it -> it.name().equals(this.importance));
    }

    public void setImportance(String importance) {
        this.importance = importance;
    }

    public String getNature() {
        if (SYS.equals(this.natureType)) {
            return I18nHelper.translate(this.nature);
        }
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getType() {
        if (SYS.equals(this.typeType)) {
            return I18nHelper.translate(this.type);
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return I18nHelper.translate(TEST_CASE_STATUS + (this.isValidTestCaseStatus() ? this.status : TestCaseImportance.LOW.name()));
    }

    private boolean isValidTestCaseStatus() {
        return Objects.nonNull(this.status) && Arrays.stream(TestCaseStatus.values()).anyMatch(it -> it.name().equals(this.status));
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAutomatable() {
        if (Objects.isNull(this.automatable)) {
            return "";
        }
        return I18nHelper.translate(TEST_CASE_AUTOMATABLE + (this.isPartOfTestCaseAutomatable() ? this.automatable : TestCaseAutomatable.M.name()));
    }

    private boolean isPartOfTestCaseAutomatable() {
        return Arrays.stream(TestCaseAutomatable.values()).anyMatch(it -> it.name().equals(this.automatable));
    }

    public void setAutomatable(String automatable) {
        this.automatable = automatable;
    }

    public String getRequestStatus() {
        return I18nHelper.translate(AUTOMATION_REQUEST_REQUEST_STATUS + (this.isValidAutomationRequestStatus() ? this.requestStatus : TestCaseStatus.WORK_IN_PROGRESS.name()));
    }

    private boolean isValidAutomationRequestStatus() {
        return Objects.nonNull(this.requestStatus) && Arrays.stream(AutomationRequestStatus.values()).anyMatch(it -> it.name().equals(this.requestStatus));
    }

    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    public String getChain() {
        return this.chain.replace(CHAIN_SEPARATOR + this.name, "");
    }

    public String getUnescapedChain() {
        return HtmlUtils.htmlUnescape((String)this.getChain());
    }

    public void setChain(String chain) {
        if (this.getFolder() == 1L) {
            chain = chain.replace(SEPARATOR_PLACEHOLDER, CHAIN_SEPARATOR);
            chain = HtmlUtils.htmlUnescape((String)chain.substring(0, chain.length() - END_SEPARATOR_PLACEHOLDER.length()));
        } else {
            int index = chain.lastIndexOf(SEPARATOR_PLACEHOLDER);
            if (index >= 0) {
                chain = chain.substring(0, index);
            }
            chain = chain.replace(SEPARATOR_PLACEHOLDER, CHAIN_SEPARATOR);
        }
        this.chain = chain;
    }

    public Long getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Long attachments) {
        this.attachments = attachments;
    }

    public String getNatureType() {
        return this.natureType;
    }

    public void setNatureType(String natureType) {
        this.natureType = natureType;
    }

    public String getTypeType() {
        return this.typeType;
    }

    public void setTypeType(String typeType) {
        this.typeType = typeType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String getUnescapedName() {
        return HtmlUtils.htmlUnescape((String)this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getLevel() {
        return this.level;
    }

    public void setLevel(Long level) {
        this.level = level;
    }

    public String getReference() {
        return this.reference;
    }

    public String getUnescapedReference() {
        return HtmlUtils.htmlUnescape((String)this.reference);
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getAutomationPriority() {
        return this.automationPriority;
    }

    public void setAutomationPriority(String automationPriority) {
        this.automationPriority = automationPriority;
    }

    public Long getAllowAutomationWorkflow() {
        return this.allowAutomationWorkflow;
    }

    public void setAllowAutomationWorkflow(Long allowAutomationWorkflow) {
        this.allowAutomationWorkflow = allowAutomationWorkflow;
    }

    public void setExecutionMode(Long executionMode) {
        this.executionMode = executionMode;
    }

    public Long getExecutionMode() {
        return this.executionMode;
    }

    public Long getFolder() {
        return this.folder;
    }

    public void setFolder(Long folder) {
        this.folder = folder;
    }

    public String getChainDescription() {
        return this.chainDescription;
    }

    public void setChainDescription(String chainDescription) {
        this.chainDescription = chainDescription;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedOn(String lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public String getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setTcSteps(List<TestCaseStep> testCaseSteps) {
        this.tcSteps = testCaseSteps;
    }

    public List<TestCaseStep> getTcSteps() {
        return this.tcSteps;
    }

    public List<LinkedRequirements> getLinkedRequirements() {
        return this.linkedRequirements;
    }

    public void setLinkedRequirements(List<LinkedRequirements> linkedRequirements) {
        this.linkedRequirements = linkedRequirements;
    }

    public String getSortingChain() {
        return this.sortingChain;
    }

    public void setSortingChain(String sortingChain) {
        sortingChain = sortingChain.replace(SEPARATOR_PLACEHOLDER, SORTING_CHAIN_SEPARATOR);
        this.sortingChain = HtmlUtils.htmlEscape((String)sortingChain.substring(0, sortingChain.length() - END_SEPARATOR_PLACEHOLDER.length()));
    }

    public String getMilestoneNames() {
        return this.milestoneNames;
    }

    public void setMilestoneNames(String milestoneLabels) {
        this.milestoneNames = Objects.nonNull(milestoneLabels) ? milestoneLabels.replace(",", MILESTONE_SEPARATOR) : "";
    }

    public boolean isPrintChain() {
        return this.printChain;
    }

    public void setPrintChain(boolean printChain) {
        this.printChain = printChain;
    }

    public List<Long> getNodeIds() {
        String[] nodesIds = this.nodeIds.split(SEPARATOR_PLACEHOLDER);
        ArrayList<Long> hierarchyNodes = new ArrayList<Long>();
        String[] stringArray = nodesIds;
        int n = nodesIds.length;
        int n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            hierarchyNodes.add(Long.parseLong(node.replace(END_SEPARATOR_PLACEHOLDER, "")));
            ++n2;
        }
        return hierarchyNodes;
    }

    public void setNodeIds(String nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Dataset> getDatasets() {
        return this.datasets;
    }

    public void setDatasets(List<Dataset> datasets) {
        this.datasets = datasets;
    }

    public boolean isPrintParameters() {
        return this.printParameters;
    }

    public void setPrintParameters(boolean printParameters) {
        this.printParameters = printParameters;
    }

    public boolean isPrintLinkedReq() {
        return this.printLinkedReq;
    }

    public void setPrintLinkedReq(boolean printLinkedReq) {
        this.printLinkedReq = printLinkedReq;
    }

    public List<PrintableCuf> getPrintableCufs() {
        return this.printableCufs;
    }

    public void setPrintableCufs(List<PrintableCuf> printableCufs) {
        this.printableCufs = printableCufs;
    }

    public List<CufPair> getCufPairs() {
        return this.cufPairs;
    }

    public void setCufs(List<Cuf> cufs) {
        this.cufPairs.clear();
        Iterator<Cuf> it = cufs.iterator();
        while (it.hasNext()) {
            Cuf next = it.next();
            CufPair pair = new CufPair();
            pair.setFirstCuf(next);
            if (it.hasNext()) {
                pair.setSecondCuf(it.next());
            }
            this.cufPairs.add(pair);
        }
    }

    public List<Cuf> getRtfCufs() {
        ArrayList<Cuf> list = new ArrayList<Cuf>(this.rtfCufs);
        list.addAll(this.getTagCufs());
        return list;
    }

    public void setRtfCufs(List<Cuf> rtfCufs) {
        this.rtfCufs = rtfCufs;
    }

    public List<Cuf> getNumCufs() {
        return this.numCufs;
    }

    public void setNumCufs(List<Cuf> numCufs) {
        this.numCufs = numCufs;
    }

    public List<Cuf> getTagCufs() {
        return this.tagCufs;
    }

    public void setTagCufs(List<Cuf> tagCufs) {
        this.tagCufs = tagCufs;
    }

    public boolean isPrintSteps() {
        return this.printSteps;
    }

    public void setPrintSteps(boolean printSteps) {
        this.printSteps = printSteps;
    }

    public boolean isPrintMilestones() {
        return this.printMilestones;
    }

    public void setPrintMilestones(boolean printMilestones) {
        this.printMilestones = printMilestones;
    }
}

