/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testcase;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.service.internal.dto.testcase.TestCase;

public class Node
implements Comparable<Node> {
    private Long itemId;
    private Long projectId;
    private String projectName;
    private List<TestCase> testCases = new ArrayList<TestCase>();
    private String sortingChain;

    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getUnescapedProjectName() {
        return HtmlUtils.htmlUnescape((String)this.projectName);
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setTestCases(List<TestCase> testCases) {
        this.testCases = testCases;
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public String getSortingChain() {
        return this.sortingChain;
    }

    public void setSortingChain(String sortingChain) {
        this.sortingChain = sortingChain;
    }

    @Override
    public int compareTo(Node node) {
        int comparison = this.projectName.compareTo(node.projectName);
        if (comparison == 0) {
            TestCase myHiLevel = this.testCases.getFirst();
            TestCase otherHiLevel = node.getTestCases().getFirst();
            comparison = myHiLevel.getSortingChain().compareTo(otherHiLevel.getSortingChain());
        }
        return comparison;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.itemId, node.itemId) && Objects.equals(this.projectId, node.projectId) && Objects.equals(this.projectName, node.projectName) && Objects.equals(this.testCases, node.testCases);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.projectId, this.projectName, this.testCases);
    }
}

