/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testcase;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.service.internal.dto.testcase.I18nHelper;

public class LinkedRequirements {
    private static final String SORTING_CHAIN_SEPARATOR = " ";
    private static final String MILESTONE_SEPARATOR = ", ";
    public static final String REQUIREMENT_CRITICALITY = "requirement.criticality.";
    public static final String REQUIREMENT_STATUS = "requirement.status.";
    private Long id;
    private String name;
    private String projectName;
    private String criticality;
    private String status;
    private Long version;
    private String reference;
    private Long testCaseId;
    private String milestoneNames;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCriticality() {
        return I18nHelper.translate(REQUIREMENT_CRITICALITY + (this.isValidRequirementCriticality() ? this.criticality : RequirementCriticality.UNDEFINED.name()));
    }

    private boolean isValidRequirementCriticality() {
        return Objects.nonNull(this.criticality) && Arrays.stream(RequirementCriticality.values()).anyMatch(e -> e.name().equals(this.criticality));
    }

    public void setCriticality(String criticality) {
        this.criticality = criticality;
    }

    public String getStatus() {
        return I18nHelper.translate(REQUIREMENT_STATUS + (this.isValidRequirementStatus() ? this.status : RequirementStatus.WORK_IN_PROGRESS.name()));
    }

    private boolean isValidRequirementStatus() {
        return Objects.nonNull(this.status) && Arrays.stream(RequirementStatus.values()).anyMatch(e -> e.name().equals(this.status));
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public boolean isNoReference() {
        return StringUtils.isBlank((CharSequence)this.reference);
    }

    public String getMilestoneNames() {
        return this.milestoneNames;
    }

    public void setMilestoneNames(String milestoneNames) {
        this.milestoneNames = milestoneNames == null ? "" : milestoneNames.replace(",", MILESTONE_SEPARATOR);
    }
}

