/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testcase;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component(value="report.books.testcases.i18nHelper")
public class I18nHelper
implements MessageSourceAware {
    private static MessageSource msgSource;

    private static Locale currentLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static String translate(String string) {
        return msgSource.getMessage(string, null, I18nHelper.currentLocale());
    }

    public static String translate(String string, Object[] params) {
        return msgSource.getMessage(string, params, I18nHelper.currentLocale());
    }

    public static String translateTo(String string, Locale locale) {
        return msgSource.getMessage(string, null, locale);
    }

    public static Locale toLocale(String name) {
        return switch (name) {
            case "FRENCH" -> Locale.FRENCH;
            case "GERMAN" -> Locale.GERMAN;
            case "SPANISH" -> Locale.of("es");
            default -> Locale.ENGLISH;
        };
    }

    public void setMessageSource(@NonNull MessageSource messageSource) {
        msgSource = messageSource;
    }
}

