/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.testcase;

import java.util.regex.Pattern;

public class ActionWordFragmentValueDto {
    private static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("<[^\"]+>");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+(([.,])\\d+)?");
    private static final String QUOTED_VALUE_FORMAT = "\"%s\"";
    private static final String PARAMETER = "PARAMETER";
    private Long keywordStepId;
    protected String value;
    private String type;

    public String getUnstyledAction() {
        if (PARAMETER.equals(this.type) && !this.checkParameterValue()) {
            return String.format(QUOTED_VALUE_FORMAT, this.value);
        }
        return this.value;
    }

    boolean checkParameterValue() {
        return this.value.isBlank() || this.referencesTestCaseParameter() || this.isNumber();
    }

    private boolean referencesTestCaseParameter() {
        return PARAM_VALUE_PATTERN.matcher(this.value).matches();
    }

    private boolean isNumber() {
        return NUMBER_PATTERN.matcher(this.value).matches();
    }

    public Long getKeywordStepId() {
        return this.keywordStepId;
    }

    public void setKeywordStepId(Long keywordStepId) {
        this.keywordStepId = keywordStepId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

