/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.testcase;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.testcase.TestCasePathFinderService;
import org.squashtest.tm.service.internal.batchexport.ExportDaoUtils;
import org.squashtest.tm.service.internal.library.HibernatePathService;

@Service
@Transactional(readOnly=true)
public class TestCasePathFinderServiceImpl
implements TestCasePathFinderService {
    @PersistenceContext
    private EntityManager em;

    @Override
    public String buildTestCasePath(Long testCaseId, String testCaseProjectName) {
        if (testCaseId != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(testCaseProjectName);
            String pathFromFolder = this.getPathFromFolder(testCaseId);
            sb.append(pathFromFolder);
            return HibernatePathService.substituteSpecialPathSeparator(sb.toString());
        }
        return null;
    }

    private String getPathFromFolder(Long testCaseId) {
        String result = this.testCaseQuery("TestCase.findPathById", testCaseId, "");
        if (!result.isEmpty()) {
            return " \u001f " + result;
        }
        return "";
    }

    private String testCaseQuery(String queryName, Long testCaseId, String defaultValue) {
        Session session = this.getStatelessSession();
        Query q = session.createNamedQuery(queryName, String.class);
        q.setParameter("testCaseId", (Object)testCaseId);
        String result = (String)q.uniqueResult();
        return result != null ? result : defaultValue;
    }

    private Session getStatelessSession() {
        return ExportDaoUtils.getStatelessSession(this.em);
    }
}

