/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityReferences;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.service.internal.repository.display.MultipleHierarchyTreeBrowserDao;

@Component
public class HighLevelRequirementScopeExtender {
    private static final Requirement LINKED_REQUIREMENT = Tables.REQUIREMENT.as("LINKED_REQUIREMENT");
    private final MultipleHierarchyTreeBrowserDao treeBrowserDao;
    private final DSLContext dslContext;

    public HighLevelRequirementScopeExtender(MultipleHierarchyTreeBrowserDao treeBrowserDao, DSLContext dslContext) {
        this.treeBrowserDao = treeBrowserDao;
        this.dslContext = dslContext;
    }

    public List<EntityReference> extendScope(List<EntityReference> initialScope) {
        NodeReferences nodeReferences = new EntityReferences(initialScope).toNodeReferences();
        Set libraries = nodeReferences.extractLibraries();
        Set initialNonLibraries = nodeReferences.extractNonLibraries();
        Set<Long> ids = this.findPerimeterAsRln(libraries, initialNonLibraries);
        Set<EntityReference> linkedRequirements = this.findAllLinkedRequirements(ids);
        Set<Long> linkedRequirementIds = linkedRequirements.stream().map(EntityReference::getId).collect(Collectors.toSet());
        Set<EntityReference> alreadyInPerimeterByLibrary = this.findAlreadyInScopeByLibraries(libraries, linkedRequirementIds);
        Set<EntityReference> alreadyInPerimeterByRLN = this.findAlreadyInPerimeterByRequirementLibraryNodes(initialNonLibraries, linkedRequirementIds);
        linkedRequirements.removeAll(alreadyInPerimeterByLibrary);
        linkedRequirements.removeAll(alreadyInPerimeterByRLN);
        ArrayList<EntityReference> extendedScope = new ArrayList<EntityReference>(initialScope);
        extendedScope.addAll(linkedRequirements);
        return extendedScope;
    }

    private Set<EntityReference> findAlreadyInPerimeterByRequirementLibraryNodes(Set<NodeReference> initialNonLibraries, Set<Long> linkedRequirementIds) {
        Set initialNonLibraryIds = initialNonLibraries.stream().map(NodeReference::getId).collect(Collectors.toSet());
        return this.dslContext.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(initialNonLibraryIds)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.in(linkedRequirementIds)).stream().map(record -> new EntityReference(EntityType.REQUIREMENT, (Long)record.value1())).collect(Collectors.toSet());
    }

    private Set<EntityReference> findAlreadyInScopeByLibraries(Set<NodeReference> libraries, Set<Long> linkedRequirementIds) {
        Set libraryIds = libraries.stream().map(NodeReference::getId).collect(Collectors.toSet());
        return this.dslContext.selectDistinct((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.RL_ID.in(libraryIds)).and(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(linkedRequirementIds)).stream().map(record -> new EntityReference(EntityType.REQUIREMENT, (Long)record.value1())).collect(Collectors.toSet());
    }

    private Set<EntityReference> findAllLinkedRequirements(Set<Long> ids) {
        return this.dslContext.selectDistinct((SelectField)HighLevelRequirementScopeExtender.LINKED_REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).innerJoin((TableLike)LINKED_REQUIREMENT).on(HighLevelRequirementScopeExtender.LINKED_REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(ids)).stream().map(record -> new EntityReference(EntityType.REQUIREMENT, (Long)record.value1())).collect(Collectors.toSet());
    }

    private Set<Long> findPerimeterAsRln(Set<NodeReference> libraries, Set<NodeReference> initialNonLibraries) {
        HashSet<NodeReference> ancestors = new HashSet<NodeReference>(initialNonLibraries);
        Collection librariesChildren = this.treeBrowserDao.findChildrenReference(libraries).values();
        ancestors.addAll(librariesChildren);
        return ancestors.stream().map(NodeReference::getId).collect(Collectors.toSet());
    }
}

