/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.CampaignTestPlanItemRecord;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractTestPlanGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class CampaignTestPlanGrid
extends AbstractTestPlanGrid<CampaignTestPlanItemRecord> {
    private final Long campaignId;

    public CampaignTestPlanGrid(Long campaignId, String userLoginToRestrictTo) {
        super(userLoginToRestrictTo);
        this.campaignId = campaignId;
    }

    @Override
    protected TableField<CampaignTestPlanItemRecord, Long> getItemIdColumn() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID;
    }

    @Override
    protected TableField<CampaignTestPlanItemRecord, Long> getAssigneeIdColumn() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.USER_ID;
    }

    @Override
    protected TableField<CampaignTestPlanItemRecord, String> getExecutorLoginColumn() {
        return null;
    }

    @Override
    protected TableField<CampaignTestPlanItemRecord, Long> getTestCaseIdColumn() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID;
    }

    @Override
    protected TableOnConditionStep<Record> getItemTable() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID));
    }

    @Override
    protected Condition getItemFilterCondition() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Object)this.campaignId);
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID), new GridColumn((Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME.as("TEST_CASE_NAME"), (Field<?>)Tables.TEST_CASE_LIBRARY_NODE.NAME), new GridColumn(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.as("PROJECT_ID")), new GridColumn(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.as("CAMPAIGN_ID")), new GridColumn((Field<?>)Tables.PROJECT.NAME.as("PROJECT_NAME"), (Field<?>)Tables.PROJECT.NAME), new GridColumn((Field<?>)Tables.TEST_CASE.REFERENCE.as("TEST_CASE_REFERENCE"), (Field<?>)Tables.TEST_CASE.REFERENCE), new GridColumn(Tables.TEST_CASE.TCLN_ID.as("TEST_CASE_ID")), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)Tables.TEST_CASE.IMPORTANCE), new GridColumn(this.getUser().field("ASSIGNEE_FULL_NAME")), new GridColumn(this.getUser().field("ASSIGNEE_LOGIN")), new GridColumn((Field<?>)Tables.DATASET.NAME.as("DATASET_NAME"), (Field<?>)Tables.DATASET.NAME), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"MILESTONE_DATES", "MILESTONE_MIN_DATE"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"MILESTONE_DATES", "MILESTONE_MAX_DATE"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"MILESTONE_DATES", "MILESTONE_LABELS"}))), new GridColumn(DSL.field((Name)DSL.name((String[])new String[]{"BLOCKED_MILESTONE", "ITEM_ID"})).isNotNull().as("BOUND_TO_BLOCKING_MILESTONE")));
    }

    @Override
    protected Table<?> getTable() {
        Table<Record> getUser = this.getUser();
        Table<Record1<Long>> boundToLockedMilestone = this.getBoundToBlockingMilestone();
        Table<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        return this.getFilteredTableOnAssigneeIfNotExploratory((Table<Record>)Tables.CAMPAIGN_TEST_PLAN_ITEM.innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin((TableLike)Tables.DATASET).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.DATASET_ID.eq((Field)Tables.DATASET.DATASET_ID)).leftJoin(getUser).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID.eq(getUser.field("ITEM_ID", Long.class))).leftJoin(milestoneDates).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID.eq(milestoneDates.field("ITEM_ID", Long.class))).leftJoin(boundToLockedMilestone).on(Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID.eq(boundToLockedMilestone.field("ITEM_ID", Long.class))).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)));
    }

    @Override
    protected Condition isExploratoryRow() {
        return Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull();
    }

    @Override
    protected Condition craftInvariantFilter() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Object)this.campaignId);
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.CAMPAIGN_TEST_PLAN_ITEM.TEST_PLAN_ORDER.asc();
    }

    @Override
    protected Table<Record1<Long>> getBoundToBlockingMilestone() {
        return DSL.selectDistinct((SelectField)Tables.CAMPAIGN_TEST_PLAN_ITEM.CTPI_ID.as("ITEM_ID")).from((TableLike)Tables.CAMPAIGN_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID)).where(Tables.CAMPAIGN_TEST_PLAN_ITEM.CAMPAIGN_ID.eq((Object)this.campaignId).and(Tables.MILESTONE.STATUS.in((Collection)MilestoneStatus.MILESTONE_BLOCKING_STATUSES))).asTable("BLOCKED_MILESTONE");
    }

    @Override
    protected List<GridColumn> getSpecificColumns() {
        throw new UnsupportedOperationException();
    }
}

