/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.administration;

import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class TestAutomationServerGrid
extends AbstractGrid {
    private static final String SERVER_ID = "SERVER_ID";

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.TEST_AUTOMATION_SERVER.SERVER_ID), new GridColumn((Field<?>)Tables.THIRD_PARTY_SERVER.NAME), new GridColumn(Tables.THIRD_PARTY_SERVER.URL.as("BASE_URL")), new GridColumn((Field<?>)Tables.TEST_AUTOMATION_SERVER.KIND), new GridColumn((Field<?>)Tables.THIRD_PARTY_SERVER.CREATED_BY), new GridColumn((Field<?>)Tables.THIRD_PARTY_SERVER.CREATED_ON), new GridColumn((Field<?>)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_BY), new GridColumn((Field<?>)Tables.THIRD_PARTY_SERVER.LAST_MODIFIED_ON), new GridColumn(DSL.isnull((Field)DSL.field((String)"EXECUTION_COUNT"), (Object)0).as("EXECUTION_COUNT")), new GridColumn(DSL.isnull((Field)DSL.field((String)"PROJECT_COUNT"), (Object)0).as("PROJECT_COUNT")));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, Integer>> executionCount = this.getExecutionCount();
        SelectHavingStep<Record2<Long, Integer>> projectCount = this.getProjectCount();
        return Tables.TEST_AUTOMATION_SERVER.innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).leftJoin(executionCount).on(executionCount.field(SERVER_ID, Long.class).eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).leftJoin(projectCount).on(projectCount.field(SERVER_ID, Long.class).eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID));
    }

    private SelectHavingStep<Record2<Long, Integer>> getExecutionCount() {
        return DSL.select((SelectField)Tables.TEST_AUTOMATION_SERVER.SERVER_ID.as(SERVER_ID), (SelectField)DSL.countDistinct((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID).as("EXECUTION_COUNT")).from((TableLike)Tables.TEST_AUTOMATION_SERVER).leftJoin((TableLike)Tables.TEST_AUTOMATION_PROJECT).on(Tables.TEST_AUTOMATION_PROJECT.SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).leftJoin((TableLike)Tables.AUTOMATED_TEST).on(Tables.TEST_AUTOMATION_PROJECT.TA_PROJECT_ID.eq((Field)Tables.AUTOMATED_TEST.PROJECT_ID)).leftJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(Tables.AUTOMATED_TEST.TEST_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.TEST_ID)).groupBy(new GroupField[]{Tables.TEST_AUTOMATION_SERVER.SERVER_ID});
    }

    private SelectHavingStep<Record2<Long, Integer>> getProjectCount() {
        return DSL.select((SelectField)Tables.TEST_AUTOMATION_SERVER.SERVER_ID.as(SERVER_ID), (SelectField)DSL.countDistinct((Field)Tables.PROJECT.PROJECT_ID).as("PROJECT_COUNT")).from((TableLike)Tables.TEST_AUTOMATION_SERVER).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.TA_SERVER_ID.eq((Field)Tables.TEST_AUTOMATION_SERVER.SERVER_ID)).groupBy(new GroupField[]{Tables.TEST_AUTOMATION_SERVER.SERVER_ID});
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.TEST_AUTOMATION_SERVER.SERVER_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.upper((Field)Tables.THIRD_PARTY_SERVER.NAME).asc();
    }
}

