/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseExecutionMode;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

public abstract class AbstractSuccessRateCalculator {
    protected final DSLContext dslContext;

    protected AbstractSuccessRateCalculator(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public void appendSuccessRate(GridResponse gridResponse) {
        this.appendSuccessRate(gridResponse.getDataRows());
    }

    private void appendSuccessRate(List<DataRow> dataRows) {
        Set<Long> dataRowIds = this.extractIds(dataRows);
        Map<Long, Float> rateById = this.createRateByDataRowIdMap(dataRowIds);
        Converter converter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
        String successRateKey = (String)converter.convert((Object)"SUCCESS_RATE");
        String executionModeKey = (String)converter.convert((Object)"EXECUTION_MODE");
        String executionStatusKey = (String)converter.convert((Object)"EXECUTION_STATUS");
        dataRows.forEach(dataRow -> {
            long id = Long.parseLong(dataRow.getId());
            if (TestCaseExecutionMode.AUTOMATED.name().equals(dataRow.getData().get(executionModeKey))) {
                boolean isAutomatedExecutionInSuccess = ExecutionStatus.SUCCESS.name().equals(dataRow.getData().get(executionStatusKey));
                float automatedExecutionSuccessRate = isAutomatedExecutionInSuccess ? 100 : 0;
                dataRow.getData().put(successRateKey, Float.valueOf(automatedExecutionSuccessRate));
            } else {
                dataRow.getData().put(successRateKey, rateById.getOrDefault(id, Float.valueOf(0.0f)));
            }
        });
    }

    private Set<Long> extractIds(List<DataRow> dataRows) {
        return dataRows.stream().map(DataRow::getId).map(Long::parseLong).collect(Collectors.toSet());
    }

    protected abstract Map<Long, Float> createRateByDataRowIdMap(Set<Long> var1);
}

