/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.denormalizedfield;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.MultiValueMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedNumericValue;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedRichValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueServiceImpl$AjcClosure3;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueServiceImpl$AjcClosure5;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueServiceImpl$AjcClosure7;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.DenormalizedFieldValueDao;
import org.squashtest.tm.service.internal.repository.DenormalizedFieldValueDeletionDao;
import org.squashtest.tm.service.internal.repository.ExecutionDao;

@Transactional
@Service(value="squashtest.tm.service.DenormalizedFieldValueManager")
public class PrivateDenormalizedFieldValueServiceImpl
implements PrivateDenormalizedFieldValueService {
    @Inject
    private CustomFieldValueDao customFieldValueDao;
    @Inject
    private DenormalizedFieldValueDao denormalizedFieldValueDao;
    @Inject
    private DenormalizedFieldValueDeletionDao denormalizedFieldValueDeletionDao;
    @Inject
    private ExecutionDao execDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    @Override
    public void createAllDenormalizedFieldValues(BoundEntity source, DenormalizedFieldHolder destination) {
        List<CustomFieldValue> customFieldValues = this.customFieldValueDao.findAllCustomValues(source.getBoundEntityId(), source.getBoundEntityType());
        this.createDenormalizedFieldValues(destination, customFieldValues);
    }

    @Override
    public void createBatchDenormalizedFieldValues(Map<Long, List<DenormalizedFieldHolder>> map, BindableEntity boundEntityType) {
        List boundEntities = map.keySet().stream().toList();
        BindableEntity bindableEntity = boundEntityType;
        List list = boundEntities;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)customFieldValueDao, list, (Object)bindableEntity);
        Object[] objectArray = new Object[]{this, customFieldValueDao, list, bindableEntity, joinPoint};
        PrivateDenormalizedFieldValueServiceImpl$AjcClosure1 privateDenormalizedFieldValueServiceImpl$AjcClosure1 = new PrivateDenormalizedFieldValueServiceImpl$AjcClosure1(objectArray);
        List customFieldValues = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateDenormalizedFieldValueServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        this.createDenormalizedFieldValues(map, (List<CustomFieldValue>)customFieldValues);
    }

    private void createDenormalizedFieldValues(Map<Long, List<DenormalizedFieldHolder>> map, List<CustomFieldValue> customFieldValues) {
        for (CustomFieldValue cfv : customFieldValues) {
            List<DenormalizedFieldHolder> holders = map.get(cfv.getBoundEntityId());
            if (holders == null) continue;
            for (DenormalizedFieldHolder holder : holders) {
                this.doCreate(holder, cfv);
            }
        }
    }

    @Override
    public void createAllDenormalizedFieldValuesForSteps(Execution execution) {
        this.createAllDenormalizedFieldValuesForSteps(Collections.singletonList(execution));
    }

    @Override
    public void createAllDenormalizedFieldValuesForSteps(Collection<Execution> executions) {
        List<Long> executionIds = executions.stream().map(Execution::getId).toList();
        List executionSteps = executions.stream().flatMap(e -> e.getSteps().stream()).toList();
        if (executionSteps.isEmpty()) {
            return;
        }
        List<Long> originalIds = this.execDao.findOriginalStepIds(executionIds);
        BindableEntity bindableEntity = BindableEntity.TEST_STEP;
        List<Long> list = originalIds;
        CustomFieldValueDao customFieldValueDao = this.customFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)customFieldValueDao, list, (Object)bindableEntity);
        Object[] objectArray = new Object[]{this, customFieldValueDao, list, bindableEntity, joinPoint};
        PrivateDenormalizedFieldValueServiceImpl$AjcClosure3 privateDenormalizedFieldValueServiceImpl$AjcClosure3 = new PrivateDenormalizedFieldValueServiceImpl$AjcClosure3(objectArray);
        List originalValues = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateDenormalizedFieldValueServiceImpl$AjcClosure3.linkClosureAndJoinPoint(4112));
        MultiValueMap cufsPerStepId = new MultiValueMap();
        for (CustomFieldValue value : originalValues) {
            cufsPerStepId.put((Object)value.getBoundEntityId(), (Object)value);
        }
        for (ExecutionStep executionStep : executionSteps) {
            Collection values = cufsPerStepId.getCollection((Object)executionStep.getReferencedTestStep().getId());
            if (values == null) continue;
            List<CustomFieldValue> customFieldValues = values.stream().filter(CustomFieldValue.class::isInstance).map(CustomFieldValue.class::cast).toList();
            this.createDenormalizedFieldValues((DenormalizedFieldHolder)executionStep, new ArrayList<CustomFieldValue>(customFieldValues));
        }
    }

    private void createDenormalizedFieldValues(DenormalizedFieldHolder entity, List<CustomFieldValue> values) {
        for (CustomFieldValue cfv : values) {
            this.doCreate(entity, cfv);
        }
    }

    private void doCreate(DenormalizedFieldHolder entity, CustomFieldValue cfv) {
        DenormalizedRichValue dfv = switch (cfv.getCustomField().getInputType()) {
            case InputType.RICH_TEXT -> new DenormalizedRichValue(cfv, entity.getDenormalizedFieldHolderId(), entity.getDenormalizedFieldHolderType());
            case InputType.NUMERIC -> new DenormalizedNumericValue(cfv, entity.getDenormalizedFieldHolderId(), entity.getDenormalizedFieldHolderType());
            default -> new DenormalizedFieldValue(cfv, entity.getDenormalizedFieldHolderId(), entity.getDenormalizedFieldHolderType());
        };
        this.denormalizedFieldValueDao.save(dfv);
    }

    @Override
    public void deleteAllDenormalizedFieldValues(DenormalizedFieldHolder entity) {
        List<DenormalizedFieldValue> dfvs = this.denormalizedFieldValueDao.findDFVForEntity(entity.getDenormalizedFieldHolderId(), entity.getDenormalizedFieldHolderType());
        for (DenormalizedFieldValue dfv : dfvs) {
            this.denormalizedFieldValueDeletionDao.removeDenormalizedFieldValue(dfv);
        }
    }

    @Override
    public void deleteAllDenormalizedFieldValues(DenormalizedFieldHolderType holderType, Collection<Long> holderIds) {
        DenormalizedFieldHolderType denormalizedFieldHolderType = holderType;
        Collection<Long> collection = holderIds;
        DenormalizedFieldValueDao denormalizedFieldValueDao = this.denormalizedFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)denormalizedFieldValueDao, collection, (Object)denormalizedFieldHolderType);
        Object[] objectArray = new Object[]{this, denormalizedFieldValueDao, collection, denormalizedFieldHolderType, joinPoint};
        PrivateDenormalizedFieldValueServiceImpl$AjcClosure5 privateDenormalizedFieldValueServiceImpl$AjcClosure5 = new PrivateDenormalizedFieldValueServiceImpl$AjcClosure5(objectArray);
        SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateDenormalizedFieldValueServiceImpl$AjcClosure5.linkClosureAndJoinPoint(4112));
    }

    @Override
    public List<DenormalizedFieldValue> findAllForEntity(DenormalizedFieldHolder denormalizedFieldHolder) {
        return this.denormalizedFieldValueDao.findDFVForEntity(denormalizedFieldHolder.getDenormalizedFieldHolderId(), denormalizedFieldHolder.getDenormalizedFieldHolderType());
    }

    @Override
    public List<DenormalizedFieldValue> findAllForEntities(Collection<DenormalizedFieldHolder> entities) {
        Collection entityIds;
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        DenormalizedFieldHolderType type = entities.iterator().next().getDenormalizedFieldHolderType();
        Collection collection = entityIds = CollectionUtils.collect(entities, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((DenormalizedFieldHolder)input).getDenormalizedFieldHolderId();
            }
        });
        DenormalizedFieldHolderType denormalizedFieldHolderType = type;
        DenormalizedFieldValueDao denormalizedFieldValueDao = this.denormalizedFieldValueDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)denormalizedFieldValueDao, (Object)denormalizedFieldHolderType, (Object)collection);
        Object[] objectArray = new Object[]{this, denormalizedFieldValueDao, denormalizedFieldHolderType, collection, joinPoint};
        PrivateDenormalizedFieldValueServiceImpl$AjcClosure7 privateDenormalizedFieldValueServiceImpl$AjcClosure7 = new PrivateDenormalizedFieldValueServiceImpl$AjcClosure7(objectArray);
        return (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(privateDenormalizedFieldValueServiceImpl$AjcClosure7.linkClosureAndJoinPoint(4112));
    }

    @Override
    public List<DenormalizedFieldValue> findAllForEntity(Long denormalizedFieldHolderId, DenormalizedFieldHolderType denormalizedFieldHolderType) {
        return this.denormalizedFieldValueDao.findDFVForEntity(denormalizedFieldHolderId, denormalizedFieldHolderType);
    }

    @Override
    public void changeValue(long denormalizedFieldValueId, RawValue newValue) {
        DenormalizedFieldValue changedValue = this.denormalizedFieldValueDao.findById(denormalizedFieldValueId);
        newValue.setValueFor(changedValue);
    }

    @Override
    public boolean hasDenormalizedFields(DenormalizedFieldHolder entity) {
        return this.denormalizedFieldValueDao.countDenormalizedFields(entity.getDenormalizedFieldHolderId(), entity.getDenormalizedFieldHolderType()) > 0L;
    }

    static {
        PrivateDenormalizedFieldValueServiceImpl.ajc$preClinit();
    }

    static final /* synthetic */ List batchedInitializedFindAllCustomValuesFor_aroundBody0(PrivateDenormalizedFieldValueServiceImpl privateDenormalizedFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, List list, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedInitializedFindAllCustomValuesFor(list, bindableEntity);
    }

    static final /* synthetic */ List batchedInitializedFindAllCustomValuesFor_aroundBody2(PrivateDenormalizedFieldValueServiceImpl privateDenormalizedFieldValueServiceImpl, CustomFieldValueDao customFieldValueDao, List list, BindableEntity bindableEntity, JoinPoint joinPoint) {
        return customFieldValueDao.batchedInitializedFindAllCustomValuesFor(list, bindableEntity);
    }

    static final /* synthetic */ void deleteAllForEntities_aroundBody4(PrivateDenormalizedFieldValueServiceImpl privateDenormalizedFieldValueServiceImpl, DenormalizedFieldValueDao denormalizedFieldValueDao, Collection collection, DenormalizedFieldHolderType denormalizedFieldHolderType, JoinPoint joinPoint) {
        denormalizedFieldValueDao.deleteAllForEntities(collection, denormalizedFieldHolderType);
    }

    static final /* synthetic */ List findDFVForEntities_aroundBody6(PrivateDenormalizedFieldValueServiceImpl privateDenormalizedFieldValueServiceImpl, DenormalizedFieldValueDao denormalizedFieldValueDao, DenormalizedFieldHolderType denormalizedFieldHolderType, Collection collection, JoinPoint joinPoint) {
        return denormalizedFieldValueDao.findDFVForEntities(denormalizedFieldHolderType, collection);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PrivateDenormalizedFieldValueServiceImpl.java", PrivateDenormalizedFieldValueServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedInitializedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.List:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 79);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "batchedInitializedFindAllCustomValuesFor", "org.squashtest.tm.service.internal.repository.CustomFieldValueDao", "java.util.List:org.squashtest.tm.domain.customfield.BindableEntity", "arg0:arg1", "", "java.util.List"), 120);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "deleteAllForEntities", "org.squashtest.tm.service.internal.repository.DenormalizedFieldValueDao", "java.util.Collection:org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType", "arg0:arg1", "", "void"), 189);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "findDFVForEntities", "org.squashtest.tm.service.internal.repository.DenormalizedFieldValueDao", "org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolderType:java.util.Collection", "arg0:arg1", "", "java.util.List"), 220);
    }
}

