/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.UUID;
import org.jooq.DSLContext;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcIterationDeletionHandler;

@Component
public class JdbcIterationDeletionHandlerFactory {
    private final DSLContext dslContext;
    private final EntityManager entityManager;
    private final AttachmentRepository attachmentRepository;
    private final JdbcBatchReorderHelper reorderHelper;

    public JdbcIterationDeletionHandlerFactory(DSLContext dslContext, EntityManager entityManager, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.entityManager = entityManager;
    }

    public JdbcIterationDeletionHandler build(Collection<Long> iterationIds) {
        return this.build(iterationIds, UUID.randomUUID().toString());
    }

    public JdbcIterationDeletionHandler build(Collection<Long> iterationIds, String operationId) {
        return new JdbcIterationDeletionHandler(iterationIds, this.dslContext, this.entityManager, this.attachmentRepository, this.reorderHelper, operationId);
    }
}

