/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.service.deletion.BoundToNotSelectedTestSuite;
import org.squashtest.tm.service.deletion.NotDeletableCampaignsPreviewReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.campaign.LockedCampaignNodeDetectionService;
import org.squashtest.tm.service.internal.deletion.AbstractLockedNodeDetectionService;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.CampaignDeletionDao;
import org.squashtest.tm.service.internal.repository.display.CampaignDisplayDao;
import org.squashtest.tm.service.internal.repository.display.IterationDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestSuiteDisplayDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Service
public class LockedCampaignNodeDetectionServiceImpl
extends AbstractLockedNodeDetectionService
implements LockedCampaignNodeDetectionService {
    private static final String EXTENDED_DELETE = "EXTENDED_DELETE";
    private static final String CAMPAIGNS_TYPE = "campaigns";
    private final CampaignDeletionDao deletionDao;
    private final CampaignDao campaignDao;
    private final CampaignDisplayDao campaignDisplayDao;
    private final IterationDisplayDao iterationDisplayDao;
    private final TestSuiteDisplayDao suiteDisplayDao;
    private final PermissionEvaluationService permissionEvaluationService;
    private final SprintDisplayDao sprintDisplayDao;

    @Autowired
    public LockedCampaignNodeDetectionServiceImpl(ActiveMilestoneHolder activeMilestoneHolder, CampaignDeletionDao deletionDao, CampaignDao campaignDao, CampaignDisplayDao campaignDisplayDao, IterationDisplayDao iterationDisplayDao, TestSuiteDisplayDao suiteDisplayDao, PermissionEvaluationService permissionEvaluationService, SprintDisplayDao sprintDisplayDao) {
        super(activeMilestoneHolder);
        this.deletionDao = deletionDao;
        this.campaignDao = campaignDao;
        this.campaignDisplayDao = campaignDisplayDao;
        this.iterationDisplayDao = iterationDisplayDao;
        this.suiteDisplayDao = suiteDisplayDao;
        this.permissionEvaluationService = permissionEvaluationService;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedCampaigns(List<Long> nodeIds) {
        List<NamedReference> campaigns = this.campaignDisplayDao.findNamedReferences(nodeIds);
        Map<Long, List<Long>> executionIdsByCampaignIds = this.campaignDisplayDao.findExecutionIdsByCampaignIds(nodeIds);
        return this.getReportToDetectLockedEntity(campaigns, executionIdsByCampaignIds, "org.squashtest.tm.domain.campaign.Campaign");
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedSprints(List<Long> nodeIds) {
        List<NamedReference> sprintNamedReferences = this.sprintDisplayDao.findNamedReferences(nodeIds);
        Map<Long, List<Long>> executionIdsBySprintIds = this.sprintDisplayDao.findExecutionIdsBySprintIds(nodeIds);
        return this.getReportToDetectLockedEntity(sprintNamedReferences, executionIdsBySprintIds, "org.squashtest.tm.domain.campaign.Sprint");
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedIteration(List<Long> nodeIds) {
        List<NamedReference> iterationNamedReferences = this.iterationDisplayDao.findNamedReferences(nodeIds);
        Map<Long, List<Long>> executionIdsByIterationIds = this.iterationDisplayDao.findExecutionIdsByIterationIds(nodeIds);
        return this.getReportToDetectLockedEntity(iterationNamedReferences, executionIdsByIterationIds, "org.squashtest.tm.domain.campaign.Iteration");
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedSuites(List<Long> nodeIds) {
        List<NamedReference> suiteNamedReferences = this.suiteDisplayDao.findNamedReferences(nodeIds);
        Map<Long, List<Long>> executionIdsBySuiteIds = this.suiteDisplayDao.findExecutionIdsBySuiteIds(nodeIds);
        return this.getReportToDetectLockedEntity(suiteNamedReferences, executionIdsBySuiteIds, "org.squashtest.tm.domain.campaign.TestSuite");
    }

    private List<SuppressionPreviewReport> getReportToDetectLockedEntity(List<NamedReference> namedReferences, Map<Long, List<Long>> executionIdsByEntityIds, String className) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        for (NamedReference namedReference : namedReferences) {
            List executionIds = executionIdsByEntityIds.getOrDefault(namedReference.getId(), Collections.emptyList());
            if (executionIds.isEmpty()) continue;
            boolean canExtendedDelete = this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", EXTENDED_DELETE, namedReference.getId(), className);
            NotDeletableCampaignsPreviewReport report = new NotDeletableCampaignsPreviewReport();
            report.addName(namedReference.getName());
            report.setHasRights(canExtendedDelete);
            if (!canExtendedDelete) {
                report.addLockedNode(namedReference.getId());
            }
            reportList.add(report);
        }
        return reportList;
    }

    @Override
    public List<SuppressionPreviewReport> detectTestPlanItemBoundMultipleTestSuite(List<Long> nodeIds) {
        ArrayList<SuppressionPreviewReport> reportList = new ArrayList<SuppressionPreviewReport>();
        if (this.containTestPlanItemThatBelongToOtherTestSuite(new HashSet<Long>(nodeIds))) {
            reportList.add(new BoundToNotSelectedTestSuite());
        }
        return reportList;
    }

    private boolean containTestPlanItemThatBelongToOtherTestSuite(Set<Long> testSuiteIds) {
        Map<Long, Set<Long>> otherSuites = this.suiteDisplayDao.findLinkedSuites(testSuiteIds);
        for (Map.Entry<Long, Set<Long>> entry : otherSuites.entrySet()) {
            if (testSuiteIds.containsAll((Collection)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByMilestone(List<Long> nodeIds) {
        return super.detectLockedByMilestone(nodeIds, CAMPAIGNS_TYPE);
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByMilestoneIteration(List<Long> nodeIds) {
        ArrayList<Long> campaignIds = new ArrayList<Long>(this.iterationDisplayDao.findCampaignIdsByIterationIds(new HashSet<Long>(nodeIds)));
        return this.detectLockedByMilestone(campaignIds);
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByMilestoneTestSuite(List<Long> nodeIds) {
        ArrayList<Long> campaignIds = new ArrayList<Long>(this.suiteDisplayDao.findCampaignIdsBySuiteIds(new HashSet<Long>(nodeIds)));
        return this.detectLockedByMilestone(campaignIds);
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedWithActiveMilestone(List<Long> nodeIds) {
        return super.detectLockedWithActiveMilestone(nodeIds, CAMPAIGNS_TYPE);
    }

    @Override
    protected List<Long> findNodesWhichMilestonesForbidsDeletion(List<Long> nodeIds) {
        return this.deletionDao.findCampaignsWhichMilestonesForbidsDeletion(nodeIds);
    }

    @Override
    protected void addAdditionalReportWithActiveMilestoneToReportList(List<Long> nodeIds, Long activeMilestoneId, List<SuppressionPreviewReport> reportList, String reportType) {
        List<Long> nonBoundNodes = this.campaignDao.findNonBoundCampaign(nodeIds, activeMilestoneId);
        this.addNonBoundNodesWithActiveMilestoneToReportList(nonBoundNodes, reportList, reportType);
    }

    @Override
    protected Map<String, List<Long>> getIdsSeparateFolderFromNodeIds(List<Long> nodeIds) {
        return this.deletionDao.separateFolderFromCampaignIds(nodeIds);
    }

    @Override
    protected List<Long> findNodeIdsHavingMultipleMilestones(List<Long> nodeIds) {
        return this.campaignDao.findCampaignIdsHavingMultipleMilestones(nodeIds);
    }
}

