/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;

public class DeletionPreview {
    private static final long DEFAULT_NO_CONFIRMATION_THRESHOLD = 0L;
    private Long deletionCount;
    private boolean requiresConfirmation;
    private final List<String> messageCollection = new ArrayList<String>();

    public DeletionPreview(Long count, long deletionThreshold) {
        this.deletionCount = count;
        this.requiresConfirmation = this.isRequiresConfirmation(deletionThreshold);
    }

    public DeletionPreview() {
        this.deletionCount = 0L;
        this.requiresConfirmation = false;
    }

    public void addMessages(List<SuppressionPreviewReport> reportList, MessageSource messageSource) {
        reportList.forEach(report -> {
            String message = report.toString(messageSource, LocaleContextHolder.getLocale());
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.messageCollection.add(message);
            }
        });
    }

    public DeletionPreview merge(DeletionPreview other, long deletionThreshold) {
        if (other != null) {
            this.deletionCount = this.deletionCount + other.deletionCount;
            this.requiresConfirmation = this.isRequiresConfirmation(deletionThreshold);
            this.messageCollection.addAll(other.messageCollection);
        }
        return this;
    }

    private boolean isRequiresConfirmation(long deletionThreshold) {
        if (deletionThreshold == 0L) {
            return false;
        }
        return this.deletionCount >= deletionThreshold;
    }

    public Long getDeletionCount() {
        return this.deletionCount;
    }

    public List<String> getMessageCollection() {
        return this.messageCollection;
    }

    public boolean isRequiresConfirmation() {
        return this.requiresConfirmation;
    }
}

