/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationFinder;
import org.squashtest.tm.service.campaign.TestSuiteFinder;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomExportScopeNode;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportCustomExportDto;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;

@Service
@Transactional
public class CustomReportCustomExportServiceImpl
implements CustomReportCustomExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomReportCustomExportServiceImpl.class);
    @Inject
    private CustomCampaignModificationService customCampaignModificationService;
    @Inject
    private IterationFinder iterationFinder;
    @Inject
    private TestSuiteFinder testSuiteFinder;
    @Inject
    private CustomFieldBindingFinderService cufBindingService;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private CampaignFolderDao campaignFolderDao;

    @Override
    public CustomReportCustomExportDto findCustomExportDtoByNodeId(Long customReportLibraryNodeId) {
        CustomReportLibraryNode crln = this.customReportLibraryNodeService.findCustomReportLibraryNodeById(customReportLibraryNodeId);
        if (crln.getEntityType().getTypeName().equals("CUSTOM_EXPORT")) {
            CustomReportCustomExport customExport = (CustomReportCustomExport)crln.getEntity();
            return this.getDtoFromEntity(customExport, customReportLibraryNodeId);
        }
        return null;
    }

    private CustomReportCustomExportDto getDtoFromEntity(CustomReportCustomExport entity, Long libraryNodeId) {
        List scopeEntityRefList = entity.getScope();
        CustomReportCustomExportDto dto = new CustomReportCustomExportDto();
        dto.setId(entity.getId());
        dto.setCustomReportLibraryNodeId(libraryNodeId);
        dto.setProjectId(entity.getProject().getId());
        dto.setName(entity.getName());
        this.setScopeNodesToDto(scopeEntityRefList, dto);
        this.setCustomFieldsOnScope(dto);
        dto.setColumns(entity.getColumns().stream().map(CustomReportCustomExportDto.CustomReportCustomExportColumnDto::from).toList());
        this.doAuditableAttributes(dto, entity);
        return dto;
    }

    private void setScopeNodesToDto(List<EntityReference> scopeEntityRefList, CustomReportCustomExportDto dto) {
        ArrayList<CustomExportScopeNode> scopeNodes = new ArrayList<CustomExportScopeNode>();
        scopeEntityRefList.forEach(entityRef -> this.appendScopeEntityValuesToLists((EntityReference)entityRef, (List<CustomExportScopeNode>)scopeNodes));
        dto.setScopeNodes(scopeNodes);
    }

    private void setCustomFieldsOnScope(CustomReportCustomExportDto dto) {
        List<Long> scopeProjectIds = dto.getScopeNodes().stream().map(CustomExportScopeNode::getProjectId).toList();
        Map<Long, String> cufLabelByIdMap = this.cufBindingService.findCustomFieldLabelsByIdsFromProjectIds(scopeProjectIds);
        dto.setCustomFieldsOnScope(cufLabelByIdMap);
    }

    private void doAuditableAttributes(CustomReportCustomExportDto dto, CustomReportCustomExport entity) {
        CustomReportCustomExport audit = entity;
        dto.setCreatedBy(audit.getCreatedBy());
        dto.setCreatedOn(audit.getCreatedOn());
        dto.setLastModifiedBy(audit.getLastModifiedBy());
        dto.setLastModifiedOn(audit.getLastModifiedOn());
    }

    private void appendScopeEntityValuesToLists(EntityReference entityReference, List<CustomExportScopeNode> scopeNodes) {
        String entityNodeId = entityReference.toNodeId();
        switch (entityReference.getType()) {
            case CAMPAIGN: 
            case CAMPAIGN_FOLDER: {
                this.addLibraryNode(entityReference, scopeNodes, entityNodeId);
                break;
            }
            case ITERATION: {
                this.addIterationNode(entityReference, scopeNodes, entityNodeId);
                break;
            }
            case TEST_SUITE: {
                this.addTestSuiteNode(entityReference, scopeNodes, entityNodeId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Entity of type " + entityReference.getType().name() + " is not supported");
            }
        }
    }

    private void addLibraryNode(EntityReference entityReference, List<CustomExportScopeNode> scopeNodes, String entityNodeId) {
        CampaignLibraryNode libraryNode = this.getCampaignLibraryId(entityReference);
        if (Objects.nonNull(libraryNode)) {
            scopeNodes.add(new CustomExportScopeNode(entityNodeId, libraryNode.getName(), libraryNode.getProject().getId()));
        } else {
            this.logDeletedEntity(entityReference);
        }
    }

    private CampaignLibraryNode getCampaignLibraryId(EntityReference entityReference) {
        return EntityType.CAMPAIGN.equals((Object)entityReference.getType()) ? this.customCampaignModificationService.findCampaigWithExistenceCheck(entityReference.getId()) : (CampaignLibraryNode)this.campaignFolderDao.findById(entityReference.getId());
    }

    private void addTestSuiteNode(EntityReference entityReference, List<CustomExportScopeNode> scopeNodes, String entityNodeId) {
        try {
            TestSuite testSuite = (TestSuite)this.testSuiteFinder.findById(entityReference.getId());
            if (Objects.nonNull(testSuite)) {
                scopeNodes.add(new CustomExportScopeNode(entityNodeId, testSuite.getName(), testSuite.getProject().getId()));
            }
        }
        catch (EntityNotFoundException e) {
            LOGGER.info("Test suite with id {} seems to have been deleted.", new Object[]{entityReference.getId(), e});
        }
    }

    private void addIterationNode(EntityReference entityReference, List<CustomExportScopeNode> scopeNodes, String entityNodeId) {
        Iteration iteration = (Iteration)this.iterationFinder.findById(entityReference.getId());
        if (Objects.nonNull(iteration)) {
            scopeNodes.add(new CustomExportScopeNode(entityNodeId, iteration.getName(), iteration.getProject().getId()));
        } else {
            this.logDeletedEntity(entityReference);
        }
    }

    private void logDeletedEntity(EntityReference entityReference) {
        LOGGER.info("Entity of type {} with id {} seems to have been deleted.", new Object[]{entityReference.getType().name(), entityReference.getId()});
    }
}

